/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import twilightforest.TFFeatureCacheData;

public class TFFeatureCache {
    private final acu chunkManager;
    private int lastSavedSize = 0;
    public static final String fileName = "twilight.fc";
    private lp cacheMap = new lp();
    private ArrayList<TFFeatureCacheData> cache = new ArrayList();

    public TFFeatureCache(acu par1WorldChunkManager) {
        this.chunkManager = par1WorldChunkManager;
    }

    public TFFeatureCacheData getFeatureCacheBlock(int mapX, int mapZ) {
        int chunkX = mapX >> 4;
        int chunkZ = mapZ >> 4;
        long key = (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
        TFFeatureCacheData featureBlock = (TFFeatureCacheData)this.cacheMap.a(key);
        return featureBlock;
    }

    public void addData(int chunkX, int chunkZ, int featureID, int featureStatus) {
        TFFeatureCacheData featureBlock = new TFFeatureCacheData(this, chunkX, chunkZ);
        featureBlock.featureID = (byte)featureID;
        featureBlock.featureStatus = (byte)featureStatus;
        if (!this.addDataToMap(featureBlock)) {
            this.cache.add(featureBlock);
        }
    }

    private boolean addDataToMap(TFFeatureCacheData featureBlock) {
        long key = (long)featureBlock.xPosition & 0xFFFFFFFFL | ((long)featureBlock.zPosition & 0xFFFFFFFFL) << 32;
        boolean exists = this.cacheMap.a(key) != null;
        this.cacheMap.a(key, (Object)featureBlock);
        return exists;
    }

    static acu getChunkManager(TFFeatureCache par0BiomeCache) {
        return par0BiomeCache.chunkManager;
    }

    public void save(File saveDir) {
        if (this.lastSavedSize < this.cache.size()) {
            File saveFile = new File(saveDir, fileName);
            try {
                saveFile.createNewFile();
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(saveFile));
                out.writeObject(this.cache);
                out.close();
                this.lastSavedSize = this.cache.size();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void load(File saveDir) {
        File saveFile = new File(saveDir, fileName);
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(saveFile));
            this.cache = (ArrayList)in.readObject();
            in.close();
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (TFFeatureCacheData block : this.cache) {
            this.addDataToMap(block);
        }
        this.lastSavedSize = this.cache.size();
        if (this.cache.size() == this.cacheMap.a()) {
            FMLLog.info((String)"[TwilightForest] Loaded feature cache with %d chunks present.", (Object[])new Object[]{this.cache.size()});
        } else {
            FMLLog.warning((String)"[TwilightForest] Feature cache mismatch, cache.size=%d, map.elements=%d.", (Object[])new Object[]{this.cache.size(), this.cacheMap.a()});
        }
    }
}

