/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFCReactorActive;
import twilightforest.tileentity.TileEntityTFGhastTrapActive;
import twilightforest.tileentity.TileEntityTFGhastTrapInactive;
import twilightforest.tileentity.TileEntityTFReverter;
import twilightforest.tileentity.TileEntityTFTowerBuilder;

public class BlockTFTowerDevice
extends aqw {
    private static mr TEX_REAPPEARING_INACTIVE;
    private static mr TEX_REAPPEARING_ACTIVE;
    private static mr TEX_VANISH_INACTIVE;
    private static mr TEX_VANISH_ACTIVE;
    private static mr TEX_VANISH_LOCKED;
    private static mr TEX_VANISH_UNLOCKED;
    private static mr TEX_BUILDER_INACTIVE;
    private static mr TEX_BUILDER_ACTIVE;
    private static mr TEX_ANTIBUILDER;
    private static mr TEX_BUILDER_TIMEOUT;
    private static mr TEX_GHASTTRAP_INACTIVE;
    private static mr TEX_GHASTTRAP_ACTIVE;
    private static mr TEX_REACTOR_INACTIVE;
    private static mr TEX_REACTOR_ACTIVE;
    private static mr TEX_GHASTTRAP_LID_INACTIVE;
    private static mr TEX_GHASTTRAP_LID_ACTIVE;
    private static mr TEX_SMOKER_ACTIVE;
    private static mr TEX_SMOKER_INACTIVE;
    private static mr TEX_FIREJET_ACTIVE;
    private static mr TEX_FIREJET_INACTIVE;
    public static final int META_REAPPEARING_INACTIVE = 0;
    public static final int META_REAPPEARING_ACTIVE = 1;
    public static final int META_VANISH_INACTIVE = 2;
    public static final int META_VANISH_ACTIVE = 3;
    public static final int META_VANISH_LOCKED = 4;
    public static final int META_VANISH_UNLOCKED = 5;
    public static final int META_BUILDER_INACTIVE = 6;
    public static final int META_BUILDER_ACTIVE = 7;
    public static final int META_BUILDER_TIMEOUT = 8;
    public static final int META_ANTIBUILDER = 9;
    public static final int META_GHASTTRAP_INACTIVE = 10;
    public static final int META_GHASTTRAP_ACTIVE = 11;
    public static final int META_REACTOR_INACTIVE = 12;
    public static final int META_REACTOR_ACTIVE = 13;

    public BlockTFTowerDevice(int id) {
        super(id, ajz.d);
        this.c(10.0f);
        this.b(35.0f);
        this.a(aqw.h);
        this.a(TFItems.creativeTab);
    }

    public int tickRate() {
        return 15;
    }

    public mr a(int side, int meta) {
        switch (meta) {
            default: {
                return TEX_REAPPEARING_INACTIVE;
            }
            case 1: {
                return TEX_REAPPEARING_ACTIVE;
            }
            case 2: {
                return TEX_VANISH_INACTIVE;
            }
            case 3: {
                return TEX_VANISH_ACTIVE;
            }
            case 4: {
                return TEX_VANISH_LOCKED;
            }
            case 5: {
                return TEX_VANISH_UNLOCKED;
            }
            case 6: {
                return TEX_BUILDER_INACTIVE;
            }
            case 8: {
                return TEX_BUILDER_TIMEOUT;
            }
            case 7: {
                return TEX_BUILDER_ACTIVE;
            }
            case 9: {
                return TEX_ANTIBUILDER;
            }
            case 10: {
                if (side >= 2) {
                    return TEX_GHASTTRAP_INACTIVE;
                }
                if (side == 1) {
                    return TEX_GHASTTRAP_LID_INACTIVE;
                }
                return TFBlocks.towerWood.a(side, 1);
            }
            case 11: {
                if (side >= 2) {
                    return TEX_GHASTTRAP_ACTIVE;
                }
                if (side == 1) {
                    return TEX_GHASTTRAP_LID_ACTIVE;
                }
                return TFBlocks.towerWood.a(side, 1);
            }
            case 12: {
                return TEX_REACTOR_INACTIVE;
            }
            case 13: 
        }
        return TEX_REACTOR_ACTIVE;
    }

    @SideOnly(value=Side.CLIENT)
    public void a(ms par1IconRegister) {
        TEX_REAPPEARING_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_reappearing_off");
        TEX_REAPPEARING_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_reappearing_on");
        TEX_VANISH_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_vanish_off");
        TEX_VANISH_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_vanish_on");
        TEX_VANISH_LOCKED = par1IconRegister.a("TwilightForest:towerdev_lock_on");
        TEX_VANISH_UNLOCKED = par1IconRegister.a("TwilightForest:towerdev_lock_off");
        TEX_BUILDER_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_builder_off");
        TEX_BUILDER_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_builder_on");
        TEX_ANTIBUILDER = par1IconRegister.a("TwilightForest:towerdev_antibuilder");
        TEX_BUILDER_TIMEOUT = par1IconRegister.a("TwilightForest:towerdev_builder_timeout");
        TEX_GHASTTRAP_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_ghasttrap_off");
        TEX_GHASTTRAP_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_ghasttrap_on");
        TEX_REACTOR_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_reactor_off");
        TEX_REACTOR_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_reactor_on");
        TEX_GHASTTRAP_LID_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_ghasttraplid_off");
        TEX_GHASTTRAP_LID_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_ghasttraplid_on");
        TEX_SMOKER_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_smoker_off");
        TEX_SMOKER_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_smoker_on");
        TEX_FIREJET_INACTIVE = par1IconRegister.a("TwilightForest:towerdev_firejet_off");
        TEX_FIREJET_ACTIVE = par1IconRegister.a("TwilightForest:towerdev_firejet_on");
    }

    public void a(int par1, wv par2CreativeTabs, List par3List) {
        par3List.add(new yd(par1, 1, 0));
        par3List.add(new yd(par1, 1, 2));
        par3List.add(new yd(par1, 1, 4));
        par3List.add(new yd(par1, 1, 5));
        par3List.add(new yd(par1, 1, 6));
        par3List.add(new yd(par1, 1, 9));
        par3List.add(new yd(par1, 1, 10));
        par3List.add(new yd(par1, 1, 12));
    }

    public boolean a(abv par1World, int x, int y, int z, ue par5EntityPlayer, int par6, float par7, float par8, float par9) {
        int meta = par1World.h(x, y, z);
        if (meta == 2) {
            if (BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 3);
            }
            return true;
        }
        if (meta == 0) {
            if (BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 1);
            }
            return true;
        }
        return false;
    }

    public float getExplosionResistance(nm par1Entity, abv world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.h(x, y, z);
        if (meta == 2) {
            return 6000.0f;
        }
        if (meta == 4) {
            return 6000000.0f;
        }
        return this.a(par1Entity);
    }

    public float l(abv world, int x, int y, int z) {
        int meta = world.h(x, y, z);
        switch (meta) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return -1.0f;
            }
        }
        return super.l(world, x, y, z);
    }

    public static boolean areNearbyLockBlocks(abv world, int x, int y, int z) {
        boolean locked = false;
        for (int dx = x - 2; dx <= x + 2; ++dx) {
            for (int dy = y - 2; dy <= y + 2; ++dy) {
                for (int dz2 = z - 2; dz2 <= z + 2; ++dz2) {
                    if (world.a(dx, dy, dz2) != TFBlocks.towerDevice.cF || world.h(dx, dy, dz2) != 4) continue;
                    locked = true;
                }
            }
        }
        return locked;
    }

    public static void unlockBlock(abv par1World, int x, int y, int z) {
        int thereBlockID = par1World.a(x, y, z);
        int thereBlockMeta = par1World.h(x, y, z);
        if (thereBlockID == TFBlocks.towerDevice.cF || thereBlockMeta == 4) {
            BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 5);
            par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
    }

    private static void changeToBlockMeta(abv par1World, int x, int y, int z, int meta) {
        int thereBlockID = par1World.a(x, y, z);
        if (thereBlockID == TFBlocks.towerDevice.cF || thereBlockID == TFBlocks.towerTranslucent.cF) {
            par1World.f(x, y, z, thereBlockID, meta, 3);
            par1World.g(x, y, z, x, y, z);
            par1World.f(x, y, z, thereBlockID);
        }
    }

    public void a(abv par1World, int x, int y, int z) {
        int meta = par1World.h(x, y, z);
        if (!par1World.I && meta == 6 && par1World.C(x, y, z)) {
            BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 7);
            par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
    }

    public void a(abv par1World, int x, int y, int z, int myBlockID) {
        int meta = par1World.h(x, y, z);
        if (!par1World.I) {
            if (meta == 2 && par1World.C(x, y, z) && !BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 3);
            }
            if (meta == 0 && par1World.C(x, y, z) && !BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 1);
            }
            if (meta == 6 && par1World.C(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 7);
                par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
                par1World.a(x, y, z, this.cF, 4);
            }
            if (meta == 7 && !par1World.C(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 6);
                par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
                par1World.a(x, y, z, this.cF, 4);
            }
            if (meta == 8 && !par1World.C(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 6);
            }
            if (meta == 10 && this.isInactiveTrapCharged(par1World, x, y, z) && par1World.C(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 11);
                par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
                par1World.a(x, y, z, this.cF, 4);
            }
            if (meta == 12 && this.isReactorReady(par1World, x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 13);
            }
        }
    }

    public void a(abv par1World, int x, int y, int z, Random par5Random) {
        if (!par1World.I) {
            int meta = par1World.h(x, y, z);
            if (meta == 3 || meta == 1) {
                if (meta == 3) {
                    par1World.f(x, y, z, 0, 0, 3);
                } else {
                    par1World.f(x, y, z, TFBlocks.towerTranslucent.cF, 0, 3);
                    par1World.a(x, y, z, TFBlocks.towerTranslucent.cF, 80);
                }
                par1World.f(x, y, z, this.cF);
                par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.3f, 0.5f);
                par1World.g(x, y, z, x, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x - 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x + 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y + 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y - 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z + 1);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z - 1);
            }
            if (meta == 7 && par1World.C(x, y, z)) {
                this.letsBuild(par1World, x, y, z);
            }
            if (meta == 6 || meta == 8) {
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x - 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x + 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y + 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y - 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z + 1);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z - 1);
            }
        }
    }

    private void letsBuild(abv par1World, int x, int y, int z) {
        bf blockSource = new bf(par1World, x, y, z);
        TileEntityTFTowerBuilder tileEntity = (TileEntityTFTowerBuilder)blockSource.j();
        if (tileEntity != null && !tileEntity.makingBlocks) {
            tileEntity.startBuilding();
        }
    }

    private boolean isInactiveTrapCharged(abv par1World, int x, int y, int z) {
        bf blockSource = new bf(par1World, x, y, z);
        TileEntityTFGhastTrapInactive tileEntity = (TileEntityTFGhastTrapInactive)blockSource.j();
        return tileEntity != null && tileEntity.isCharged();
    }

    private boolean isReactorReady(abv world, int x, int y, int z) {
        return world.a(x, y + 1, z) == aqw.ct.cF && world.a(x, y - 1, z) == aqw.ct.cF && world.a(x + 1, y, z) == aqw.ct.cF && world.a(x - 1, y, z) == aqw.ct.cF && world.a(x, y, z + 1) == aqw.ct.cF && world.a(x, y, z - 1) == aqw.ct.cF;
    }

    @SideOnly(value=Side.CLIENT)
    public void b(abv par1World, int x, int y, int z, Random par5Random) {
        block4: {
            block3: {
                int meta = par1World.h(x, y, z);
                if (meta == 3 || meta == 1) break block3;
                if (meta != 7) break block4;
            }
            for (int i = 0; i < 1; ++i) {
                this.sparkle(par1World, x, y, z, par5Random);
            }
        }
    }

    public void sparkle(abv world, int x, int y, int z, Random rand) {
        double offset = 0.0625;
        for (int side = 0; side < 6; ++side) {
            double rx = (float)x + rand.nextFloat();
            double ry = (float)y + rand.nextFloat();
            double rz = (float)z + rand.nextFloat();
            if (side == 0 && !world.t(x, y + 1, z)) {
                ry = (double)(y + 1) + offset;
            }
            if (side == 1 && !world.t(x, y - 1, z)) {
                ry = (double)(y + 0) - offset;
            }
            if (side == 2 && !world.t(x, y, z + 1)) {
                rz = (double)(z + 1) + offset;
            }
            if (side == 3 && !world.t(x, y, z - 1)) {
                rz = (double)(z + 0) - offset;
            }
            if (side == 4 && !world.t(x + 1, y, z)) {
                rx = (double)(x + 1) + offset;
            }
            if (side == 5 && !world.t(x - 1, y, z)) {
                rx = (double)(x + 0) - offset;
            }
            if (!(rx < (double)x || rx > (double)(x + 1) || ry < 0.0 || ry > (double)(y + 1) || rz < (double)z) && !(rz > (double)(z + 1))) continue;
            world.a("reddust", rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }

    public static void checkAndActivateVanishBlock(abv world, int x, int y, int z) {
        int thereID = world.a(x, y, z);
        int thereMeta = world.h(x, y, z);
        if (!(thereID != TFBlocks.towerDevice.cF || thereMeta != 2 && thereMeta != 5 || BlockTFTowerDevice.areNearbyLockBlocks(world, x, y, z))) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, x, y, z, 3);
        } else if (thereID == TFBlocks.towerDevice.cF && thereMeta == 0 && !BlockTFTowerDevice.areNearbyLockBlocks(world, x, y, z)) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, x, y, z, 1);
        } else if (thereID == TFBlocks.towerTranslucent.cF && thereMeta == 2) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, x, y, z, 3);
        }
    }

    public static void changeToActiveVanishBlock(abv par1World, int x, int y, int z, int meta) {
        BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, meta);
        par1World.a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.3f, 0.6f);
        int thereBlockID = par1World.a(x, y, z);
        par1World.a(x, y, z, thereBlockID, BlockTFTowerDevice.getTickRateFor(thereBlockID, meta, par1World.s));
    }

    private static int getTickRateFor(int thereBlockID, int meta, Random rand) {
        if (thereBlockID == TFBlocks.towerDevice.cF && (meta == 3 || meta == 1)) {
            return 2 + rand.nextInt(5);
        }
        if (thereBlockID == TFBlocks.towerTranslucent.cF && meta == 3) {
            return 10;
        }
        return 15;
    }

    public int getLightValue(ace world, int x, int y, int z) {
        int blockID = world.a(x, y, z);
        int meta = world.h(x, y, z);
        if (blockID != this.cF) {
            return 0;
        }
        switch (meta) {
            case 1: 
            case 3: 
            case 7: {
                return 4;
            }
            case 9: {
                return 10;
            }
            case 11: 
            case 13: {
                return 15;
            }
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 7 || metadata == 9 || metadata == 13 || metadata == 10 || metadata == 11;
    }

    public asm createTileEntity(abv world, int metadata) {
        if (metadata == 7) {
            return new TileEntityTFTowerBuilder();
        }
        if (metadata == 9) {
            return new TileEntityTFReverter();
        }
        if (metadata == 10) {
            return new TileEntityTFGhastTrapInactive();
        }
        if (metadata == 11) {
            return new TileEntityTFGhastTrapActive();
        }
        if (metadata == 13) {
            return new TileEntityTFCReactorActive();
        }
        return null;
    }

    public int a(int meta, Random par2Random, int par3) {
        switch (meta) {
            case 9: {
                return 0;
            }
        }
        return this.cF;
    }

    public int a(int meta) {
        switch (meta) {
            case 1: {
                return 0;
            }
            case 7: 
            case 8: {
                return 6;
            }
            case 3: {
                return 2;
            }
            case 11: {
                return 10;
            }
            case 13: {
                return 12;
            }
        }
        return meta;
    }

    public void a(abv par1World, int x, int y, int z, int par5, int meta) {
        super.a(par1World, x, y, z, par5, meta);
        if (meta == 7) {
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x - 1, y, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x + 1, y, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y + 1, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y - 1, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z + 1);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z - 1);
        }
    }
}

