/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.world.TFGenHollowTree;

public class TFGenHollowStump
extends TFGenHollowTree {
    @Override
    public boolean a(abv world, Random rand, int x, int y, int z2) {
        int radius = rand.nextInt(2) + 2;
        if (!this.isAreaClear(world, rand, x - radius, y, z2 - radius, 2 * radius, 6, 2 * radius)) {
            return false;
        }
        this.buildTrunk(world, rand, x, y, z2, radius, 6);
        this.buildBranchRing(world, rand, x, y, z2, radius, 3, 2, 6, 0, 0.75, 0.0, 3, 5, 3, false);
        this.buildBranchRing(world, rand, x, y, z2, radius, 1, 2, 8, 0, 0.9, 0.0, 3, 5, 3, false);
        return true;
    }

    @Override
    protected void buildTrunk(abv world, Random random, int x, int y, int z2, int diameter, int maxHeight) {
        int dz2;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz2 = -diameter; dz2 <= diameter; ++dz2) {
                for (int dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz2)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    if (this.hasAirAround((ace)world, dx + x, dy + y, dz2 + z2)) {
                        this.a(world, dx + x, dy + y, dz2 + z2, this.treeBlock, dist > hollow ? this.treeMeta : this.branchMeta);
                        continue;
                    }
                    this.a(world, dx + x, dy + y, dz2 + z2, this.rootBlock, this.rootMeta);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz2 = -diameter; dz2 <= diameter; ++dz2) {
                int height = 2 + random.nextInt(3) + random.nextInt(2);
                for (int dy = 0; dy <= height; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz2)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter || dist <= hollow) continue;
                    this.putBlockAndMetadata(world, dx + x, dy + y, dz2 + z2, this.treeBlock, this.treeMeta, true);
                }
            }
        }
    }
}

