/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFCreatures;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenHollowTree
extends TFGenerator {
    private static final int LEAF_DUNGEON_CHANCE = 8;
    protected int treeBlock;
    protected int treeMeta;
    protected int branchMeta;
    protected int leafBlock;
    protected int leafMeta;
    protected int rootBlock;
    protected int rootMeta;

    public TFGenHollowTree() {
        this(false);
    }

    public TFGenHollowTree(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log.cF;
        this.treeMeta = 0;
        this.branchMeta = 12;
        this.leafBlock = TFBlocks.leaves.cF;
        this.leafMeta = 0;
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
    }

    @Override
    public boolean a(abv world, Random random, int x, int y, int z2) {
        double fAngle;
        int fHeight;
        int i;
        long startTime = System.currentTimeMillis();
        int height = random.nextInt(64) + 32;
        int diameter = random.nextInt(4) + 1;
        if (y < 1 || y + height + diameter > TFWorld.MAXHEIGHT) {
            return false;
        }
        int crownRadius = diameter * 4 + 8;
        for (int dx = -crownRadius; dx <= crownRadius; ++dx) {
            for (int dz2 = -crownRadius; dz2 <= crownRadius; ++dz2) {
                for (int dy = height - crownRadius; dy <= height + crownRadius; ++dy) {
                    int whatsThere = world.a(dx + x, dy + y, dz2 + z2);
                    if (whatsThere == 0 || whatsThere == aqw.P.cF) continue;
                    return false;
                }
            }
        }
        int j1 = world.a(x, y - 1, z2);
        if (j1 != aqw.z.cF && j1 != aqw.A.cF) {
            return false;
        }
        this.buildTrunk(world, random, x, y, z2, diameter, height);
        int numFireflies = random.nextInt(3 * diameter) + 5;
        for (i = 0; i <= numFireflies; ++i) {
            fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            fAngle = random.nextDouble();
            this.addFirefly(world, x, y, z2, diameter, fHeight, fAngle);
        }
        numFireflies = random.nextInt(3 * diameter) + 5;
        for (i = 0; i <= numFireflies; ++i) {
            fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            fAngle = random.nextDouble();
            this.addCicada(world, x, y, z2, diameter, fHeight, fAngle);
        }
        this.buildFullCrown(world, random, x, y, z2, diameter, height);
        int numBranches = random.nextInt(3) + 3;
        for (int i2 = 0; i2 <= numBranches; ++i2) {
            int branchHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            double branchRotation = random.nextDouble();
            this.makeSmallBranch(world, random, x, y, z2, diameter, branchHeight, 4.0, branchRotation, 0.35, true);
        }
        this.buildBranchRing(world, random, x, y, z2, diameter, 3, 2, 6, 0, 0.75, 0.0, 3, 5, 3, false);
        this.buildBranchRing(world, random, x, y, z2, diameter, 1, 2, 8, 0, 0.9, 0.0, 3, 5, 3, false);
        return true;
    }

    protected void buildFullCrown(abv world, Random random, int x, int y, int z2, int diameter, int height) {
        int crownRadius = diameter * 4 + 4;
        int bvar = diameter + 2;
        this.buildBranchRing(world, random, x, y, z2, diameter, height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 2, true);
        this.buildBranchRing(world, random, x, y, z2, diameter, height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, x, y, z2, diameter, height, 0, crownRadius, 0, 0.15, 0.0, 2, 4, 2, true);
        this.buildBranchRing(world, random, x, y, z2, diameter, height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 1, true);
    }

    protected void buildWeakCrown(abv world, Random random, int x, int y, int z2, int diameter, int height) {
        int crownRadius = 8;
        int bvar = 2;
        this.buildBranchRing(world, random, x, y, z2, diameter, height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, x, y, z2, diameter, height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, x, y, z2, diameter, height, 0, crownRadius, 0, 0.15, 0.0, 2, 4, 1, true);
        this.buildBranchRing(world, random, x, y, z2, diameter, height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 1, true);
    }

    protected void buildBranchRing(abv world, Random random, int x, int y, int z2, int diameter, int branchHeight, int heightVar, int length, int lengthVar, double tilt, double tiltVar, int minBranches, int maxBranches, int size, boolean leafy) {
        int numBranches = random.nextInt(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.nextDouble();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.nextInt(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(world, random, x, y, z2, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch(world, random, x, y, z2, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                continue;
            }
            if (size == 3) {
                this.makeRoot(world, random, x, y, z2, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt);
                continue;
            }
            this.makeSmallBranch(world, random, x, y, z2, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
        }
    }

    protected void buildTrunk(abv world, Random random, int x, int y, int z2, int diameter, int height) {
        int dist;
        int az;
        int ax;
        int dy;
        int dz2;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz2 = -diameter; dz2 <= diameter; ++dz2) {
                for (dy = -4; dy < 0; ++dy) {
                    ax = Math.abs(dx);
                    dist = (int)((double)Math.max(ax, az = Math.abs(dz2)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    if (this.hasAirAround((ace)world, dx + x, dy + y, dz2 + z2)) {
                        this.a(world, dx + x, dy + y, dz2 + z2, this.treeBlock, dist > hollow ? this.treeMeta : this.branchMeta);
                        continue;
                    }
                    this.a(world, dx + x, dy + y, dz2 + z2, this.rootBlock, this.rootMeta);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz2 = -diameter; dz2 <= diameter; ++dz2) {
                for (dy = 0; dy <= height; ++dy) {
                    ax = Math.abs(dx);
                    dist = (int)((double)Math.max(ax, az = Math.abs(dz2)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= diameter && dist > hollow) {
                        this.putBlockAndMetadata(world, dx + x, dy + y, dz2 + z2, this.treeBlock, this.treeMeta, true);
                    }
                    if (dist <= hollow) {
                        // empty if block
                    }
                    if (dist != hollow || dx != hollow) continue;
                    this.putBlockAndMetadata(world, dx + x, dy + y, dz2 + z2, aqw.bz.cF, 8, true);
                }
            }
        }
    }

    protected void makeMedBranch(abv world, Random random, int x, int y, int z2, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        int sx = x;
        int sy = y + branchHeight;
        int sz = z2;
        int[] src = TFGenHollowTree.translate(sx, sy, sz, diameter, angle, 0.5);
        this.makeMedBranch(world, random, src[0], src[1], src[2], length, angle, tilt, leafy);
    }

    protected void makeMedBranch(abv world, Random random, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        int[] src = new int[]{sx, sy, sz};
        int[] dest = TFGenHollowTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        if (leafy) {
            this.drawBlob(world, dest[0], dest[1], dest[2], 2, this.leafBlock, this.leafMeta, false);
        }
        int numShoots = random.nextInt(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.nextDouble() * 0.8 + 0.2;
            double tiltVar = random.nextDouble() * 0.75 + 0.15;
            int[] bsrc = TFGenHollowTree.translate(src[0], src[1], src[2], length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, random, bsrc[0], bsrc[1], bsrc[2], slength, angle + angleVar, tilt * tiltVar, leafy);
        }
    }

    protected void makeSmallBranch(abv world, Random random, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        int[] src = new int[]{sx, sy, sz};
        int[] dest = TFGenHollowTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        if (leafy) {
            byte leafRad = (byte)(random.nextInt(2) + 1);
            this.drawBlob(world, dest[0], dest[1], dest[2], leafRad, this.leafBlock, this.leafMeta, false);
        }
    }

    protected void makeSmallBranch(abv world, Random random, int x, int y, int z2, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        int sx = x;
        int sy = y + branchHeight;
        int sz = z2;
        int[] src = TFGenHollowTree.translate(sx, sy, sz, diameter, angle, 0.5);
        this.makeSmallBranch(world, random, src[0], src[1], src[2], length, angle, tilt, leafy);
    }

    protected void makeRoot(abv world, Random random, int x, int y, int z2, int diameter, int branchHeight, double length, double angle, double tilt) {
        int[] src = TFGenHollowTree.translate(x, y + branchHeight, z2, diameter, angle, 0.5);
        int[] dest = TFGenHollowTree.translate(src[0], src[1], src[2], length, angle, tilt);
        int[] lineArray = TFGenHollowTree.getBresehnamArray(src[0], src[1], src[2], dest[0], dest[1], dest[2]);
        boolean stillAboveGround = true;
        for (int i = 0; i < lineArray.length; i += 3) {
            if (stillAboveGround && this.hasAirAround((ace)world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2])) {
                this.a(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.treeBlock, this.branchMeta);
                this.a(world, lineArray[i + 0], lineArray[i + 1] - 1, lineArray[i + 2], this.treeBlock, this.branchMeta);
                continue;
            }
            this.a(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.rootBlock, this.rootMeta);
            this.a(world, lineArray[i + 0], lineArray[i + 1] - 1, lineArray[i + 2], this.rootBlock, this.rootMeta);
            stillAboveGround = false;
        }
    }

    protected void makeLargeBranch(abv world, Random random, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        int[] src = new int[]{sx, sy, sz};
        int[] dest = TFGenHollowTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        int reinforcements = random.nextInt(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            this.drawBresehnam(world, src[0] + vx, src[1] + vy, src[2] + vz, dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        }
        if (leafy) {
            this.drawBlob(world, dest[0], dest[1] + 1, dest[2], 3, this.leafBlock, this.leafMeta, false);
        }
        int numMedBranches = random.nextInt((int)(length / 6.0)) + random.nextInt(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.nextDouble() * 0.3 + 0.3;
            double angleVar = random.nextDouble() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            int[] bsrc = TFGenHollowTree.translate(src[0], src[1], src[2], length * outVar, angle, tilt);
            this.makeMedBranch(world, random, bsrc[0], bsrc[1], bsrc[2], length * 0.6, angle + angleVar, tilt, leafy);
        }
        int numSmallBranches = random.nextInt(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.nextDouble() * 0.25 + 0.25;
            double angleVar = random.nextDouble() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            int[] bsrc = TFGenHollowTree.translate(src[0], src[1], src[2], length * outVar, angle, tilt);
            this.makeSmallBranch(world, random, bsrc[0], bsrc[1], bsrc[2], Math.max(length * 0.3, 2.0), angle + angleVar, tilt, leafy);
        }
        if (random.nextInt(8) == 0) {
            this.makeLeafDungeon(world, random, dest[0], dest[1] + 1, dest[2]);
        }
    }

    private void makeLeafDungeon(abv world, Random random, int x, int y, int z2) {
        this.drawBlob(world, x, y, z2, 4, this.leafBlock, this.leafMeta, true);
        this.drawBlob(world, x, y, z2, 3, this.treeBlock, this.branchMeta, true);
        this.drawBlob(world, x, y, z2, 2, 0, 0, true);
        world.f(x + 0, y + 1, z2 + 0, aqw.ax.cF, 0, 2);
        asg ms2 = (asg)world.r(x + 0, y + 1, z2 + 0);
        if (ms2 != null) {
            ms2.a().a(TFCreatures.getSpawnerNameFor("Swarm Spider"));
        }
        this.makeLeafDungeonChest(world, random, x, y, z2);
    }

    private void makeLeafDungeonChest(abv world, Random random, int x, int y, int z2) {
        int dir = random.nextInt(4);
        x += r.a[dir];
        z2 += r.b[dir];
        TFTreasure.tree_cache.generate(world, random, x += r.a[dir], y - 1, z2 += r.b[dir]);
    }

    protected void makeLargeBranch(abv world, Random random, int x, int y, int z2, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        int sx = x;
        int sy = y + branchHeight;
        int sz = z2;
        int[] src = TFGenHollowTree.translate(sx, sy, sz, diameter, angle, 0.5);
        this.makeLargeBranch(world, random, src[0], src[1], src[2], length, angle, tilt, leafy);
    }

    protected void addFirefly(abv world, int x, int y, int z2, int diameter, int fHeight, double fAngle) {
        int[] src = TFGenHollowTree.translate(x, y + fHeight, z2, diameter + 1, fAngle, 0.5);
        int tmeta = 0;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            tmeta = 3;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            tmeta = 1;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            tmeta = 4;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            tmeta = 2;
        }
        if (TFBlocks.firefly.c(world, src[0], src[1], src[2])) {
            this.putBlockAndMetadata(world, src[0], src[1], src[2], TFBlocks.firefly.cF, tmeta, false);
        }
    }

    protected void addCicada(abv world, int x, int y, int z2, int diameter, int fHeight, double fAngle) {
        int[] src = TFGenHollowTree.translate(x, y + fHeight, z2, diameter + 1, fAngle, 0.5);
        int tmeta = 1;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            tmeta = 3;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            tmeta = 1;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            tmeta = 4;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            tmeta = 2;
        }
        if (TFBlocks.cicada.c(world, src[0], src[1], src[2])) {
            this.putBlockAndMetadata(world, src[0], src[1], src[2], TFBlocks.cicada.cF, tmeta, false);
        }
    }
}

