/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import de.vernideas.mc.common.ai.GuardAI;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.common.util.TimePeriod;
import de.vernideas.mc.taverns.Settings;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.gen.ComponentVillageBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.ComponentVillageStartPiece;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.ForgeDirection;

public class ComponentVillageBarn
extends ComponentVillageBase {
    public static boolean initialized = false;
    private static final int HEIGHT = 6;
    private int averageGroundLevel = -1;
    private boolean hasExtension = false;
    private int woolColor = 0;
    private int sheepSpawned = 0;
    private boolean villagerSpawned = false;

    public static void init(Settings config) {
        if (!initialized) {
            initialized = true;
        }
    }

    public static Object buildComponent(ComponentVillageStartPiece startPiece, List pieces, Random random, int x, int y, int z, int direction, int type) {
        boolean extendedBuilding = random.nextInt(3) == 0;
        StructureBoundingBox structBB = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)(extendedBuilding ? 13 : 9), (int)6, (int)7, (int)direction);
        if (ComponentVillageBarn.func_74895_a((StructureBoundingBox)structBB) && null == StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structBB)) {
            return new ComponentVillageBarn(startPiece, type, random, structBB, direction, extendedBuilding);
        }
        return null;
    }

    public ComponentVillageBarn(ComponentVillageStartPiece startPiece, int pieces, Random rnd, StructureBoundingBox structBB, int direction, boolean extension) {
        super(startPiece, pieces);
        this.field_74885_f = direction;
        this.field_74887_e = structBB;
        this.hasExtension = extension;
        this.woolColor = rnd.nextInt(16);
        this.sheepSpawned = rnd.nextInt(2);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bb) {
        int xx;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, bb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 6 - 2, 0);
        }
        int width = this.hasExtension ? 13 : 9;
        BiomeGenBase biome = this.field_74897_k == null ? null : this.field_74897_k.biome;
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Block.field_71988_x, 0, biome);
        BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Block.field_71978_w, 0, biome);
        BiomeSpecificBlock dirt = BiomeSpecificBlock.query(Block.field_71979_v, 0, biome);
        BiomeSpecificBlock grass = BiomeSpecificBlock.queryVanilla((Block)Block.field_71980_u, 0, null);
        BiomeSpecificBlock gravel = BiomeSpecificBlock.query(Block.field_71940_F, 0, biome);
        BiomeSpecificBlock woodUp = BiomeSpecificBlock.query(Block.field_71951_J, 0, biome);
        BiomeSpecificBlock fence = BiomeSpecificBlock.query(Block.field_72031_aZ, 0, biome);
        BiomeSpecificBlock woodSlabDown = this.getWoodSlab(0, ForgeDirection.DOWN, biome);
        BiomeSpecificBlock woodSlabUp = this.getWoodSlab(0, ForgeDirection.UP, biome);
        BiomeSpecificBlock glassPane = BiomeSpecificBlock.query(Block.field_72003_bq, 0, biome);
        BiomeSpecificBlock roofEast = this.getSpecificBlock(Block.field_72063_at, ForgeDirection.EAST, biome);
        BiomeSpecificBlock roofWest = this.getSpecificBlock(Block.field_72063_at, ForgeDirection.WEST, biome);
        this.fill(world, bb, 0, 0, 0, width - 1, 5, 6, BiomeSpecificBlock.air, BiomeSpecificBlock.air, false);
        for (xx = 0; xx < width; ++xx) {
            for (int zz = 0; zz < 7; ++zz) {
                this.func_74871_b(world, xx, 0, zz, bb);
                this.fillDownwards(world, Block.field_71978_w, 0, xx, -1, zz, bb);
            }
        }
        this.fill(world, bb, 0, 0, 0, width - 1, 0, 6, dirt, dirt);
        this.fill(world, bb, 2, 0, 2, 6, 0, 4, grass, grass);
        this.fill(world, bb, 3, 0, 0, 5, 0, 0, gravel, gravel);
        this.placeTorch(world, bb, 3, 2, 1, ForgeDirection.DOWN);
        this.placeTorch(world, bb, 5, 2, 1, ForgeDirection.DOWN);
        this.placeTorch(world, bb, 0, 2, 5, ForgeDirection.WEST);
        this.placeTorch(world, bb, 8, 2, 5, ForgeDirection.EAST);
        this.placeTorch(world, bb, 1, 2, 6, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 7, 2, 6, ForgeDirection.NORTH);
        this.fill(world, bb, 1, 1, 1, 7, 1, 1, fence, fence);
        this.fill(world, bb, 2, 1, 5, 6, 1, 5, fence, fence);
        this.fill(world, bb, 1, 1, 2, 1, 1, 4, fence, fence);
        this.fill(world, bb, 7, 1, 2, 7, 1, 4, fence, fence);
        this.placeBlock(world, Block.field_71993_bv, ForgeDirection.SOUTH, 4, 1, 1, bb);
        this.placeBlock(world, woodUp, 1, 1, 5, bb);
        this.placeBlock(world, woodUp, 7, 1, 5, bb);
        this.placeBlock(world, fence, 1, 2, 1, bb);
        this.placeBlock(world, fence, 1, 3, 1, bb);
        this.placeBlock(world, fence, 7, 2, 1, bb);
        this.placeBlock(world, fence, 7, 3, 1, bb);
        this.placeBlock(world, planks, 1, 2, 5, bb);
        this.placeBlock(world, planks, 7, 2, 5, bb);
        this.placeBlock(world, woodSlabDown, 1, 4, 1, bb);
        this.placeBlock(world, Block.field_72101_ab, 0, 2, 4, 1, bb);
        this.placeBlock(world, Block.field_72101_ab, this.woolColor, 3, 4, 1, bb);
        this.placeBlock(world, Block.field_72101_ab, 0, 4, 4, 1, bb);
        this.placeBlock(world, Block.field_72101_ab, this.woolColor, 5, 4, 1, bb);
        this.placeBlock(world, Block.field_72101_ab, 0, 6, 4, 1, bb);
        this.placeBlock(world, woodSlabDown, 7, 4, 1, bb);
        for (xx = 1; xx <= 7; ++xx) {
            this.placeBlock(world, woodSlabDown, xx, 4, 2, bb);
            this.placeBlock(world, woodSlabUp, xx, 3, 3, bb);
            this.placeBlock(world, woodSlabDown, xx, 3, 4, bb);
        }
        for (xx = 2; xx <= 6; ++xx) {
            this.placeBlock(world, woodSlabUp, xx, 2, 5, bb);
        }
        this.sheepSpawned += this.spawnEntity(world, bb, 3, 1, 3, 1 - this.sheepSpawned);
        this.sheepSpawned += this.spawnEntity(world, bb, 5, 1, 3, 2 - this.sheepSpawned);
        if (this.hasExtension) {
            EntityVillager villager;
            this.placeTorch(world, bb, 9, 4, 0, ForgeDirection.SOUTH);
            this.placeTorch(world, bb, 8, 4, 3, ForgeDirection.EAST);
            this.fill(world, bb, 7, 1, 1, 11, 1, 5, cobble, cobble);
            this.placeBlock(world, (Block)Block.field_72079_ak, 3, 7, 1, 3, bb);
            this.placeBlock(world, Block.field_72057_aH, ForgeDirection.NORTH, 9, 1, 0, bb);
            this.placeBlock(world, Block.field_72057_aH, ForgeDirection.EAST, 8, 1, 0, bb);
            this.placeBlock(world, Block.field_72057_aH, ForgeDirection.WEST, 10, 1, 0, bb);
            for (int yy = 2; yy <= 4; ++yy) {
                this.placeBlock(world, woodUp, 7, yy, 1, bb);
                this.placeBlock(world, planks, 8, yy, 1, bb);
                this.placeBlock(world, planks, 10, yy, 1, bb);
                this.placeBlock(world, woodUp, 11, yy, 1, bb);
                this.placeBlock(world, woodUp, 7, yy, 5, bb);
                this.placeBlock(world, woodUp, 11, yy, 5, bb);
                this.placeBlock(world, planks, 7, yy, 2, bb);
                this.placeBlock(world, planks, 7, yy, 4, bb);
            }
            this.fill(world, bb, 8, 2, 5, 10, 4, 5, planks, planks);
            this.fill(world, bb, 11, 2, 2, 11, 4, 4, planks, planks);
            this.placeBlock(world, planks, 9, 4, 1, bb);
            this.placeBlock(world, planks, 7, 4, 3, bb);
            this.placeAir(world, 7, 3, 3, bb);
            for (xx = 8; xx <= 10; ++xx) {
                this.placeBlock(world, woodUp, xx, 5, 1, bb);
                this.placeBlock(world, woodUp, xx, 5, 5, bb);
            }
            this.placeBlock(world, glassPane, 9, 3, 5, bb);
            this.placeBlock(world, glassPane, 11, 3, 3, bb);
            this.placeDoor(world, bb, random, 9, 2, 1, ForgeDirection.SOUTH);
            for (int zz = 1; zz <= 5; ++zz) {
                this.placeBlock(world, roofEast, 7, 5, zz, bb);
                this.placeBlock(world, roofWest, 11, 5, zz, bb);
                this.placeBlock(world, woodSlabDown, 8, 6, zz, bb);
                this.placeBlock(world, planks, 9, 6, zz, bb);
                this.placeBlock(world, woodSlabDown, 10, 6, zz, bb);
            }
            if (!this.villagerSpawned && null != (villager = this.spawnVillager(world, bb, 9, 2, 3))) {
                this.villagerSpawned = true;
                int globalX = this.func_74865_a(9, 3);
                int globalY = this.func_74862_a(2);
                int globalZ = this.func_74873_b(9, 3);
                villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new GuardAI((EntityLiving)villager, new ChunkCoordinates(globalX, globalY, globalZ), 5.0f, 48.0f, new TimePeriod(0.02, 0.45), false));
            }
        }
        return true;
    }

    protected int func_74888_b(int alreadySpawned) {
        return Taverns.config.shepherdessID > 0 ? Taverns.config.shepherdessID : super.func_74888_b(alreadySpawned);
    }

    @Override
    protected EntityLivingBase getEntity(World world, int index) {
        return new EntitySheep(world);
    }
}

