/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import biomesoplenty.api.BlockReferences;
import biomesoplenty.api.Blocks;
import com.google.common.collect.Sets;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.direction.Dir;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.ComponentVillage;
import net.minecraft.world.gen.structure.ComponentVillageStartPiece;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ComponentVillageBase
extends ComponentVillage {
    private Map<Integer, Block> biomesOPlentyStairMapping = null;
    private Map<Integer, Pair<Block, Integer>> biomesOPlentyWoodslabMapping = null;
    private Set<Block> stairBlocks = Sets.newHashSet((Object[])new Block[]{Block.field_71992_bw, Block.field_72057_aH, Block.field_72100_bC, Block.field_94338_cu, Block.field_72088_bQ, Block.field_71995_bx, Block.field_72072_bX, Block.field_72070_bY, Block.field_72063_at, Block.field_72074_bW});

    protected ComponentVillageBase(ComponentVillageStartPiece startPiece, int orient) {
        super(startPiece, orient);
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block placeBlock, Block replaceBlock, boolean alwaysreplace) {
        this.func_74884_a(worldObj, structBB, minX, minY, minZ, maxX, maxY, maxZ, placeBlock.field_71990_ca, replaceBlock.field_71990_ca, alwaysreplace);
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BiomeSpecificBlock placeBlock, BiomeSpecificBlock replaceBlock, boolean alwaysreplace) {
        this.func_74872_a(worldObj, structBB, minX, minY, minZ, maxX, maxY, maxZ, placeBlock.blockID, placeBlock.metadata, replaceBlock.blockID, replaceBlock.metadata, alwaysreplace);
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block placeBlock, Block replaceBlock) {
        this.func_74884_a(worldObj, structBB, minX, minY, minZ, maxX, maxY, maxZ, placeBlock.field_71990_ca, replaceBlock.field_71990_ca, false);
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BiomeSpecificBlock placeBlock, BiomeSpecificBlock replaceBlock) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) {
                        this.placeBlock(worldObj, replaceBlock, x, y, z, structBB);
                        continue;
                    }
                    this.placeBlock(worldObj, placeBlock, x, y, z, structBB);
                }
            }
        }
    }

    protected void fillRandomly(World world, StructureBoundingBox structBB, Random rnd, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block placeBlock, Block replaceBlock) {
        this.func_74880_a(world, structBB, rnd, chance, minX, minY, minZ, maxX, maxY, maxZ, placeBlock.field_71990_ca, replaceBlock.field_71990_ca, false);
    }

    protected void fillRandomly(World worldObj, StructureBoundingBox structBB, Random rnd, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BiomeSpecificBlock placeBlock, BiomeSpecificBlock replaceBlock) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(rnd.nextFloat() <= chance)) continue;
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) {
                        this.placeBlock(worldObj, replaceBlock, x, y, z, structBB);
                        continue;
                    }
                    this.placeBlock(worldObj, placeBlock, x, y, z, structBB);
                }
            }
        }
    }

    protected void fillDownwards(World world, Block block, int par3, int xx, int par5, int zz, StructureBoundingBox structBB) {
        this.func_74870_b(world, block.field_71990_ca, par3, xx, par5, zz, structBB);
    }

    protected void placeBlock(World world, Block block, int metadata, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        this.func_74864_a(world, block.field_71990_ca, metadata, posX, posY, posZ, structBB);
    }

    protected void placeBlock(World world, Block block, ForgeDirection dir, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        this.func_74864_a(world, block.field_71990_ca, Dir.getMeta(block, dir, this.field_74885_f), posX, posY, posZ, structBB);
    }

    protected void placeBlock(World world, BiomeSpecificBlock block, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        int globalZ;
        int globalY;
        int globalX = this.func_74865_a(posX, posZ);
        if (structBB.func_78890_b(globalX, globalY = this.func_74862_a(posY), globalZ = this.func_74873_b(posX, posZ))) {
            world.func_72832_d(globalX, globalY, globalZ, block.blockID, block.metadata, 2);
        }
    }

    protected void placeAir(World world, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        this.func_74864_a(world, 0, 0, posX, posY, posZ, structBB);
    }

    protected void placeDoor(World world, StructureBoundingBox structBB, Random rnd, int posX, int posY, int posZ, ForgeDirection dir) {
        this.func_74881_a(world, structBB, rnd, posX, posY, posZ, Dir.getMeta(Block.field_72054_aE, dir, this.field_74885_f));
    }

    protected void placeTorch(World world, StructureBoundingBox structBB, int posX, int posY, int posZ, ForgeDirection dir) {
        this.placeBlock(world, Block.field_71981_t, 0, posX, posY - 1, posZ, structBB);
        this.placeBlock(world, Block.field_72069_aq, dir, posX, posY, posZ, structBB);
        this.placeAir(world, posX, posY - 1, posZ, structBB);
    }

    protected void setMetadata(World world, int metadata, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        int globalZ;
        int globalY;
        int globalX = this.func_74865_a(posX, posZ);
        if (structBB.func_78890_b(globalX, globalY = this.func_74862_a(posY), globalZ = this.func_74873_b(posX, posZ))) {
            world.func_72921_c(globalX, globalY, globalZ, metadata, 2);
        }
    }

    protected int spawnEntity(World world, StructureBoundingBox structBB, int posX, int posY, int posZ, int amount) {
        int spawned = 0;
        for (int idx = 0; idx < amount; ++idx) {
            EntityLivingBase entity;
            int globalZ;
            int globalY;
            int globalX = this.func_74865_a(posX, posZ);
            if (!structBB.func_78890_b(globalX, globalY = this.func_74862_a(posY), globalZ = this.func_74873_b(posX, posZ)) || null == (entity = this.getEntity(world, idx))) continue;
            ++spawned;
            entity.func_70012_b((double)globalX + 0.5, (double)globalY, (double)globalZ + 0.5, 0.5f, 0.0f);
            world.func_72838_d((Entity)entity);
        }
        return spawned;
    }

    protected EntityVillager spawnVillager(World world, StructureBoundingBox structBB, int posX, int posY, int posZ) {
        return this.spawnVillager(world, structBB, posX, posY, posZ, 0);
    }

    protected EntityVillager spawnVillager(World world, StructureBoundingBox structBB, int posX, int posY, int posZ, int index) {
        int globalX = this.func_74865_a(posX, posZ);
        int globalY = this.func_74862_a(posY);
        int globalZ = this.func_74873_b(posX, posZ);
        EntityVillager entityvillager = null;
        if (structBB.func_78890_b(globalX, globalY, globalZ)) {
            entityvillager = new EntityVillager(world, this.func_74888_b(index));
            entityvillager.func_70012_b((double)globalX + 0.5, (double)globalY, (double)globalZ + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)entityvillager);
        }
        return entityvillager;
    }

    protected EntityLivingBase getEntity(World world, int index) {
        return null;
    }

    private void initBOPStairMapping() {
        if (null == this.biomesOPlentyStairMapping) {
            this.biomesOPlentyStairMapping = new HashMap<Integer, Block>(14);
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.acaciaPlank.meta, (Block)Blocks.acaciaStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.cherryPlank.meta, (Block)Blocks.cherryStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.darkPlank.meta, (Block)Blocks.darkStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.firPlank.meta, (Block)Blocks.firStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.holyPlank.meta, (Block)Blocks.holyStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.magicPlank.meta, (Block)Blocks.magicStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.mangrovePlank.meta, (Block)Blocks.mangroveStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.palmPlank.meta, (Block)Blocks.palmStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.redwoodPlank.meta, (Block)Blocks.redwoodStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.willowPlank.meta, (Block)Blocks.willowStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.pinePlank.meta, (Block)Blocks.pineStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.hellBarkPlank.meta, (Block)Blocks.hellBarkStairs.orNull());
            this.biomesOPlentyStairMapping.put(BlockReferences.EnumBlocks.jacarandaPlank.meta, (Block)Blocks.jacarandaStairs.orNull());
        }
    }

    private void initBOPWoodslabMapping() {
        if (null == this.biomesOPlentyWoodslabMapping) {
            this.biomesOPlentyWoodslabMapping = new HashMap<Integer, Pair<Block, Integer>>(14);
            this.biomesOPlentyWoodslabMapping.put(0, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)0));
            this.biomesOPlentyWoodslabMapping.put(1, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)1));
            this.biomesOPlentyWoodslabMapping.put(2, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)2));
            this.biomesOPlentyWoodslabMapping.put(3, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)3));
            this.biomesOPlentyWoodslabMapping.put(4, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)4));
            this.biomesOPlentyWoodslabMapping.put(5, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)5));
            this.biomesOPlentyWoodslabMapping.put(6, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)6));
            this.biomesOPlentyWoodslabMapping.put(7, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab1.orNull(), (Object)7));
            this.biomesOPlentyWoodslabMapping.put(8, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab2.orNull(), (Object)0));
            this.biomesOPlentyWoodslabMapping.put(9, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab2.orNull(), (Object)1));
            this.biomesOPlentyWoodslabMapping.put(11, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab2.orNull(), (Object)2));
            this.biomesOPlentyWoodslabMapping.put(12, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab2.orNull(), (Object)3));
            this.biomesOPlentyWoodslabMapping.put(13, (Pair<Block, Integer>)ImmutablePair.of((Object)Blocks.woodenSingleSlab2.orNull(), (Object)4));
        }
    }

    public BiomeSpecificBlock getSpecificBlock(Block block, ForgeDirection dir, BiomeGenBase biome) {
        return BiomeSpecificBlock.query(block, Dir.getMeta(block, dir, this.field_74885_f), biome);
    }

    public BiomeSpecificBlock getStairs(Block wood, ForgeDirection dir, BiomeGenBase biome) {
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Block.field_71988_x, 0, biome);
        if (Taverns.config.biomesOPlenty && Taverns.config.useBOPBlocks) {
            Block bopStairBlock;
            this.initBOPStairMapping();
            if (planks.block == Blocks.planks.orNull() && null != (bopStairBlock = this.biomesOPlentyStairMapping.get(planks.metadata))) {
                return BiomeSpecificBlock.queryVanilla(bopStairBlock, Dir.getMeta(Block.field_72063_at, dir, this.field_74885_f), null);
            }
        }
        BiomeSpecificBlock stairs = BiomeSpecificBlock.query(wood, Dir.getMeta(Block.field_72063_at, dir, this.field_74885_f), biome);
        if (!this.stairBlocks.contains(stairs.block)) {
            Block replacementStairBlock = null;
            if (planks.block == Block.field_71988_x) {
                switch (planks.metadata) {
                    case 0: {
                        replacementStairBlock = Block.field_72063_at;
                        break;
                    }
                    case 1: {
                        replacementStairBlock = Block.field_72074_bW;
                        break;
                    }
                    case 2: {
                        replacementStairBlock = Block.field_72072_bX;
                        break;
                    }
                    case 3: {
                        replacementStairBlock = Block.field_72070_bY;
                    }
                }
            }
            if (planks.block == Block.field_72081_al) {
                replacementStairBlock = Block.field_71992_bw;
            }
            if (planks.block == Block.field_71978_w || planks.block == Block.field_72087_ao) {
                replacementStairBlock = Block.field_72057_aH;
            }
            if (planks.block == Block.field_72033_bA || planks.block == Block.field_72012_bb) {
                replacementStairBlock = Block.field_72100_bC;
            }
            if (planks.block == Block.field_94339_ct) {
                replacementStairBlock = Block.field_94338_cu;
            }
            if (planks.block == Block.field_71957_Q) {
                replacementStairBlock = Block.field_72088_bQ;
            }
            if (planks.block == Block.field_72007_bm || planks.block == Block.field_71981_t) {
                replacementStairBlock = Block.field_71995_bx;
            }
            if (null != replacementStairBlock) {
                return BiomeSpecificBlock.queryVanilla(replacementStairBlock, Dir.getMeta(Block.field_72063_at, dir, this.field_74885_f), null);
            }
        }
        return stairs;
    }

    public BiomeSpecificBlock getBench(Block wood, ForgeDirection dir, BiomeGenBase biome) {
        return this.getStairs(wood, dir, biome);
    }

    public BiomeSpecificBlock getWoodSlab(int plankMeta, ForgeDirection dir, BiomeGenBase biome) {
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Block.field_71988_x, plankMeta, biome);
        if (Taverns.config.biomesOPlenty && Taverns.config.useBOPBlocks) {
            Pair<Block, Integer> bopPlankBlock;
            this.initBOPWoodslabMapping();
            if (planks.block == Blocks.planks.orNull() && null != (bopPlankBlock = this.biomesOPlentyWoodslabMapping.get(planks.metadata)) && null != bopPlankBlock.getLeft()) {
                return BiomeSpecificBlock.queryVanilla((Block)bopPlankBlock.getLeft(), (Integer)bopPlankBlock.getRight() + (dir == ForgeDirection.UP ? 8 : 0), null);
            }
        }
        BiomeSpecificBlock slab = BiomeSpecificBlock.query((Block)Block.field_72092_bO, plankMeta + (dir == ForgeDirection.UP ? 8 : 0), biome);
        if (slab.block == Block.field_72092_bO) {
            if (planks.block == Block.field_71988_x) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72092_bO, planks.metadata + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Block.field_71981_t) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72079_ak, 0 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Block.field_71957_Q) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72079_ak, 1 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Block.field_71978_w || planks.block == Block.field_72087_ao) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72079_ak, 3 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Block.field_72081_al) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72079_ak, 4 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Block.field_72007_bm) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72079_ak, 5 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Block.field_72033_bA || planks.block == Block.field_72012_bb) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72079_ak, 6 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Block.field_94339_ct) {
                return BiomeSpecificBlock.queryVanilla((Block)Block.field_72079_ak, 7 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
        }
        return slab;
    }

    public BiomeSpecificBlock getMossyCobble(BiomeGenBase biome) {
        if (Taverns.config.biomesOPlenty && Taverns.config.useBOPBlocks) {
            BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Block.field_71978_w, 0, biome);
            if (cobble.block == Blocks.logs1.orNull() || cobble.block == Blocks.logs2.orNull() || cobble.block == Blocks.logs3.orNull() || cobble.block == Blocks.logs4.orNull()) {
                return BiomeSpecificBlock.queryVanilla((Block)BlockReferences.EnumBlocks.deadLog.block.orNull(), BlockReferences.EnumBlocks.deadLog.meta, null);
            }
        }
        return BiomeSpecificBlock.query(Block.field_72087_ao, 0, biome);
    }
}

