/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.version;

import com.github.lunatrius.core.LunatriusCore;
import com.github.lunatrius.core.lib.Reference;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VersionChecker {
    private static final List<ModMetadata> REGISTERED_MODS = new ArrayList<ModMetadata>();
    private static final Map<String, String> OUTDATED_MODS = new HashMap<String, String>();
    private static boolean done = false;

    public static void registerMod(ModMetadata modMetadata) {
        REGISTERED_MODS.add(modMetadata);
        if (modMetadata.description != null) {
            modMetadata.description = modMetadata.description + String.format("\n---\nRecommended Forge: %s", Reference.FORGE);
        }
    }

    public static Set<Map.Entry<String, String>> getOutdatedMods() {
        return OUTDATED_MODS.entrySet();
    }

    public static void setDone(boolean isDone) {
        done = isDone;
    }

    public static boolean isDone() {
        return done;
    }

    public static void startVersionCheck() {
        new Thread("LunatriusCore Version Check"){

            @Override
            public void run() {
                try {
                    URL url = new URL(String.format("http://mc.lunatri.us/json?latest=1&mc=%s", Reference.MINECRAFT));
                    InputStream con = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)con));
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    if (json.get("version").equals(1.0)) {
                        Map mods = (Map)json.get("mods");
                        for (ModMetadata modMetadata : REGISTERED_MODS) {
                            String modid = modMetadata.modId;
                            DefaultArtifactVersion versionLocal = new DefaultArtifactVersion(modMetadata.version);
                            try {
                                DefaultArtifactVersion versionRemote = new DefaultArtifactVersion((String)((Map)((Map)mods.get(modid)).get("latest")).get("version"));
                                int diff = versionRemote.compareTo((ArtifactVersion)versionLocal);
                                if (diff > 0) {
                                    OUTDATED_MODS.put(modMetadata.name, String.format("%s -> %s", versionLocal, versionRemote));
                                    modMetadata.description = modMetadata.description + String.format("\nUpdate is available (%s -> %s)!", versionLocal, versionRemote);
                                    LunatriusCore.logger.info(String.format("Update is available for %s (%s -> %s)!", modid, versionLocal, versionRemote));
                                    continue;
                                }
                                if (diff == 0) {
                                    modMetadata.description = modMetadata.description + "\nUp to date!";
                                    LunatriusCore.logger.info(String.format("%s is up to date!", modid));
                                    continue;
                                }
                                LunatriusCore.logger.info(String.format("Is %s from the future?", modid));
                            }
                            catch (Exception ignored) {}
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                done = true;
            }
        }.start();
    }
}

