/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.common.gen;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.terraingen.BiomeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeSpecificBlock {
    public final int blockID;
    public final int metadata;
    public final Block block;
    public static final BiomeSpecificBlock air = new BiomeSpecificBlock(0, 0);
    private static final Map<Pair<Block, Integer>, Pair<Block, Integer>> desertReplaceMap = new HashMap<Pair<Block, Integer>, Pair<Block, Integer>>();

    private static BiomeSpecificBlock getDesertReplacement(Block original, Integer originalMeta) {
        Pair<Block, Integer> replacement = desertReplaceMap.get(ImmutablePair.of((Object)original, (Object)originalMeta));
        if (null == replacement) {
            replacement = desertReplaceMap.get(ImmutablePair.of((Object)original, (Object)-1));
        }
        if (null != replacement) {
            return new BiomeSpecificBlock((Block)replacement.getLeft(), (int)((Integer)replacement.getRight() >= 0 ? (Integer)replacement.getRight() : originalMeta));
        }
        return new BiomeSpecificBlock(original, (int)originalMeta);
    }

    public static BiomeSpecificBlock queryVanilla(Block block, int meta, BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
            return BiomeSpecificBlock.getDesertReplacement(block, meta);
        }
        return new BiomeSpecificBlock(block, meta);
    }

    public static BiomeSpecificBlock query(Block block, int meta, BiomeGenBase biome) {
        int newID = -1;
        int newMeta = -1;
        BiomeEvent.GetVillageBlockID eventBlock = new BiomeEvent.GetVillageBlockID(biome, block.field_71990_ca, meta);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)eventBlock);
        if (eventBlock.getResult() == Event.Result.DENY) {
            newID = eventBlock.replacement;
        }
        BiomeEvent.GetVillageBlockMeta eventMeta = new BiomeEvent.GetVillageBlockMeta(biome, block.field_71990_ca, meta);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)eventMeta);
        if (eventMeta.getResult() == Event.Result.DENY) {
            newMeta = eventMeta.replacement;
        }
        if (newID >= 0 && newMeta >= 0) {
            return new BiomeSpecificBlock(newID, newMeta);
        }
        if (newID < 0 && newMeta < 0) {
            if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
                return BiomeSpecificBlock.getDesertReplacement(block, meta);
            }
            return new BiomeSpecificBlock(block, meta);
        }
        if (newID >= 0) {
            if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
                BiomeSpecificBlock desertReplacement = BiomeSpecificBlock.getDesertReplacement(block, meta);
                return new BiomeSpecificBlock(newID, desertReplacement.metadata);
            }
            return new BiomeSpecificBlock(newID, meta);
        }
        if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
            BiomeSpecificBlock desertReplacement = BiomeSpecificBlock.getDesertReplacement(block, meta);
            return new BiomeSpecificBlock(desertReplacement.block, newMeta);
        }
        return new BiomeSpecificBlock(block, newMeta);
    }

    protected BiomeSpecificBlock(Block blockInstance, int meta) {
        this.blockID = blockInstance.field_71990_ca;
        this.metadata = meta;
        this.block = blockInstance;
    }

    protected BiomeSpecificBlock(int id, int meta) {
        this.blockID = id;
        this.metadata = meta;
        this.block = Block.field_71973_m[id];
    }

    private static void addDesertReplacement(Block from, Integer fromMeta, Block to, Integer toMeta) {
        desertReplaceMap.put((Pair<Block, Integer>)ImmutablePair.of((Object)from, (Object)fromMeta), (Pair<Block, Integer>)ImmutablePair.of((Object)to, (Object)toMeta));
    }

    static {
        BiomeSpecificBlock.addDesertReplacement(Block.field_71951_J, -1, Block.field_71957_Q, 0);
        BiomeSpecificBlock.addDesertReplacement(Block.field_71988_x, -1, Block.field_71957_Q, 0);
        BiomeSpecificBlock.addDesertReplacement(Block.field_71978_w, -1, Block.field_71957_Q, 0);
        BiomeSpecificBlock.addDesertReplacement(Block.field_72087_ao, -1, Block.field_71957_Q, 1);
        BiomeSpecificBlock.addDesertReplacement(Block.field_71940_F, -1, Block.field_71957_Q, 0);
        BiomeSpecificBlock.addDesertReplacement(Block.field_72063_at, -1, Block.field_72088_bQ, -1);
        BiomeSpecificBlock.addDesertReplacement(Block.field_72070_bY, -1, Block.field_72088_bQ, -1);
        BiomeSpecificBlock.addDesertReplacement(Block.field_72057_aH, -1, Block.field_72088_bQ, -1);
        BiomeSpecificBlock.addDesertReplacement(Block.field_72072_bX, -1, Block.field_94338_cu, -1);
        BiomeSpecificBlock.addDesertReplacement(Block.field_72074_bW, -1, Block.field_71995_bx, -1);
        BiomeSpecificBlock.addDesertReplacement(Block.field_72074_bW, -1, Block.field_71995_bx, -1);
        BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72079_ak, 0, (Block)Block.field_72079_ak, 1);
        BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72079_ak, 3, (Block)Block.field_72079_ak, 1);
        BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72079_ak, 8, (Block)Block.field_72079_ak, 9);
        BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72079_ak, 11, (Block)Block.field_72079_ak, 9);
        BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72085_aj, 0, (Block)Block.field_72085_aj, 1);
        BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72085_aj, 3, (Block)Block.field_72085_aj, 1);
        for (int meta = 0; meta <= 5; ++meta) {
            BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72092_bO, meta, (Block)Block.field_72079_ak, 1);
            BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72092_bO, meta + 8, (Block)Block.field_72079_ak, 9);
            BiomeSpecificBlock.addDesertReplacement((Block)Block.field_72090_bN, meta, (Block)Block.field_72085_aj, 1);
        }
        BiomeSpecificBlock.addDesertReplacement(Block.field_71979_v, -1, Block.field_71939_E, 9);
    }
}

