/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import de.vernideas.mc.common.ai.GuardAI;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.common.util.TimePeriod;
import de.vernideas.mc.taverns.Settings;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.direction.Dir;
import de.vernideas.mc.taverns.gen.ComponentVillageBase;
import gaia.GaiaItem;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.ComponentVillageStartPiece;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ForgeDirection;

public class ComponentVillageBakery
extends ComponentVillageBase {
    public static final String BAKERY_CHEST = "taverns:bakeryChest";
    public static final WeightedRandomChestContent[] bakeryChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Item.field_77685_T.field_77779_bT, 0, 1, 10, 12), new WeightedRandomChestContent(Item.field_77758_aJ.field_77779_bT, 0, 1, 8, 15), new WeightedRandomChestContent(Item.field_77747_aY.field_77779_bT, 0, 1, 10, 12), new WeightedRandomChestContent(Item.field_77764_aP.field_77779_bT, 0, 1, 12, 8), new WeightedRandomChestContent(Item.field_77771_aG.field_77779_bT, 0, 1, 2, 3), new WeightedRandomChestContent(Item.field_77788_aw.field_77779_bT, 0, 1, 3, 6), new WeightedRandomChestContent(Item.field_77739_bg.field_77779_bT, 0, 1, 15, 5), new WeightedRandomChestContent(new ItemStack(Block.field_72061_ba), 1, 2, 3), new WeightedRandomChestContent(Item.field_77740_bh.field_77779_bT, 0, 1, 3, 2), new WeightedRandomChestContent(new ItemStack(Block.field_71997_br), 1, 2, 1), new WeightedRandomChestContent(Item.field_77684_U.field_77779_bT, 0, 1, 3, 1), new WeightedRandomChestContent(Item.field_77706_j.field_77779_bT, 0, 1, 3, 3), new WeightedRandomChestContent(Item.field_82797_bK.field_77779_bT, 0, 1, 3, 3)};
    public static boolean initialized = false;
    public static boolean postInitialized = false;
    private static final int HEIGHT = 14;
    private int averageGroundLevel = -1;
    private boolean hasMadeChest;
    private int carpetColor;
    private boolean villagerSpawned = false;

    public static void init(Settings config) {
        if (!initialized) {
            initialized = true;
            ChestGenHooks.getInfo((String)BAKERY_CHEST).setMin(1);
            ChestGenHooks.getInfo((String)BAKERY_CHEST).setMax(8);
            for (int i = 0; i < bakeryChestContents.length; ++i) {
                ChestGenHooks.addItem((String)BAKERY_CHEST, (WeightedRandomChestContent)bakeryChestContents[i]);
            }
        }
    }

    public static void postInit(Settings config) {
        if (!postInitialized) {
            postInitialized = true;
            if (config.grimoireOfGaia2) {
                ChestGenHooks.addItem((String)BAKERY_CHEST, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(GaiaItem.ShardEmerald), 1, 2, 2));
            }
        }
    }

    public static Object buildComponent(ComponentVillageStartPiece startPiece, List pieces, Random random, int x, int y, int z, int direction, int type) {
        StructureBoundingBox structBB = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)12, (int)14, (int)9, (int)direction);
        if (ComponentVillageBakery.func_74895_a((StructureBoundingBox)structBB) && null == StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structBB)) {
            return new ComponentVillageBakery(startPiece, type, random, structBB, direction);
        }
        return null;
    }

    public ComponentVillageBakery(ComponentVillageStartPiece startPiece, int pieces, Random rnd, StructureBoundingBox structBB, int direction) {
        super(startPiece, pieces);
        this.field_74885_f = direction;
        this.field_74887_e = structBB;
        this.carpetColor = rnd.nextInt(16);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bb) {
        EntityVillager villager;
        int chestZ;
        int chestY;
        int chestX;
        int zz;
        int xx;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, bb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 14 - 2, 0);
        }
        BiomeGenBase biome = this.field_74897_k == null ? null : this.field_74897_k.biome;
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Block.field_71988_x, 0, biome);
        BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Block.field_71978_w, 0, biome);
        BiomeSpecificBlock dirt = BiomeSpecificBlock.query(Block.field_71979_v, 0, biome);
        BiomeSpecificBlock grass = BiomeSpecificBlock.queryVanilla((Block)Block.field_71980_u, 0, null);
        BiomeSpecificBlock gravel = BiomeSpecificBlock.query(Block.field_71940_F, 0, biome);
        BiomeSpecificBlock woodUp = BiomeSpecificBlock.query(Block.field_71951_J, 0, biome);
        BiomeSpecificBlock woodWest = this.getSpecificBlock(Block.field_71951_J, ForgeDirection.WEST, biome);
        BiomeSpecificBlock woodNorth = this.getSpecificBlock(Block.field_71951_J, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock fence = BiomeSpecificBlock.query(Block.field_72031_aZ, 0, biome);
        BiomeSpecificBlock woodSlabDown = this.getWoodSlab(0, ForgeDirection.DOWN, biome);
        BiomeSpecificBlock woodSlabUp = this.getWoodSlab(0, ForgeDirection.UP, biome);
        BiomeSpecificBlock glassPane = BiomeSpecificBlock.query(Block.field_72003_bq, 0, biome);
        BiomeSpecificBlock stoneSlabDouble = BiomeSpecificBlock.query((Block)Block.field_72085_aj, 0, biome);
        BiomeSpecificBlock roofNorth = this.getSpecificBlock(Block.field_72063_at, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock roofSouth = this.getSpecificBlock(Block.field_72063_at, ForgeDirection.SOUTH, biome);
        BiomeSpecificBlock cobbleChimney = BiomeSpecificBlock.queryVanilla(Block.field_71978_w, 0, null);
        BiomeSpecificBlock cobbleSlopeEast = BiomeSpecificBlock.queryVanilla(Block.field_72057_aH, Dir.getMeta(Block.field_72057_aH, ForgeDirection.EAST, this.field_74885_f), null);
        BiomeSpecificBlock cobbleSlopeNorth = BiomeSpecificBlock.queryVanilla(Block.field_72057_aH, Dir.getMeta(Block.field_72057_aH, ForgeDirection.NORTH, this.field_74885_f), null);
        BiomeSpecificBlock cobbleSlopeSouth = BiomeSpecificBlock.queryVanilla(Block.field_72057_aH, Dir.getMeta(Block.field_72057_aH, ForgeDirection.SOUTH, this.field_74885_f), null);
        BiomeSpecificBlock carpet = BiomeSpecificBlock.query(Block.field_111031_cC, this.carpetColor, biome);
        BiomeSpecificBlock smoke = BiomeSpecificBlock.queryVanilla(Block.field_71955_W, 0, null);
        this.fill(world, bb, 0, 0, 0, 11, 5, 6, BiomeSpecificBlock.air, BiomeSpecificBlock.air, false);
        for (xx = 0; xx < 12; ++xx) {
            for (zz = 0; zz < 7; ++zz) {
                this.func_74871_b(world, xx, 0, zz, bb);
                this.fillDownwards(world, Block.field_71978_w, 0, xx, -1, zz, bb);
            }
        }
        this.fill(world, bb, 0, 0, 0, 11, 0, 6, dirt, dirt);
        this.fill(world, bb, 1, 0, 0, 10, 0, 6, cobble, cobble);
        this.fill(world, bb, 2, 0, 1, 4, 0, 5, planks, planks);
        this.fill(world, bb, 5, 0, 1, 9, 0, 5, stoneSlabDouble, stoneSlabDouble);
        this.placeTorch(world, bb, 0, 3, 1, ForgeDirection.WEST);
        this.placeTorch(world, bb, 0, 3, 5, ForgeDirection.WEST);
        this.placeTorch(world, bb, 2, 3, 1, ForgeDirection.EAST);
        this.placeTorch(world, bb, 2, 3, 5, ForgeDirection.EAST);
        this.placeTorch(world, bb, 5, 3, 5, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 9, 3, 2, ForgeDirection.WEST);
        this.placeTorch(world, bb, 9, 3, 4, ForgeDirection.WEST);
        this.placeTorch(world, bb, 11, 3, 0, ForgeDirection.EAST);
        this.placeTorch(world, bb, 11, 3, 6, ForgeDirection.EAST);
        this.placeTorch(world, bb, 1, 3, -1, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 4, 3, -1, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 9, 3, -1, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 1, 3, 7, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 6, 3, 7, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 10, 3, 7, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 9, 8, 3, ForgeDirection.WEST);
        this.fill(world, bb, 1, 1, 0, 1, 5, 6, cobble, cobble);
        this.fill(world, bb, 1, 2, 1, 1, 4, 5, planks, planks);
        this.fill(world, bb, 1, 6, 2, 1, 6, 4, cobble, cobble);
        this.fill(world, bb, 10, 1, 0, 10, 5, 6, cobble, cobble);
        this.fill(world, bb, 10, 6, 2, 10, 6, 4, cobble, cobble);
        this.fill(world, bb, 4, 1, 0, 9, 1, 0, cobble, cobble);
        this.placeBlock(world, cobble, 2, 1, 0, bb);
        this.fill(world, bb, 2, 2, 0, 9, 4, 0, planks, planks);
        this.placeAir(world, 3, 2, 0, bb);
        this.fill(world, bb, 2, 1, 6, 9, 1, 6, cobble, cobble);
        this.fill(world, bb, 2, 2, 6, 9, 4, 6, planks, planks);
        this.fill(world, bb, 1, 2, 2, 1, 2, 4, glassPane, glassPane);
        this.fill(world, bb, 5, 2, 0, 8, 2, 0, glassPane, glassPane);
        this.placeBlock(world, glassPane, 3, 2, 6, bb);
        this.placeBlock(world, glassPane, 4, 2, 6, bb);
        this.placeBlock(world, glassPane, 8, 2, 6, bb);
        for (xx = 1; xx <= 10; ++xx) {
            this.placeBlock(world, roofNorth, xx, 4, -1, bb);
            this.placeBlock(world, roofNorth, xx, 5, 0, bb);
            this.placeBlock(world, roofNorth, xx, 6, 1, bb);
            this.placeBlock(world, roofNorth, xx, 7, 2, bb);
            this.placeBlock(world, woodWest, xx, 7, 3, bb);
            this.placeBlock(world, roofSouth, xx, 7, 4, bb);
            this.placeBlock(world, roofSouth, xx, 6, 5, bb);
            this.placeBlock(world, roofSouth, xx, 5, 6, bb);
            this.placeBlock(world, roofSouth, xx, 4, 7, bb);
        }
        this.fill(world, bb, 2, 6, 2, 2, 6, 4, woodNorth, woodNorth);
        this.fill(world, bb, 9, 6, 2, 9, 6, 4, woodNorth, woodNorth);
        for (int yy = 2; yy <= 3; ++yy) {
            for (zz = 1; zz <= 5; zz += 2) {
                this.placeBlock(world, Block.field_72051_aB, 0, 9, yy, zz, bb);
                this.setMetadata(world, Dir.getMeta(Block.field_72051_aB, ForgeDirection.WEST, this.field_74885_f), 9, yy, zz, bb);
            }
        }
        for (int zz2 = 1; zz2 <= 5; ++zz2) {
            this.placeBlock(world, stoneSlabDouble, 9, 4, zz2, bb);
            this.placeBlock(world, cobbleSlopeEast, 9, 5, zz2, bb);
        }
        this.fill(world, bb, 10, 1, 1, 10, 5, 5, cobbleChimney, cobbleChimney);
        this.fill(world, bb, 10, 6, 2, 10, 7, 4, cobbleChimney, cobbleChimney);
        this.placeBlock(world, cobbleSlopeNorth, 10, 8, 2, bb);
        this.placeBlock(world, cobbleChimney, 10, 8, 3, bb);
        this.placeBlock(world, cobbleSlopeSouth, 10, 8, 4, bb);
        this.placeBlock(world, cobbleChimney, 10, 9, 3, bb);
        this.fill(world, bb, 3, 1, 1, 3, 1, 3, carpet, carpet);
        this.placeBlock(world, smoke, 10, 10, 3, bb);
        this.fillRandomly(world, bb, random, 0.1f, 9, 11, 2, 11, 13, 4, smoke, smoke);
        this.placeBlock(world, stoneSlabDouble, 5, 1, 3, bb);
        this.placeBlock(world, stoneSlabDouble, 5, 1, 5, bb);
        this.placeBlock(world, stoneSlabDouble, 9, 1, 1, bb);
        this.placeBlock(world, stoneSlabDouble, 9, 1, 3, bb);
        this.placeBlock(world, stoneSlabDouble, 9, 1, 5, bb);
        this.placeBlock(world, Block.field_72005_bk, Dir.getMeta(Block.field_72005_bk, ForgeDirection.NORTH, this.field_74885_f) + 8, 5, 1, 4, bb);
        this.placeBlock(world, (Block)Block.field_72079_ak, 8, 5, 1, 1, bb);
        this.placeBlock(world, (Block)Block.field_72079_ak, 8, 5, 1, 2, bb);
        this.placeBlock(world, Block.field_72060_ay, 0, 7, 1, 2, bb);
        this.placeBlock(world, Block.field_72060_ay, 0, 7, 1, 3, bb);
        this.placeDoor(world, bb, random, 3, 1, 0, ForgeDirection.SOUTH);
        if (!this.hasMadeChest && bb.func_78890_b(chestX = this.func_74865_a(2, 5), chestY = this.func_74862_a(1), chestZ = this.func_74873_b(2, 5))) {
            this.hasMadeChest = true;
            this.func_74879_a(world, bb, random, 2, 1, 5, ChestGenHooks.getItems((String)BAKERY_CHEST, (Random)random), ChestGenHooks.getCount((String)BAKERY_CHEST, (Random)random) + 1);
        }
        if (!this.villagerSpawned && null != (villager = this.spawnVillager(world, bb, 6, 1, 3))) {
            this.villagerSpawned = true;
            int globalX = this.func_74865_a(6, 3);
            int globalY = this.func_74862_a(1);
            int globalZ = this.func_74873_b(6, 3);
            villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new GuardAI((EntityLiving)villager, new ChunkCoordinates(globalX, globalY, globalZ), 4.0f, 48.0f, new TimePeriod(0.01, 0.47), false));
        }
        return true;
    }

    protected int func_74888_b(int alreadySpawned) {
        return Taverns.config.bakerID > 0 ? Taverns.config.bakerID : super.func_74888_b(alreadySpawned);
    }
}

