/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.mineshot.client.accessor;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.client.renderer.EntityRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRendererAccessor {
    private static final Logger L = LogManager.getLogger();
    private static int FIELD_SMOOTH_CAM_FILTER_X;
    private static int FIELD_SMOOTH_CAM_FILTER_Y;
    private static int FIELD_CAM_ZOOM;
    private static int FIELD_CAM_XOFS;
    private static int FIELD_CAM_YOFS;
    private static int FIELD_PREV_FRAME_TIME;
    private final EntityRenderer renderer;

    public EntityRendererAccessor(EntityRenderer renderer) {
        this.renderer = renderer;
    }

    public void setCameraZoom(double zoom) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.renderer, (Object)zoom, (int)FIELD_CAM_ZOOM);
        }
        catch (Exception ex) {
            L.error("setCameraZoom() failed", (Throwable)ex);
        }
    }

    public double getCameraZoom() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.renderer, (int)FIELD_CAM_ZOOM);
        }
        catch (Exception ex) {
            L.error("getCameraZoom() failed", (Throwable)ex);
            return 0.0;
        }
    }

    public void setCameraOffsetX(double offset) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.renderer, (Object)offset, (int)FIELD_CAM_XOFS);
        }
        catch (Exception ex) {
            L.error("setCameraOffsetX() failed", (Throwable)ex);
        }
    }

    public double getCameraOffsetX() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.renderer, (int)FIELD_CAM_XOFS);
        }
        catch (Exception ex) {
            L.error("getCameraOffsetX() failed", (Throwable)ex);
            return 0.0;
        }
    }

    public void setCameraOffsetY(double offset) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.renderer, (Object)offset, (int)FIELD_CAM_YOFS);
        }
        catch (Exception ex) {
            L.error("setCameraOffsetY() failed", (Throwable)ex);
        }
    }

    public double getCameraOffsetY() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.renderer, (int)FIELD_CAM_YOFS);
        }
        catch (Exception ex) {
            L.error("getCameraOffsetY() failed", (Throwable)ex);
            return 0.0;
        }
    }

    public void setPreviousFrameTime(long time) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.renderer, (Object)time, (int)FIELD_PREV_FRAME_TIME);
        }
        catch (Exception ex) {
            L.error("setPreviousFrameTime() failed", (Throwable)ex);
        }
    }

    public double getPreviousFrameTime() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.renderer, (int)FIELD_PREV_FRAME_TIME);
        }
        catch (Exception ex) {
            L.error("getPreviousFrameTime() failed", (Throwable)ex);
            return 0.0;
        }
    }

    public void setSmoothCamFilterX(float value) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.renderer, (Object)Float.valueOf(value), (int)FIELD_SMOOTH_CAM_FILTER_X);
        }
        catch (Exception ex) {
            L.error("setSmoothCamFilterX() failed", (Throwable)ex);
        }
    }

    public float getSmoothCamFilterX() {
        try {
            return ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.renderer, (int)FIELD_SMOOTH_CAM_FILTER_X)).floatValue();
        }
        catch (Exception ex) {
            L.error("getSmoothCamFilterX() failed", (Throwable)ex);
            return 0.0f;
        }
    }

    public void setSmoothCamFilterY(float value) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.renderer, (Object)Float.valueOf(value), (int)FIELD_SMOOTH_CAM_FILTER_Y);
        }
        catch (Exception ex) {
            L.error("setSmoothCamFilterY() failed", (Throwable)ex);
        }
    }

    public float getSmoothCamFilterY() {
        try {
            return ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.renderer, (int)FIELD_SMOOTH_CAM_FILTER_Y)).floatValue();
        }
        catch (Exception ex) {
            L.error("getSmoothCamFilterY() failed", (Throwable)ex);
            return 0.0f;
        }
    }

    static {
        Field[] fields = EntityRenderer.class.getDeclaredFields();
        int fieldOfs = -1;
        for (int i = 0; i < fields.length - 3; ++i) {
            if (fields[i].getType() != Double.TYPE || fields[i + 1].getType() != Double.TYPE || fields[i + 2].getType() != Double.TYPE || fields[i + 3].getType() != Long.TYPE) continue;
            fieldOfs = i;
            break;
        }
        if (fieldOfs != -1) {
            FIELD_SMOOTH_CAM_FILTER_X = fieldOfs - 15;
            FIELD_SMOOTH_CAM_FILTER_Y = fieldOfs - 14;
            FIELD_CAM_ZOOM = fieldOfs;
            FIELD_CAM_XOFS = fieldOfs + 1;
            FIELD_CAM_YOFS = fieldOfs + 2;
            FIELD_PREV_FRAME_TIME = fieldOfs + 3;
        } else {
            L.error("Couldn't find fields for class EntityRenderer!");
        }
    }
}

