/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.mineshot.client.util;

import info.ata4.minecraft.mineshot.client.accessor.EntityRendererAccessor;
import info.ata4.minecraft.mineshot.client.accessor.MinecraftAccessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.Timer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ScreenshotUtils {
    private static final int BPP = 3;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final MinecraftAccessor mca = new MinecraftAccessor(mc);
    private static final EntityRendererAccessor era = new EntityRendererAccessor(ScreenshotUtils.mc.field_71460_t);
    private static final Framebuffer fb = mc.func_147110_a();
    private static final Timer timer = mca.getTimer();
    private static ByteBuffer viewportBuffer;

    private ScreenshotUtils() {
    }

    public static void capture(File file) throws FileNotFoundException, IOException {
        ImageSize size = ScreenshotUtils.getViewportSize();
        ByteBuffer bb = ScreenshotUtils.createMemoryMappedTargaFile(file, size);
        ScreenshotUtils.capture(bb, size);
        bb = null;
        System.gc();
    }

    private static void capture(ByteBuffer bb, ImageSize size) {
        int requiredBytes;
        int remainingBytes = bb.remaining();
        if (remainingBytes < (requiredBytes = size.length)) {
            throw new IllegalArgumentException("Not enough remaining bytes in byte buffer (remaining: " + remainingBytes + ", required: " + requiredBytes);
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        if (OpenGlHelper.func_148822_b()) {
            GL11.glBindTexture((int)3553, (int)ScreenshotUtils.fb.field_147617_g);
            GL11.glGetTexImage((int)3553, (int)0, (int)32992, (int)5121, (ByteBuffer)bb);
        } else {
            GL11.glReadPixels((int)0, (int)0, (int)size.width, (int)size.height, (int)32992, (int)5121, (ByteBuffer)bb);
        }
    }

    public static void capture(ByteBuffer bb) {
        ScreenshotUtils.capture(bb, ScreenshotUtils.getViewportSize());
    }

    public static void captureTiled(int width, int height, File file) throws FileNotFoundException, IOException {
        ImageSize sizeViewport = ScreenshotUtils.getViewportSize();
        ImageSize sizeTile = new ImageSize(width, height);
        ByteBuffer bb = ScreenshotUtils.createMemoryMappedTargaFile(file, sizeTile);
        ScreenshotUtils.captureTiled(bb, sizeViewport, sizeTile);
        bb = null;
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void captureTiled(ByteBuffer bb, ImageSize sizeViewport, ImageSize sizeTile) {
        try {
            viewportBuffer = BufferUtils.createByteBuffer((int)sizeViewport.length);
            double tilesX = (double)sizeTile.width / (double)sizeViewport.width;
            double tilesY = (double)sizeTile.height / (double)sizeViewport.height;
            int numTilesX = (int)Math.ceil(tilesX);
            int numTilesY = (int)Math.ceil(tilesY);
            double camZoom = tilesX <= tilesY ? tilesY : tilesX;
            for (int y = 0; y < numTilesY; ++y) {
                for (int x = 0; x < numTilesX; ++x) {
                    int tileWidth = Math.min(sizeViewport.width, sizeTile.width - sizeViewport.width * x);
                    int tileHeight = Math.min(sizeViewport.height, sizeTile.height - sizeViewport.height * y);
                    double camOfsX = (double)(sizeTile.width - sizeViewport.width - sizeViewport.width * x * 2) / (double)sizeViewport.width;
                    double camOfsY = ((double)(sizeTile.height - sizeViewport.height) - (double)sizeViewport.height * (tilesY - (double)y - 1.0) * 2.0) / (double)sizeViewport.height;
                    era.setCameraZoom(camZoom);
                    era.setCameraOffsetX(camOfsX);
                    era.setCameraOffsetY(camOfsY);
                    ScreenshotUtils.mc.field_71460_t.func_78480_b(ScreenshotUtils.timer.field_74281_c);
                    ScreenshotUtils.capture(viewportBuffer, sizeViewport);
                    for (int i = 0; i < tileHeight; ++i) {
                        viewportBuffer.clear();
                        viewportBuffer.position(i * sizeViewport.width * 3);
                        viewportBuffer.limit((i * sizeViewport.width + tileWidth) * 3);
                        bb.position((sizeTile.width * i + sizeTile.width * sizeViewport.height * y + sizeViewport.width * x) * 3);
                        bb.put(viewportBuffer);
                    }
                    viewportBuffer.clear();
                }
            }
        }
        finally {
            era.setCameraZoom(1.0);
            era.setCameraOffsetX(0.0);
            era.setCameraOffsetY(0.0);
            viewportBuffer = null;
        }
    }

    public static void captureTiled(int width, int height, ByteBuffer bb) {
        ScreenshotUtils.captureTiled(bb, ScreenshotUtils.getViewportSize(), new ImageSize(width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer createMemoryMappedTargaFile(File file, ImageSize info) throws FileNotFoundException, IOException {
        MappedByteBuffer bb;
        byte[] tgaHeader = new byte[18];
        tgaHeader[2] = 2;
        tgaHeader[12] = (byte)(info.width % 256);
        tgaHeader[13] = (byte)(info.width / 256);
        tgaHeader[14] = (byte)(info.height % 256);
        tgaHeader[15] = (byte)(info.height / 256);
        tgaHeader[16] = 24;
        int fileSize = info.length + tgaHeader.length;
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            FileChannel fc = raf.getChannel();
            fc.truncate(fileSize);
            bb = fc.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
        }
        finally {
            raf.close();
        }
        bb.put(tgaHeader);
        return ((ByteBuffer)bb).slice();
    }

    private static ImageSize getViewportSize() {
        int height;
        int width;
        if (OpenGlHelper.func_148822_b()) {
            width = ScreenshotUtils.fb.field_147622_a;
            height = ScreenshotUtils.fb.field_147620_b;
        } else {
            width = ScreenshotUtils.mc.field_71443_c;
            height = ScreenshotUtils.mc.field_71440_d;
        }
        return new ImageSize(width, height);
    }

    private static class ImageSize {
        final int width;
        final int height;
        final int length;

        ImageSize(int width, int height) {
            this.width = width;
            this.height = height;
            this.length = width * height * 3;
        }
    }
}

