/*
 * Decompiled with CFR 0.152.
 */
package deconstruction.localization;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.minecraft.client.Minecraft;

public class LocalizationHandler {
    public static LocalizationHandler instance = new LocalizationHandler();
    File languageDir;
    String currentLanguage;
    List<String> languages;

    public LocalizationHandler() {
        this.languageDir = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + File.separatorChar + "mods" + File.separatorChar + "deconstruction" + File.separatorChar + "lang");
        this.currentLanguage = "en_US";
        this.languages = this.getFilesAsLocales();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LoadLanguages() {
        try {
            this.currentLanguage = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
            if (this.languages.contains(this.currentLanguage)) {
                this.languages.remove(this.currentLanguage);
                LanguageRegistry.instance().addStringLocalization(this.getPropertiesFromLanguage(this.currentLanguage), this.currentLanguage);
                System.out.println("Loaded Language " + this.currentLanguage);
            } else {
                LanguageRegistry.instance().addStringLocalization(this.getPropertiesFromLanguage("en_US"), this.currentLanguage);
                System.out.println("Loaded en_US in place of " + this.currentLanguage);
            }
        }
        catch (Exception e) {
            System.out.println("Caught an exception while adding localizations for" + this.currentLanguage + " :::: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.loadAll();
        }
    }

    public Properties getPropertiesFromLanguage(String code) {
        Properties props = new Properties();
        File langFile = new File(this.languageDir, code + ".xml");
        try {
            props.loadFromXML(new FileInputStream(langFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public void loadAll() {
        String s = "---NULL---";
        try {
            Iterator<String> i$ = this.languages.iterator();
            while (i$.hasNext()) {
                String lang;
                s = lang = i$.next();
                LanguageRegistry.instance().addStringLocalization(this.getPropertiesFromLanguage(lang), lang);
                System.out.println("Loaded Language " + lang);
            }
        }
        catch (Exception e) {
            System.out.println("Caught an exception while adding localizations for" + s + " :::: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private List<String> getFilesAsLocales() {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : this.languageDir.listFiles()) {
            list.add(file.getName().replace(".xml", ""));
        }
        return list;
    }
}

