/*
 * Decompiled with CFR 0.152.
 */
package deconstruction.localization;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class LocaleDownloader {
    public static LocaleDownloader instance = new LocaleDownloader();

    public HashMap<String, String> GetLocaleList() {
        Properties prop = new Properties();
        HashMap<String, String> localeList = new HashMap<String, String>();
        try {
            URL remoteLangList = new URL("https://dl.dropboxusercontent.com/u/118017409/lang/deconstruction/%5BLangList%5D.xml");
            InputStream listStream = remoteLangList.openStream();
            prop.loadFromXML(listStream);
            for (Object key : prop.keySet()) {
                localeList.put((String)key, prop.getProperty((String)key));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get remote list of available localizations");
            System.out.println(e.getMessage());
            e.printStackTrace();
            localeList = null;
        }
        return localeList;
    }

    public void DownloadLocales() {
        try {
            HashMap<String, String> availableLangs = this.GetLocaleList();
            ArrayList<String> downloadedLangs = new ArrayList<String>();
            File localeDir = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + File.separatorChar + "mods" + File.separatorChar + "deconstruction" + File.separatorChar + "lang");
            if (!localeDir.exists()) {
                localeDir.mkdirs();
            }
            for (File locale : localeDir.listFiles()) {
                downloadedLangs.add(locale.getName().replace(".xml", ""));
            }
            for (String key : availableLangs.keySet()) {
                String locale = availableLangs.get(key);
                if (downloadedLangs.contains(locale)) continue;
                if (this.DownloadLocale(locale, new File(localeDir.getAbsolutePath() + File.separatorChar + locale + ".xml"))) {
                    downloadedLangs.add(locale);
                    System.out.println("Successfully downloaded locale file " + locale + " from remote source.");
                    continue;
                }
                System.out.println("Failed to download locale file: " + locale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean DownloadLocale(String locale, File destFile) {
        try {
            URL remoteLangFile = new URL("https://dl.dropboxusercontent.com/u/118017409/lang/deconstruction/" + locale + ".xml");
            FileUtils.copyURLToFile((URL)remoteLangFile, (File)destFile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

