/*
 * Decompiled with CFR 0.152.
 */
package portablejim.planterhelper.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.IPlantable;
import portablejim.planterhelper.items.Planter;

public class SeedInventory
implements IInventory {
    private ItemStack[] inventoryItems;
    private ItemStack currentItem;
    private int size;

    public SeedInventory(ItemStack current) {
        this.currentItem = current;
        assert (this.currentItem != null);
        assert (this.currentItem.func_77973_b() instanceof Planter);
        int itemNumSlots = ((Planter)this.currentItem.func_77973_b()).getInvSlots();
        if (itemNumSlots > 0) {
            this.inventoryItems = new ItemStack[itemNumSlots];
            this.size = itemNumSlots;
        } else {
            this.inventoryItems = new ItemStack[0];
            this.size = 0;
        }
        if (!this.currentItem.func_77942_o()) {
            this.currentItem.func_77982_d(new NBTTagCompound());
        }
        this.loadFromNBT(this.currentItem.func_77978_p());
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.func_70302_i_()) {
            throw new IndexOutOfBoundsException();
        }
        return this.inventoryItems[i];
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack output;
        if (this.inventoryItems[index] == null) {
            return null;
        }
        if (this.inventoryItems[index].field_77994_a <= amount) {
            output = this.inventoryItems[index];
            this.inventoryItems[index] = null;
        } else {
            output = this.inventoryItems[index].func_77979_a(amount);
            if (this.inventoryItems[index].field_77994_a == 0) {
                this.inventoryItems[index] = null;
            }
        }
        this.func_70296_d();
        return output;
    }

    public ItemStack func_70304_b(int slotNum) {
        if (this.inventoryItems[slotNum] != null) {
            ItemStack stack = this.inventoryItems[slotNum];
            this.func_70299_a(slotNum, null);
            return stack;
        }
        return null;
    }

    public void func_70299_a(int num, ItemStack itemStack) {
        this.inventoryItems[num] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.getInvName();
    }

    public boolean func_145818_k_() {
        return this.isInvNameLocalized();
    }

    public String getInvName() {
        return "Planter";
    }

    public boolean isInvNameLocalized() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a != 0) continue;
            this.func_70299_a(i, null);
        }
        this.saveToNBT(this.currentItem.func_77978_p());
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof IPlantable;
    }

    public void loadFromNBT(NBTTagCompound tagCompound) {
        int NBT_TAGLIST = 10;
        NBTTagList tagList = tagCompound.func_150295_c("ItemsPlanterHelper", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            int slot = itemTag.func_74762_e("SlotPlanterHelper");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)itemTag));
        }
    }

    public void saveToNBT(NBTTagCompound newCompound) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.inventoryItems[i];
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("SlotPlanterHelper", i);
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        newCompound.func_74782_a("ItemsPlanterHelper", (NBTBase)list);
    }
}

