/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.directionhud;

import bspkrs.client.util.HUDUtils;
import bspkrs.util.BSConfiguration;
import bspkrs.util.CommonUtils;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DirectionHUD {
    public static final String VERSION_NUMBER = "v1.17(1.7.2)";
    protected static float zLevel = -100.0f;
    private static ScaledResolution scaledResolution;
    public static String alignMode;
    public static String markerColor;
    public static int compassIndex;
    public static int xOffset;
    public static int yOffset;
    public static int yOffsetBottomCenter;
    public static boolean applyXOffsetToCenter;
    public static boolean applyYOffsetToMiddle;
    public static boolean showInChat;
    private static BSConfiguration config;

    public static void loadConfig(File file) {
        String ctgyGen = "general";
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        config = new BSConfiguration(file);
        config.load();
        alignMode = config.getString("alignMode", ctgyGen, alignMode, "Valid alignment strings are topleft, topcenter, topright, middleleft, middlecenter, middleright, bottomleft, bottomcenter, bottomright");
        markerColor = config.getString("markerColor", ctgyGen, markerColor, "Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png)");
        compassIndex = config.getInt("compassIndex", ctgyGen, compassIndex, 0, 9, "Index of the selected compass in the compass image file starting at 0. Up to 10 compasses can fit in the image (10 would be index 9). Each compass is 24 pixels tall (two lines of height 12).");
        xOffset = config.getInt("xOffset", ctgyGen, xOffset, Integer.MIN_VALUE, Integer.MAX_VALUE, "Horizontal offset from the edge of the screen (when using right alignments the x offset is relative to the right edge of the screen)");
        yOffset = config.getInt("yOffset", ctgyGen, yOffset, Integer.MIN_VALUE, Integer.MAX_VALUE, "Vertical offset from the edge of the screen (when using bottom alignments the y offset is relative to the bottom edge of the screen)");
        yOffsetBottomCenter = config.getInt("yOffsetBottomCenter", ctgyGen, yOffsetBottomCenter, 0, Integer.MAX_VALUE, "Vertical offset used only for the bottomcenter alignment to avoid the vanilla HUD");
        applyXOffsetToCenter = config.getBoolean("applyXOffsetToCenter", ctgyGen, applyXOffsetToCenter, "Set to true if you want the xOffset value to be applied when using a center alignment");
        applyYOffsetToMiddle = config.getBoolean("applyYOffsetToMiddle", ctgyGen, applyYOffsetToMiddle, "Set to true if you want the yOffset value to be applied when using a middle alignment");
        showInChat = config.getBoolean("showInChat", ctgyGen, showInChat, "Set to true to show info when chat is open, false to disable info when chat is open");
        config.save();
    }

    public static boolean onTickInGame(Minecraft mc) {
        if ((mc.field_71415_G || mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat && showInChat) && !mc.field_71474_y.field_74330_P && !mc.field_71474_y.field_74321_H.func_151470_d()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scaledResolution = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
            DirectionHUD.displayHUD(mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private static int getX(int width) {
        if (alignMode.equalsIgnoreCase("topcenter") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78326_a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("topright") || alignMode.equalsIgnoreCase("middleright") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78326_a() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.equalsIgnoreCase("middleleft") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("middleright")) {
            return scaledResolution.func_78328_b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    private static void displayHUD(Minecraft mc) {
        int direction = MathHelper.func_76128_c((double)((double)(mc.field_71439_g.field_70177_z * 256.0f / 360.0f) + 0.5)) & 0xFF;
        int yBase = DirectionHUD.getY(1, 12);
        int xBase = DirectionHUD.getX(65);
        mc.func_110434_K().func_110577_a(new ResourceLocation("DirectionHUD:textures/gui/compass.png"));
        if (direction < 128) {
            HUDUtils.drawTexturedModalRect((int)xBase, (int)yBase, (int)direction, (int)(compassIndex * 24), (int)65, (int)12, (float)zLevel);
        } else {
            HUDUtils.drawTexturedModalRect((int)xBase, (int)yBase, (int)(direction - 128), (int)(compassIndex * 24 + 12), (int)65, (int)12, (float)zLevel);
        }
        mc.field_71466_p.func_78276_b("\u00a7" + markerColor.toLowerCase() + "|", xBase + 32, yBase + 1, 0xFFFFFF);
        mc.field_71466_p.func_78276_b("\u00a7" + markerColor.toLowerCase() + "|\u00a7r", xBase + 32, yBase + 5, 0xFFFFFF);
    }

    static {
        alignMode = "topcenter";
        markerColor = "c";
        compassIndex = 0;
        xOffset = 2;
        yOffset = 2;
        yOffsetBottomCenter = 41;
        applyXOffsetToCenter = false;
        applyYOffsetToMiddle = false;
        showInChat = true;
    }
}

