/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import wildCaves.BlockDecorations;
import wildCaves.BlockFlora;
import wildCaves.BlockFossils;
import wildCaves.BlockSandstoneStalactite;
import wildCaves.BlockStoneStalactite;
import wildCaves.EventManager;
import wildCaves.ItemDecoration;
import wildCaves.ItemFlora;
import wildCaves.ItemFossil;
import wildCaves.ItemSandstoneStalactite;
import wildCaves.ItemStoneStalactite;
import wildCaves.WorldGenWildCaves;

@Mod(modid="wildcaves3", name="Wild Caves 3", version="0.4.3.5")
public class WildCaves {
    public static final String modid = "wildcaves3";
    public static Block blockFlora;
    public static Block blockDecorations;
    public static Block blockFossils;
    public static BlockStoneStalactite blockStoneStalactite;
    public static BlockSandstoneStalactite blockSandStalactite;
    public static int floraLightLevel;
    public static int timesPerChunck;
    public static int chanceForNodeToSpawn;
    public static boolean solidStalactites;
    public static boolean damageWhenFallenOn;
    public static Configuration config;
    private EventManager eventmanager;
    public static CreativeTabs tabWildCaves;

    public void initBlocks() {
        blockStoneStalactite = new BlockStoneStalactite();
        GameRegistry.registerBlock((Block)blockStoneStalactite, ItemStoneStalactite.class, (String)"StoneStalactite");
        blockSandStalactite = new BlockSandstoneStalactite();
        GameRegistry.registerBlock((Block)blockSandStalactite, ItemSandstoneStalactite.class, (String)"SandstoneSalactite");
        blockDecorations = new BlockDecorations();
        GameRegistry.registerBlock((Block)blockDecorations, ItemDecoration.class, (String)"Decorations");
        blockFlora = new BlockFlora().func_149715_a(floraLightLevel / 15);
        GameRegistry.registerBlock((Block)blockFlora, ItemFlora.class, (String)"Flora");
        blockFossils = new BlockFossils();
        GameRegistry.registerBlock((Block)blockFossils, ItemFossil.class, (String)"FossilBlock");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        WorldGenWildCaves gen = new WorldGenWildCaves(config);
        if (WorldGenWildCaves.maxLength > 0) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)gen, (int)5);
        }
        for (String txt : new String[]{"DUNGEON_CHEST", "MINESHAFT_CORRIDOR", "STRONGHOLD_CORRIDOR"}) {
            for (int i = 0; i < 5; ++i) {
                if (i == 1) continue;
                ChestGenHooks.getInfo((String)txt).addItem(new WeightedRandomChestContent(new ItemStack(Items.field_151144_bL, 1, i), 1, 2, 50));
            }
        }
        this.eventmanager = new EventManager(chanceForNodeToSpawn);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.eventmanager, (int)10);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        solidStalactites = config.get("general", "Solid stalactites/stalgmites", false).getBoolean(false);
        damageWhenFallenOn = config.get("general", "Stalgmites damage entities when fallen on", false).getBoolean(false);
        floraLightLevel = config.get("general", "Flora light level", 5).getInt(5);
        if (floraLightLevel > 15) {
            floraLightLevel = 15;
        }
        chanceForNodeToSpawn = config.get("general", "Chance for a fossil node to generate", 5).getInt(5);
        config.save();
        this.initBlocks();
    }

    static {
        tabWildCaves = new CreativeTabs("WildCaves3"){

            public Item func_78016_d() {
                return Items.field_151061_bv;
            }
        };
    }
}

