/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wildCaves.WildCaves;

public abstract class BlockStalactite
extends Block {
    private final int numOfStructures;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockStalactite(int num) {
        super(Material.field_151576_e);
        this.numOfStructures = num;
        this.func_149711_c(0.8f);
        this.func_149647_a(WildCaves.tabWildCaves);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        boolean result = false;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata != 0 && metadata < 4 || metadata == 7 || metadata == 11) {
            result = this.connected(world, x, y, z, true);
        } else if (metadata == 6 || metadata > 7 && metadata < 11 || metadata == 12) {
            result = this.connected(world, x, y, z, false);
        } else if (metadata == 0 || metadata == 4 || metadata == 5) {
            result = this.connected(world, x, y, z, true) || this.connected(world, x, y, z, false);
        }
        return result;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public boolean connected(World world, int x, int y, int z, boolean searchUp) {
        int increment = searchUp ? 1 : -1;
        int i = increment;
        while (world.func_147439_a(x, y + i, z) == WildCaves.blockStoneStalactite || world.func_147439_a(x, y + i, z) == WildCaves.blockSandStalactite) {
            i += increment;
        }
        return world.func_147439_a(x, y + i, z).isNormalCube((IBlockAccess)world, x, y + i, z);
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        if (WildCaves.solidStalactites) {
            return super.func_149668_a(par1World, par2, par3, par4);
        }
        return null;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata >= this.numOfStructures) {
            metadata = this.numOfStructures - 1;
        }
        return this.iconArray[metadata];
    }

    public int func_149645_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < this.numOfStructures; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        this.func_149674_a(world, x, y, z, null);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        entity.field_70159_w *= 0.7;
        entity.field_70179_y *= 0.7;
    }

    public void func_149746_a(World world, int par2, int par3, int par4, Entity entity, float par6) {
        if (WildCaves.damageWhenFallenOn && entity.func_70089_S()) {
            entity.func_70097_a(DamageSource.field_76377_j, 5.0f);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockID) {
        if (!world.field_72995_K && !this.func_149718_j(world, x, y, z)) {
            world.func_147480_a(x, y, z, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconArray = new IIcon[this.numOfStructures];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a("wildcaves3" + this.func_149641_N() + i);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int metadata = par1IBlockAccess.func_72805_g(par2, par3, par4);
        switch (metadata) {
            case 1: {
                this.func_149676_a(0.25f, 0.2f, 0.25f, 0.75f, 1.0f, 0.75f);
                break;
            }
            case 2: {
                this.func_149676_a(0.25f, 0.5f, 0.25f, 0.75f, 1.0f, 0.75f);
                break;
            }
            case 9: {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.8f, 0.75f);
                break;
            }
            case 10: {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.4f, 0.75f);
                break;
            }
            default: {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
            }
        }
    }
}

