/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.ChestChangerType;
import cpw.mods.ironchest.CommonProxy;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemIronChest;
import cpw.mods.ironchest.PacketHandler;
import cpw.mods.ironchest.Version;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

@Mod(modid="IronChest", name="Iron Chests", dependencies="required-after:Forge@[7.0,);required-after:FML@[5.0.5,)")
public class IronChest {
    public static BlockIronChest ironChestBlock;
    @SidedProxy(clientSide="cpw.mods.ironchest.client.ClientProxy", serverSide="cpw.mods.ironchest.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="IronChest")
    public static IronChest instance;
    public static boolean CACHE_RENDER;
    public static boolean OCELOTS_SITONCHESTS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Version.init(event.getVersionProperties());
        event.getModMetadata().version = Version.fullVersionString();
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            ChestChangerType.buildItems(cfg);
            CACHE_RENDER = cfg.get("general", "cacheRenderingInformation", true).getBoolean(true);
            OCELOTS_SITONCHESTS = cfg.get("general", "ocelotsSitOnChests", true).getBoolean(true);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"IronChest has a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        ironChestBlock = new BlockIronChest();
        GameRegistry.registerBlock((Block)ironChestBlock, ItemIronChest.class, (String)"BlockIronChest");
        PacketHandler.INSTANCE.ordinal();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        for (IronChestType typ : IronChestType.values()) {
            GameRegistry.registerTileEntityWithAlternatives(typ.clazz, (String)("IronChest." + typ.name()), (String[])new String[]{typ.name()});
            proxy.registerTileEntitySpecialRenderer(typ);
        }
        IronChestType.registerBlocksAndRecipes(ironChestBlock);
        ChestChangerType.generateRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent evt) {
    }

    static {
        CACHE_RENDER = true;
        OCELOTS_SITONCHESTS = true;
    }
}

