/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.TileEntityCopperChest;
import cpw.mods.ironchest.TileEntityCrystalChest;
import cpw.mods.ironchest.TileEntityDiamondChest;
import cpw.mods.ironchest.TileEntityDirtChest;
import cpw.mods.ironchest.TileEntityGoldChest;
import cpw.mods.ironchest.TileEntityIronChest;
import cpw.mods.ironchest.TileEntityObsidianChest;
import cpw.mods.ironchest.TileEntitySilverChest;
import cpw.mods.ironchest.ValidatingSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum IronChestType {
    IRON(54, 9, true, "Iron Chest", "ironchest.png", 0, Arrays.asList("ingotIron", "ingotRefinedIron"), TileEntityIronChest.class, "mmmmPmmmm", "mGmG3GmGm"),
    GOLD(81, 9, true, "Gold Chest", "goldchest.png", 1, Arrays.asList("ingotGold"), TileEntityGoldChest.class, "mmmmPmmmm", "mGmG4GmGm"),
    DIAMOND(108, 12, true, "Diamond Chest", "diamondchest.png", 2, Arrays.asList("gemDiamond"), TileEntityDiamondChest.class, "GGGmPmGGG", "GGGG4Gmmm"),
    COPPER(45, 9, false, "Copper Chest", "copperchest.png", 3, Arrays.asList("ingotCopper"), TileEntityCopperChest.class, "mmmmCmmmm"),
    SILVER(72, 9, false, "Silver Chest", "silverchest.png", 4, Arrays.asList("ingotSilver"), TileEntitySilverChest.class, "mmmm3mmmm", "mGmG0GmGm"),
    CRYSTAL(108, 12, true, "Crystal Chest", "crystalchest.png", 5, Arrays.asList("blockGlass"), TileEntityCrystalChest.class, "GGGGPGGGG"),
    OBSIDIAN(108, 12, false, "Obsidian Chest", "obsidianchest.png", 6, Arrays.asList("obsidian"), TileEntityObsidianChest.class, "mmmm2mmmm"),
    DIRTCHEST9000(1, 1, false, "Dirt Chest 9000", "dirtchest.png", 7, Arrays.asList("dirt"), TileEntityDirtChest.class, Item.func_150898_a((Block)Blocks.field_150346_d), "mmmmCmmmm"),
    WOOD(0, 0, false, "", "", -1, Arrays.asList("plankWood"), null, new String[0]);

    int size;
    private int rowLength;
    public String friendlyName;
    private boolean tieredChest;
    private String modelTexture;
    private int textureRow;
    public Class<? extends TileEntityIronChest> clazz;
    private String[] recipes;
    private ArrayList<String> matList;
    private Item itemFilter;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static String[] sideNames;
    private static int[] sideMapping;

    private IronChestType(int size, int rowLength, boolean tieredChest, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityIronChest> clazz, String ... recipes) {
        this(size, rowLength, tieredChest, friendlyName, modelTexture, textureRow, mats, clazz, (Item)null, recipes);
    }

    private IronChestType(int size, int rowLength, boolean tieredChest, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityIronChest> clazz, Item itemFilter, String ... recipes) {
        this.size = size;
        this.rowLength = rowLength;
        this.tieredChest = tieredChest;
        this.friendlyName = friendlyName;
        this.modelTexture = modelTexture;
        this.textureRow = textureRow;
        this.clazz = clazz;
        this.itemFilter = itemFilter;
        this.recipes = recipes;
        this.matList = new ArrayList();
        this.matList.addAll(mats);
    }

    public String getModelTexture() {
        return this.modelTexture;
    }

    public int getTextureRow() {
        return this.textureRow;
    }

    public static TileEntityIronChest makeEntity(int metadata) {
        int chesttype = IronChestType.validateMeta(metadata);
        if (chesttype == metadata) {
            try {
                TileEntityIronChest te = IronChestType.values()[chesttype].clazz.newInstance();
                return te;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void registerTranslations() {
    }

    public static void registerBlocksAndRecipes(BlockIronChest blockResult) {
        ItemStack previous = new ItemStack((Block)Blocks.field_150486_ae);
        for (IronChestType typ : IronChestType.values()) {
            IronChestType.generateRecipesForType(blockResult, previous, typ);
            ItemStack chest = new ItemStack((Block)blockResult, 1, typ.ordinal());
            if (typ.isValidForCreativeMode()) {
                GameRegistry.registerCustomItemStack((String)typ.friendlyName, (ItemStack)chest);
            }
            if (!typ.tieredChest) continue;
            previous = chest;
        }
    }

    public static void generateRecipesForType(BlockIronChest blockResult, Object previousTier, IronChestType type) {
        for (String recipe : type.recipes) {
            String[] recipeSplit = new String[]{recipe.substring(0, 3), recipe.substring(3, 6), recipe.substring(6, 9)};
            Object mainMaterial = null;
            for (String mat : type.matList) {
                mainMaterial = IronChestType.translateOreName(mat);
                IronChestType.addRecipe(new ItemStack((Block)blockResult, 1, type.ordinal()), recipeSplit, Character.valueOf('m'), mainMaterial, Character.valueOf('P'), previousTier, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('0'), new ItemStack((Block)blockResult, 1, 0), Character.valueOf('1'), new ItemStack((Block)blockResult, 1, 1), Character.valueOf('2'), new ItemStack((Block)blockResult, 1, 2), Character.valueOf('3'), new ItemStack((Block)blockResult, 1, 3), Character.valueOf('4'), new ItemStack((Block)blockResult, 1, 4));
            }
        }
    }

    public static Object translateOreName(String mat) {
        if (mat == "ingotIron") {
            return Items.field_151042_j;
        }
        if (mat == "ingotGold") {
            return Items.field_151043_k;
        }
        if (mat == "gemDiamond") {
            return Items.field_151045_i;
        }
        if (mat == "blockGlass") {
            return Blocks.field_150359_w;
        }
        if (mat == "obsidian") {
            return Blocks.field_150343_Z;
        }
        if (mat == "dirt") {
            return Blocks.field_150346_d;
        }
        return mat;
    }

    public static void addRecipe(ItemStack is, Object ... parts) {
        ShapedOreRecipe oreRecipe = new ShapedOreRecipe(is, parts);
        GameRegistry.addRecipe((IRecipe)oreRecipe);
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    public List<String> getMatList() {
        return this.matList;
    }

    public static int validateMeta(int i) {
        if (i < IronChestType.values().length && IronChestType.values()[i].size > 0) {
            return i;
        }
        return 0;
    }

    public boolean isValidForCreativeMode() {
        return IronChestType.validateMeta(this.ordinal()) == this.ordinal();
    }

    public boolean isExplosionResistant() {
        return this == OBSIDIAN;
    }

    @SideOnly(value=Side.CLIENT)
    public void makeIcons(IIconRegister par1IconRegister) {
        if (this.isValidForCreativeMode()) {
            this.icons = new IIcon[3];
            int i = 0;
            for (String s : sideNames) {
                this.icons[i++] = par1IconRegister.func_94245_a(String.format("ironchest:%s_%s", this.name().toLowerCase(), s));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        return this.icons[sideMapping[side]];
    }

    public Slot makeSlot(IInventory chestInventory, int index, int x, int y) {
        return new ValidatingSlot(chestInventory, index, x, y, this);
    }

    public boolean acceptsStack(ItemStack itemstack) {
        return this.itemFilter == null || itemstack == null || itemstack.func_77973_b() == this.itemFilter;
    }

    public void adornItemDrop(ItemStack item) {
        if (this == DIRTCHEST9000) {
            item.func_77983_a("dirtchest", (NBTBase)new NBTTagByte(1));
        }
    }

    static {
        sideNames = new String[]{"top", "front", "side"};
        sideMapping = new int[]{0, 0, 2, 1, 2, 2, 2};
    }
}

