/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.constants.EnumPackets;

public class Server {
    public static void sendData(EntityPlayerMP player, EnumPackets enu, Object ... obs) {
        try {
            AnimalBikes.Channel.sendTo(new FMLProxyPacket(Server.getBytes(enu, obs), "AnimalBikes"), player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendAssociatedData(EntityPlayerMP player, EnumPackets enu, Object ... obs) {
        try {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 60.0);
            AnimalBikes.Channel.sendToAllAround(new FMLProxyPacket(Server.getBytes(enu, obs), "AnimalBikes"), point);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendToAll(EnumPackets enu, Object ... obs) {
        try {
            AnimalBikes.Channel.sendToAll(new FMLProxyPacket(Server.getBytes(enu, obs), "AnimalBikes"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ByteBuf getBytes(EnumPackets enu, Object ... obs) throws IOException {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        out.writeInt(enu.ordinal());
        for (Object ob : obs) {
            if (ob == null) continue;
            if (ob instanceof Enum) {
                out.writeInt(((Enum)ob).ordinal());
                continue;
            }
            if (ob instanceof Integer) {
                out.writeInt(((Integer)ob).intValue());
                continue;
            }
            if (ob instanceof String) {
                out.writeUTF((String)ob);
                continue;
            }
            if (ob instanceof Float) {
                out.writeFloat(((Float)ob).floatValue());
                continue;
            }
            if (ob instanceof Double) {
                out.writeDouble(((Double)ob).doubleValue());
                continue;
            }
            if (!(ob instanceof NBTTagCompound)) continue;
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)ob), (DataOutput)out);
        }
        out.close();
        return buf;
    }

    public static void doExplosion(World world, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        for (Object ob : world.field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)ob;
            S27PacketExplosion packet = new S27PacketExplosion(explosion.field_77284_b, explosion.field_77285_c, explosion.field_77282_d, explosion.field_77280_f, explosion.field_77281_g, (Vec3)explosion.func_77277_b().get(player));
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }
}

