/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary.Factory;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.Factory.InvalidConfigurationException;

public class DatabaseConfig {
    private final Map<Parameter, String> config = new EnumMap<Parameter, String>(Parameter.class);
    private DBMS type;
    private Logger log;

    public void setType(DBMS type) throws IllegalArgumentException {
        if (type == DBMS.Other) {
            throw new IllegalArgumentException("You can't set your database type to Other");
        }
        this.type = type;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public DBMS getType() {
        return this.type;
    }

    public Logger getLog() {
        return this.log;
    }

    public DatabaseConfig setParameter(Parameter param, String value) throws NullPointerException, InvalidConfigurationException {
        if (this.type == null) {
            throw new NullPointerException("You must set the type of the database first");
        }
        if (!param.validParam(this.type)) {
            throw new InvalidConfigurationException(param.toString() + " is invalid for a database type of : " + this.type.toString());
        }
        this.config.put(param, value);
        return this;
    }

    public String getParameter(Parameter param) {
        return this.config.get((Object)param);
    }

    public boolean isValid() throws InvalidConfigurationException {
        if (this.log == null) {
            throw new InvalidConfigurationException("You need to set the logger.");
        }
        return this.config.size() == Parameter.getCount(this.type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        PREFIX(DBMS.Other),
        HOSTNAME(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
        USERNAME(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
        PASSWORD(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
        PORTNMBR(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
        DATABASE(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
        LOCATION(DBMS.SQLite, DBMS.H2),
        FILENAME(DBMS.SQLite, DBMS.H2);

        private Set<DBMS> dbTypes = new HashSet<DBMS>();
        private static Map<DBMS, Integer> count;

        private Parameter(DBMS ... type) {
            for (int i = 0; i < type.length; ++i) {
                this.dbTypes.add(type[i]);
                Parameter.updateCount(type[i]);
            }
        }

        public boolean validParam(DBMS toCheck) {
            if (this.dbTypes.contains((Object)DBMS.Other)) {
                return true;
            }
            return this.dbTypes.contains((Object)toCheck);
        }

        private static void updateCount(DBMS type) {
            Integer nb;
            if (count == null) {
                count = new EnumMap<DBMS, Integer>(DBMS.class);
            }
            if ((nb = count.get((Object)type)) == null) {
                nb = 1;
            } else {
                Integer n = nb;
                Integer n2 = nb = Integer.valueOf(nb + 1);
            }
            count.put(type, nb);
        }

        public static int getCount(DBMS type) {
            int nb = count.get((Object)DBMS.Other) + count.get((Object)type);
            return nb;
        }
    }
}

