/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.Delegates.HostnameDatabase;
import lib.PatPeter.SQLibrary.Factory.DatabaseFactory;
import lib.PatPeter.SQLibrary.StatementEnum;

public class Firebird
extends Database {
    private HostnameDatabase delegate = DatabaseFactory.hostname();

    public Firebird(Logger log, String prefix, String database, String username, String password) {
        super(log, prefix, "[Firebird] ");
        this.setHostname("localhost");
        this.setPort(3050);
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword(password);
        this.driver = DBMS.Firebird;
    }

    public Firebird(Logger log, String prefix, String hostname, int port, String database, String username, String password) {
        super(log, prefix, "[Firebird] ");
        this.setHostname(hostname);
        this.setPort(port);
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword(password);
        this.driver = DBMS.Firebird;
    }

    public String getHostname() {
        return this.delegate.getHostname();
    }

    private void setHostname(String hostname) {
        this.delegate.setHostname(hostname);
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    private void setPort(int port) {
        this.delegate.setPort(port);
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    private void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    private String getPassword() {
        return this.delegate.getPassword();
    }

    private void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public String getDatabase() {
        return this.delegate.getDatabase();
    }

    private void setDatabase(String database) {
        this.delegate.setDatabase(database);
    }

    protected boolean initialize() {
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.writeError("Firebird driver class missing: " + e.getMessage() + ".", true);
            return false;
        }
    }

    public boolean open() {
        if (this.initialize()) {
            String url = "jdbc:firebirdsql://" + this.getHostname() + ":" + this.getPort() + "/" + this.getDatabase();
            try {
                this.connection = DriverManager.getConnection(url, this.getUsername(), this.getPassword());
                return true;
            }
            catch (SQLException e) {
                this.writeError("Could not establish a Firebird connection, SQLException: " + e.getMessage(), true);
                return false;
            }
        }
        return false;
    }

    protected void queryValidation(StatementEnum statement) throws SQLException {
    }

    public StatementEnum getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    public boolean isTable(String table) {
        throw new UnsupportedOperationException();
    }

    public boolean truncate(String table) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Statements implements StatementEnum
    {

    }
}

