/*
 * Decompiled with CFR 0.152.
 */
package me.alrik94.plugins.cclogger;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.MySQL;
import lib.PatPeter.SQLibrary.SQLite;
import me.alrik94.plugins.cclogger.ChatLogger;
import me.alrik94.plugins.cclogger.CommandLogger;
import me.alrik94.plugins.cclogger.Database;
import me.alrik94.plugins.cclogger.LoginLogger;
import me.alrik94.plugins.cclogger.Notifier;
import me.alrik94.plugins.cclogger.Writer;
import me.alrik94.plugins.cclogger.Zipper;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.mcstats.MetricsLite;

public class CCLogger
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private File configFile;
    private CommandLogger commandLogger;
    private ChatLogger chatLogger;
    private LoginLogger loginLogger;
    public Notifier chatNotifier;
    public Database database;
    public Writer writer;
    public Zipper zipper;
    public SQLite sqlite;
    public MySQL mysql;

    public void onDisable() {
        boolean data = this.getConfig().getBoolean("Database.useDatabase");
        String dataType = this.getConfig().getString("Database.type");
        if (data) {
            if (dataType.equalsIgnoreCase("SQLite")) {
                this.database.sqlite.close();
            }
            if (dataType.equalsIgnoreCase("MySQL")) {
                this.database.mysql.close();
            }
        }
    }

    public void onEnable() {
        boolean data = this.getConfig().getBoolean("Database.useDatabase");
        String dataType = this.getConfig().getString("Database.type");
        this.database = new Database(this);
        this.writer = new Writer(this);
        this.commandLogger = new CommandLogger(this);
        this.chatLogger = new ChatLogger(this);
        this.loginLogger = new LoginLogger(this);
        this.chatNotifier = new Notifier(this);
        this.zipper = new Zipper(this);
        this.configCheck();
        this.folderCheck();
        if (data && dataType.equalsIgnoreCase("SQLite")) {
            try {
                this.database.sqliteConnection();
            }
            catch (IOException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.database.sqliteTableCheck();
            }
            catch (SQLException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (data && dataType.equalsIgnoreCase("MySQL")) {
            try {
                this.database.mysqlConnection();
            }
            catch (IOException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.database.mysqlTableCheck();
            }
            catch (SQLException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println("[CCLogger] Database usage is disabled. Some commands will not work.");
        }
        try {
            MetricsLite metrics = new MetricsLite((Plugin)this);
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("[CCLogger] has been enabled.");
    }

    public void folderCheck() {
        File playersFolder = new File(this.getDataFolder(), "players");
        if (!playersFolder.exists()) {
            playersFolder.mkdir();
        }
    }

    public void configCheck() {
        String[] blacklist = new String[]{"/help", "/who", "/home"};
        String[] commandNotifyList = new String[]{"/pl", "/item", "/give"};
        String[] chatNotifyList = new String[]{"kill", "ddos", "hack", "flymod"};
        String hostName = "127.0.0.1";
        String databaseName = "CCLogger";
        int portValue = 3306;
        String username = "test";
        String password = "test";
        File dataFolder = this.getDataFolder();
        try {
            this.config = this.getConfig();
            this.configFile = new File(dataFolder, "config.yml");
            if (!dataFolder.exists()) {
                dataFolder.mkdir();
            }
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            this.config.options().header(this.defaultFormat());
            if (!this.config.contains("Database.useDatabase")) {
                this.config.set("Database.useDatabase", (Object)false);
            }
            if (!this.config.contains("Database.type")) {
                this.config.addDefault("Database.type", (Object)"SQLite");
            }
            if (!this.config.contains("Database.connection.hostname")) {
                this.config.addDefault("Database.connection.hostname", (Object)hostName);
            }
            if (!this.config.contains("Database.connection.database")) {
                this.config.addDefault("Database.connection.database", (Object)databaseName);
            }
            if (!this.config.contains("Database.connection.port")) {
                this.config.addDefault("Database.connection.port", (Object)portValue);
            }
            if (!this.config.contains("Database.connection.username")) {
                this.config.addDefault("Database.connection.username", (Object)username);
            }
            if (!this.config.contains("Database.connection.password")) {
                this.config.addDefault("Database.connection.password", (Object)password);
            }
            if (!this.config.contains("Log.toggle.globalCommands")) {
                this.config.set("Log.toggle.globalCommands", (Object)true);
            }
            if (!this.config.contains("Log.toggle.globalChat")) {
                this.config.set("Log.toggle.globalChat", (Object)true);
            }
            if (!this.config.contains("Log.toggle.playerCommands")) {
                this.config.set("Log.toggle.playerCommands", (Object)true);
            }
            if (!this.config.contains("Log.toggle.playerChat")) {
                this.config.set("Log.toggle.playerChat", (Object)true);
            }
            if (!this.config.contains("Log.toggle.logNotifyChat")) {
                this.config.set("Log.toggle.logNotifyChat", (Object)true);
            }
            if (!this.config.contains("Log.toggle.inGameNotifications")) {
                this.config.set("Log.toggle.inGameNotifications", (Object)true);
            }
            if (!this.config.contains("Log.toggle.logNotifyCommands")) {
                this.config.set("Log.toggle.logNotifyCommands", (Object)true);
            }
            if (!this.config.contains("Log.toggle.playerLogin")) {
                this.config.set("Log.toggle.playerLogin", (Object)true);
            }
            if (!this.config.contains("Log.toggle.globalLogin")) {
                this.config.set("Log.toggle.globalLogin", (Object)true);
            }
            if (!this.config.contains("Log.commands.blacklist")) {
                this.config.addDefault("Log.commands.blacklist", Arrays.asList(blacklist));
            }
            if (!this.config.contains("Log.logFormat")) {
                this.config.addDefault("Log.logFormat", (Object)"[%ip][%date (%world: %x,%y,%z)] %name: %content");
            }
            if (!this.config.contains("Log.notifications.chat")) {
                this.config.addDefault("Log.notifications.chat", Arrays.asList(chatNotifyList));
            }
            if (!this.config.contains("Log.notifications.commands")) {
                this.config.addDefault("Log.notifications.commands", Arrays.asList(commandNotifyList));
            }
            this.config.options().copyDefaults(true);
            this.saveConfig();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String defaultFormat() {
        String dateFormat = "%date = The date and time when the content is logged.\n";
        String worldFormat = "%world = The world the player is in when the content is logged.\n";
        String xCoord = "%x = The x coordinate of player when the content is logged.\n";
        String yCoord = "%y = The y coordinate of player when the content is logged.\n";
        String zCoord = "%z = The z coordinate of player when the content is logged.\n";
        String nameFormat = "%name = The name of the player that created the content that is logged.\n";
        String contentFormat = "%content = The content that is logged.\n";
        String format = dateFormat + worldFormat + xCoord + yCoord + zCoord + nameFormat + contentFormat;
        return format;
    }

    public void ccreload(CommandSender sender) {
        this.reloadConfig();
        boolean data = this.getConfig().getBoolean("Database.useDatabase");
        String dataType = this.getConfig().getString("Database.type");
        if (data && dataType.equalsIgnoreCase("SQLite")) {
            try {
                this.database.sqliteConnection();
            }
            catch (IOException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.database.sqliteTableCheck();
            }
            catch (SQLException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (data && dataType.equalsIgnoreCase("MySQL")) {
            try {
                this.database.mysqlConnection();
            }
            catch (IOException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.database.mysqlTableCheck();
            }
            catch (SQLException ex) {
                Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println("[CCLogger] Database usage is disabled. Some commands will not work.");
        }
        sender.sendMessage(ChatColor.BLUE + "[CCLogger] configuration reloaded.");
    }

    public void deleteDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    this.deleteDirectory(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        boolean data = this.getConfig().getBoolean("Database.useDatabase");
        if (cmd.getName().equalsIgnoreCase("ccreload")) {
            this.ccreload(sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("ccl")) {
            if (args.length > 0 && args[0].equalsIgnoreCase("clear")) {
                File chatLog = new File(this.getDataFolder().getAbsolutePath() + "/chat.log");
                File commandLog = new File(this.getDataFolder().getAbsolutePath() + "/commands.log");
                File playerDirectory = new File(this.getDataFolder().getAbsolutePath() + "/players/");
                try {
                    this.zipper.zipDir(playerDirectory, "", this.getDataFolder().getAbsolutePath() + "/players" + this.chatLogger.getZipDate() + ".zip");
                    this.zipper.zipFile(chatLog, this.getDataFolder().getAbsolutePath() + "/chatLog" + this.chatLogger.getZipDate() + ".zip");
                    this.zipper.zipFile(commandLog, this.getDataFolder().getAbsolutePath() + "/commandLog" + this.chatLogger.getZipDate() + ".zip");
                    chatLog.delete();
                    commandLog.delete();
                    this.deleteDirectory(playerDirectory);
                    this.reloadConfig();
                }
                catch (IOException ex) {
                    Logger.getLogger(CCLogger.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.folderCheck();
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("count")) {
                String word;
                if (args.length == 1) {
                    sender.sendMessage(ChatColor.RED + "/ccl count <word> <player>");
                }
                if (args.length == 2) {
                    if (data) {
                        word = args[1];
                        int count = 0;
                        try {
                            count = this.database.countWord(word);
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                        sender.sendMessage(ChatColor.BLUE + word + ChatColor.RED + " has been said " + ChatColor.BLUE + count + ChatColor.RED + " times.");
                    } else {
                        sender.sendMessage(ChatColor.RED + "Database use is disabled. This command only works if database use is enabled.");
                    }
                }
                if (args.length == 3) {
                    if (data) {
                        word = args[1];
                        String playerName = args[2];
                        int count = 0;
                        try {
                            count = this.database.countWordFromPlayer(playerName, word);
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                        sender.sendMessage(ChatColor.RED + playerName + " has said " + ChatColor.BLUE + word + " " + count + ChatColor.RED + " times.");
                    } else {
                        sender.sendMessage(ChatColor.RED + "Database use is disabled. This command only works if database use is enabled.");
                    }
                }
            }
            return true;
        }
        return false;
    }
}

