/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary.Delegates;

import java.io.File;
import lib.PatPeter.SQLibrary.DatabaseException;
import lib.PatPeter.SQLibrary.Delegates.FilenameDatabase;

public class FilenameDatabaseImpl
implements FilenameDatabase {
    private String directory;
    private String filename;
    private File file;
    private String extension = ".db";

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        if (directory == null || directory.length() == 0) {
            throw new DatabaseException("Directory cannot be null or empty.");
        }
        this.directory = directory;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        if (filename == null || filename.length() == 0) {
            throw new DatabaseException("Filename cannot be null or empty.");
        }
        if (filename.contains("/") || filename.contains("\\") || filename.endsWith(".db")) {
            throw new DatabaseException("The database filename cannot contain: /, \\, or .db.");
        }
        this.filename = filename;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        if (extension == null || extension.length() == 0) {
            throw new DatabaseException("Extension cannot be null or empty.");
        }
        if (extension.charAt(0) != '.') {
            throw new DatabaseException("Extension must begin with a period");
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(String directory, String filename) throws DatabaseException {
        this.setDirectory(directory);
        this.setFilename(filename);
        File folder = new File(this.getDirectory());
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.file = new File(folder.getAbsolutePath() + File.separator + this.getFilename() + this.getExtension());
    }

    public void setFile(String directory, String filename, String extension) throws DatabaseException {
        this.setExtension(extension);
        this.setFile(directory, filename);
    }
}

