/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.DatabaseException;
import lib.PatPeter.SQLibrary.Delegates.HostnameDatabase;
import lib.PatPeter.SQLibrary.Factory.DatabaseFactory;
import lib.PatPeter.SQLibrary.StatementEnum;

public class MySQL
extends Database {
    private HostnameDatabase delegate = DatabaseFactory.hostname();

    public MySQL(Logger log, String prefix, String database, String username, String password) {
        super(log, prefix, "[MySQL] ");
        this.setHostname("localhost");
        this.setPort(3306);
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword(password);
        this.driver = DBMS.MySQL;
    }

    @Deprecated
    public MySQL(Logger log, String prefix, String hostname, String port, String database, String username, String password) {
        super(log, prefix, "[MySQL] ");
        this.setHostname(hostname);
        try {
            this.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            throw new DatabaseException("Port must be a number.");
        }
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword(password);
        this.driver = DBMS.MySQL;
    }

    public MySQL(Logger log, String prefix, String hostname, int port, String database, String username, String password) {
        super(log, prefix, "[MySQL] ");
        this.setHostname(hostname);
        this.setPort(port);
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword(password);
        this.driver = DBMS.MySQL;
    }

    public String getHostname() {
        return this.delegate.getHostname();
    }

    private void setHostname(String hostname) {
        this.delegate.setHostname(hostname);
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    private void setPort(int port) {
        this.delegate.setPort(port);
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    private void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    private String getPassword() {
        return this.delegate.getPassword();
    }

    private void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public String getDatabase() {
        return this.delegate.getDatabase();
    }

    private void setDatabase(String database) {
        this.delegate.setDatabase(database);
    }

    protected boolean initialize() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.writeError("MySQL driver class missing: " + e.getMessage() + ".", true);
            return false;
        }
    }

    public boolean open() {
        if (this.initialize()) {
            String url = "jdbc:mysql://" + this.getHostname() + ":" + this.getPort() + "/" + this.getDatabase();
            try {
                this.connection = DriverManager.getConnection(url, this.getUsername(), this.getPassword());
                return true;
            }
            catch (SQLException e) {
                this.writeError("Could not establish a MySQL connection, SQLException: " + e.getMessage(), true);
                return false;
            }
        }
        return false;
    }

    protected void queryValidation(StatementEnum statement) throws SQLException {
        switch ((Statements)statement) {
            case USE: {
                this.writeError("Please create a new connection to use a different database.", false);
                throw new SQLException("Please create a new connection to use a different database.");
            }
            case PREPARE: 
            case EXECUTE: 
            case DEALLOCATE: {
                this.writeError("Please use the prepare() method to prepare a query.", false);
                throw new SQLException("Please use the prepare() method to prepare a query.");
            }
        }
    }

    public Statements getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    @Deprecated
    public boolean createTable(String query) {
        Statement statement = null;
        if (query == null || query.equals("")) {
            this.writeError("Could not create table: query is empty or null.", true);
            return false;
        }
        try {
            statement = this.connection.createStatement();
            statement.execute(query);
            statement.close();
        }
        catch (SQLException e) {
            this.writeError("Could not create table, SQLException: " + e.getMessage(), true);
            return false;
        }
        return true;
    }

    public boolean isTable(String table) {
        Statement statement;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException e) {
            this.writeError("Could not create a statement in checkTable(), SQLException: " + e.getMessage(), true);
            return false;
        }
        try {
            statement.executeQuery("SELECT * FROM " + table);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean truncate(String table) {
        Statement statement = null;
        String query = null;
        try {
            if (!this.isTable(table)) {
                this.writeError("Table \"" + table + "\" does not exist.", true);
                return false;
            }
            statement = this.connection.createStatement();
            query = "DELETE FROM " + table + ";";
            statement.executeUpdate(query);
            statement.close();
            return true;
        }
        catch (SQLException e) {
            this.writeError("Could not wipe table, SQLException: " + e.getMessage(), true);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Statements implements StatementEnum
    {
        SELECT("SELECT"),
        INSERT("INSERT"),
        UPDATE("UPDATE"),
        DELETE("DELETE"),
        DO("DO"),
        REPLACE("REPLACE"),
        LOAD("LOAD"),
        HANDLER("HANDLER"),
        CALL("CALL"),
        CREATE("CREATE"),
        ALTER("ALTER"),
        DROP("DROP"),
        TRUNCATE("TRUNCATE"),
        RENAME("RENAME"),
        START("START"),
        COMMIT("COMMIT"),
        SAVEPOINT("SAVEPOINT"),
        ROLLBACK("ROLLBACK"),
        RELEASE("RELEASE"),
        LOCK("LOCK"),
        UNLOCK("UNLOCK"),
        PREPARE("PREPARE"),
        EXECUTE("EXECUTE"),
        DEALLOCATE("DEALLOCATE"),
        SET("SET"),
        SHOW("SHOW"),
        DESCRIBE("DESCRIBE"),
        EXPLAIN("EXPLAIN"),
        HELP("HELP"),
        USE("USE");

        private String string;

        private Statements(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

