/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.Delegates.FilenameDatabase;
import lib.PatPeter.SQLibrary.Factory.DatabaseFactory;
import lib.PatPeter.SQLibrary.StatementEnum;

public class SQLite
extends Database {
    private FilenameDatabase delegate = DatabaseFactory.filename();

    public SQLite(Logger log, String prefix, String directory, String filename) {
        super(log, prefix, "[SQLite] ");
        this.setFile(directory, filename);
        this.driver = DBMS.SQLite;
    }

    public SQLite(Logger log, String prefix, String directory, String filename, String extension) {
        super(log, prefix, "[H2] ");
        this.setFile(directory, filename, extension);
        this.driver = DBMS.H2;
    }

    private File getFile() {
        return this.delegate.getFile();
    }

    private void setFile(String directory, String filename) {
        this.delegate.setFile(directory, filename);
    }

    private void setFile(String directory, String filename, String extension) {
        this.delegate.setFile(directory, filename, extension);
    }

    protected boolean initialize() {
        try {
            Class.forName("org.sqlite.JDBC");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.writeError("Class not found in initialize(): " + e, true);
            return false;
        }
    }

    public boolean open() {
        if (this.initialize()) {
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.getFile().getAbsolutePath());
                return true;
            }
            catch (SQLException e) {
                this.writeError("Could not establish an SQLite connection, SQLException: " + e.getMessage(), true);
                return false;
            }
        }
        return false;
    }

    protected void queryValidation(StatementEnum statement) throws SQLException {
    }

    public Statements getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    @Deprecated
    public boolean createTable(String query) {
        Statement statement = null;
        try {
            if (query == null || query.equals("")) {
                this.writeError("Could not create table: query is empty or null.", true);
                return false;
            }
            statement = this.connection.createStatement();
            statement.execute(query);
            statement.close();
            return true;
        }
        catch (SQLException e) {
            this.writeError("Could not create table, SQLException: " + e.getMessage(), true);
            return false;
        }
    }

    public boolean isTable(String table) {
        DatabaseMetaData md = null;
        try {
            md = this.connection.getMetaData();
            ResultSet tables = md.getTables(null, null, table, null);
            if (tables.next()) {
                tables.close();
                return true;
            }
            tables.close();
            return false;
        }
        catch (SQLException e) {
            this.writeError("Could not check if table \"" + table + "\" exists, SQLException: " + e.getMessage(), true);
            return false;
        }
    }

    public boolean truncate(String table) {
        Statement statement = null;
        String query = null;
        try {
            if (!this.isTable(table)) {
                this.writeError("Table \"" + table + "\" does not exist.", true);
                return false;
            }
            statement = this.connection.createStatement();
            query = "DELETE FROM " + table + ";";
            statement.executeQuery(query);
            statement.close();
            return true;
        }
        catch (SQLException e) {
            if (!(e.getMessage().toLowerCase().contains("locking") || e.getMessage().toLowerCase().contains("locked") || e.toString().contains("not return ResultSet"))) {
                this.writeError("Error in wipeTable() query: " + e, false);
            }
            return false;
        }
    }

    @Deprecated
    public ResultSet retry(String query) {
        try {
            return this.getConnection().createStatement().executeQuery(query);
        }
        catch (SQLException e) {
            if (e.getMessage().toLowerCase().contains("locking") || e.getMessage().toLowerCase().contains("locked")) {
                this.writeError("Please close your previous ResultSet to run the query: \n\t" + query, false);
            } else {
                this.writeError("SQLException in retry(): " + e.getMessage(), false);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Statements implements StatementEnum
    {
        SELECT("SELECT"),
        INSERT("INSERT"),
        UPDATE("UPDATE"),
        DELETE("DELETE"),
        REPLACE("REPLACE"),
        CREATE("CREATE"),
        ALTER("ALTER"),
        DROP("DROP"),
        ANALYZE("ANALYZE"),
        ATTACH("ATTACH"),
        BEGIN("BEGIN"),
        DETACH("DETACH"),
        END("END"),
        EXPLAIN("EXPLAIN"),
        INDEXED("INDEXED"),
        PRAGMA("PRAGMA"),
        REINDEX("REINDEX"),
        RELEASE("RELEASE"),
        SAVEPOINT("SAVEPOINT"),
        VACUUM("VACUUM"),
        LINE_COMMENT("--"),
        BLOCK_COMMENT("/*");

        private String string;

        private Statements(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

