/*
 * Decompiled with CFR 0.152.
 */
package me.alrik94.plugins.cclogger;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import me.alrik94.plugins.cclogger.CCLogger;
import me.alrik94.plugins.cclogger.Notifier;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class CommandLogger
implements Listener {
    private CCLogger plugin;
    private Notifier notifier;

    public CommandLogger(CCLogger plugins) {
        this.plugin = plugins;
        plugins.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugins);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) throws IOException, SQLException {
        Player player = event.getPlayer();
        String name = player.getName();
        String command = event.getMessage();
        Location location = player.getLocation();
        int xLocation = (int)location.getX();
        int yLocation = (int)location.getY();
        int zLocation = (int)location.getZ();
        World world = location.getWorld();
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        String worldName = world.getName();
        String date = this.getDate();
        this.checkPlayer(name);
        this.processInformation(player, name, command, xLocation, yLocation, zLocation, worldName, date, ipAddress);
    }

    public void processInformation(Player player, String playerName, String command, int x, int y, int z, String worldName, String date, String ipAddress) throws SQLException {
        boolean data = this.plugin.getConfig().getBoolean("Database.useDatabase");
        boolean playerCommand = this.plugin.getConfig().getBoolean("Log.toggle.playerCommands");
        boolean globalCommand = this.plugin.getConfig().getBoolean("Log.toggle.globalCommands");
        boolean logNotifyCommands = this.plugin.getConfig().getBoolean("Log.toggle.logNotifyCommands");
        boolean inGameNotifications = this.plugin.getConfig().getBoolean("Log.toggle.inGameNotifications");
        File playersFolder = new File(this.plugin.getDataFolder(), "players");
        File commandFile = new File(this.plugin.getDataFolder(), "commands.log");
        File playerFile = new File(playersFolder, playerName + ".log");
        File notifyCommandFile = new File(this.plugin.getDataFolder(), "notifyCommands.log");
        if (!this.checkExemptionList(player)) {
            if (globalCommand && !this.commandCheck(command)) {
                this.plugin.writer.writeFile(this.formatLog(playerName, command, x, y, z, worldName, date, ipAddress), commandFile);
            }
            if (playerCommand && !this.commandCheck(command)) {
                this.plugin.writer.writeFile(this.formatLog(playerName, command, x, y, z, worldName, date, ipAddress), playerFile);
            }
            if (this.checkNotifyList(command) && logNotifyCommands) {
                this.plugin.writer.writeFile(this.formatLog(playerName, command, x, y, z, worldName, date, ipAddress), notifyCommandFile);
            }
            if (this.checkNotifyList(command) && inGameNotifications) {
                this.plugin.chatNotifier.notifyPlayer(ChatColor.BLUE + "[" + ChatColor.RED + "CCLogger" + ChatColor.BLUE + "] " + ChatColor.GOLD + playerName + ": " + ChatColor.WHITE + command);
            }
        }
        if (data) {
            this.plugin.database.writeCommandContent(playerName, this.checkApos(command), x, y, z, worldName, date, ipAddress);
        }
    }

    public String checkApos(String command) {
        String fixed = command.replaceAll("'", "''");
        return fixed;
    }

    public String[] formatLog(String playerName, String command, int x, int y, int z, String worldName, String date, String ipAddress) {
        String format = this.plugin.getConfig().getString("Log.logFormat");
        String log = format;
        if (log.contains("%ip")) {
            log = log.replaceAll("%ip", ipAddress);
        }
        if (log.contains("%date")) {
            log = log.replaceAll("%date", date);
        }
        if (log.contains("%world")) {
            log = log.replaceAll("%world", worldName);
        }
        if (log.contains("%x")) {
            log = log.replaceAll("%x", Integer.toString(x));
        }
        if (log.contains("%y")) {
            log = log.replaceAll("%y", Integer.toString(y));
        }
        if (log.contains("%z")) {
            log = log.replaceAll("%z", Integer.toString(z));
        }
        if (log.contains("%name")) {
            log = log.replaceAll("%name", playerName);
        }
        if (log.contains("%content")) {
            log = log.replaceAll("%content", Matcher.quoteReplacement(command));
        }
        String[] logArray = new String[]{log};
        return logArray;
    }

    public boolean commandCheck(String command) {
        List commands = this.plugin.getConfig().getStringList("Log.commands.blacklist");
        String[] commandsplit = command.split(" ");
        String commandconvert = commandsplit[0];
        for (int i = 0; i < commands.size(); ++i) {
            if (!commandconvert.matches((String)commands.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean checkNotifyList(String command) {
        List commands = this.plugin.getConfig().getStringList("Log.notifications.commands");
        String[] commandsplit = command.split(" ");
        String commandconvert = commandsplit[0];
        for (int i = 0; i < commands.size(); ++i) {
            if (!commandconvert.matches((String)commands.get(i))) continue;
            return true;
        }
        return false;
    }

    public void checkPlayer(String name) throws IOException {
        File playersFolder = new File(this.plugin.getDataFolder(), "players");
        File file = new File(playersFolder, name + ".log");
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public boolean checkExemptionList(Player player) {
        return player.hasPermission("cclogger.exempt");
    }
}

