/*
 * Decompiled with CFR 0.152.
 */
package me.alrik94.plugins.cclogger;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import lib.PatPeter.SQLibrary.MySQL;
import lib.PatPeter.SQLibrary.SQLite;
import me.alrik94.plugins.cclogger.CCLogger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.plugin.Plugin;

public class Database {
    private CCLogger plugin;
    public SQLite sqlite;
    public MySQL mysql;

    public Database(CCLogger plugins) {
        this.plugin = plugins;
    }

    public void sqliteConnection() throws IOException {
        this.sqlite = new SQLite(this.plugin.getLogger(), "CCLogger", this.plugin.getDataFolder().getAbsolutePath(), "chat");
        try {
            this.sqlite.open();
            System.out.println("[CCLogger] SQLite successfully connected!");
        }
        catch (Exception e) {
            this.plugin.getLogger().info(e.getMessage());
            this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
        }
    }

    public void mysqlConnection() throws IOException {
        String hostName = this.plugin.getConfig().getString("Database.connection.hostname");
        String databaseName = this.plugin.getConfig().getString("Database.connection.database");
        int portValue = this.plugin.getConfig().getInt("Database.connection.port");
        String username = this.plugin.getConfig().getString("Database.connection.username");
        String password = this.plugin.getConfig().getString("Database.connection.password");
        String prefix = "CCLogger";
        this.mysql = new MySQL(this.plugin.getLogger(), prefix, hostName, portValue, databaseName, username, password);
        try {
            this.mysql.open();
            System.out.println("[CCLogger] MySQL successfully connected!");
        }
        catch (Exception e) {
            this.plugin.getLogger().info(e.getMessage());
            this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
        }
    }

    public void sqliteTableCheck() throws SQLException {
        if (this.sqlite.isTable("chat")) {
            return;
        }
        this.sqlite.query("CREATE TABLE 'chat'(playername VARCHAR(50), content VARCHAR(50), xlocation VARCHAR(50), ylocation VARCHAR(50), zlocation VARCHAR(50), worldname VARCHAR(50), date VARCHAR(50), ipaddress VARCHAR(50));");
        this.sqlite.query("INSERT INTO 'chat'(playername, content) VALUES('Pew446', '08/09/2012');");
        this.plugin.getLogger().info("Table 'chat' has been created");
        if (this.sqlite.isTable("commands")) {
            return;
        }
        this.sqlite.query("CREATE TABLE 'commands'(playername VARCHAR(50), content VARCHAR(50), xlocation VARCHAR(50), ylocation VARCHAR(50), zlocation VARCHAR(50), worldname VARCHAR(50), date VARCHAR(50), ipaddress VARCHAR(50));");
        this.sqlite.query("INSERT INTO 'commands'(playername, content) VALUES('Pew446', '08/09/2012');");
        this.plugin.getLogger().info("Table 'commands' has been created");
        if (this.sqlite.isTable("logins")) {
            return;
        }
        this.sqlite.query("CREATE TABLE 'logins'(playername VARCHAR(50), loginlogout VARCHAR(50), xlocation VARCHAR(50), ylocation VARCHAR(50), zlocation VARCHAR(50), worldname VARCHAR(50), date VARCHAR(50), ipaddress VARCHAR(50));");
        this.sqlite.query("INSERT INTO 'logins'(playername, loginlogout) VALUES('Pew446', '1');");
        this.plugin.getLogger().info("Table 'logins' has been created");
    }

    public void mysqlTableCheck() throws SQLException {
        if (this.mysql.isTable("chat")) {
            return;
        }
        this.mysql.query("CREATE TABLE chat (playername VARCHAR(50), content VARCHAR(50), xlocation VARCHAR(50), ylocation VARCHAR(50), zlocation VARCHAR(50), worldname VARCHAR(50), date VARCHAR(50), ipaddress VARCHAR(50));");
        this.mysql.query("INSERT INTO chat (playername, content) VALUES('Pew446', '08/09/2012');");
        this.plugin.getLogger().info("Table 'chat' has been created");
        if (this.mysql.isTable("commands")) {
            return;
        }
        this.mysql.query("CREATE TABLE commands (playername VARCHAR(50), content VARCHAR(50), xlocation VARCHAR(50), ylocation VARCHAR(50), zlocation VARCHAR(50), worldname VARCHAR(50), date VARCHAR(50), ipaddress VARCHAR(50));");
        this.mysql.query("INSERT INTO commands (playername, content) VALUES('Pew446', '08/09/2012');");
        this.plugin.getLogger().info("Table 'commands' has been created");
        if (this.mysql.isTable("logins")) {
            return;
        }
        this.mysql.query("CREATE TABLE logins (playername VARCHAR(50), loginlogout VARCHAR(50), xlocation VARCHAR(50), ylocation VARCHAR(50), zlocation VARCHAR(50), worldname VARCHAR(50), date VARCHAR(50), ipaddress VARCHAR(50));");
        this.mysql.query("INSERT INTO logins (playername, loginlogout) VALUES('Pew446', '1');");
        this.plugin.getLogger().info("Table 'logins' has been created");
    }

    public void writeChatContent(String playerName, String content, int x, int y, int z, String worldName, String date, String ipAddress) throws SQLException {
        String dataType = this.plugin.getConfig().getString("Database.type");
        if (dataType.equalsIgnoreCase("SQLite")) {
            this.sqlite.query("INSERT INTO 'chat'(playername, content, xlocation, ylocation, zlocation, worldname, date, ipaddress) VALUES('" + playerName + "', '" + content + "', '" + x + "', '" + y + "', '" + z + "', '" + worldName + "', '" + date + "', '" + ipAddress + "');");
        } else if (dataType.equalsIgnoreCase("MySQL")) {
            this.mysql.query("INSERT INTO chat (playername, content, xlocation, ylocation, zlocation, worldname, date, ipaddress) VALUES('" + playerName + "', '" + content + "', '" + x + "', '" + y + "', '" + z + "', '" + worldName + "', '" + date + "', '" + ipAddress + "');");
        }
    }

    public void writeCommandContent(String playerName, String command, int x, int y, int z, String worldName, String date, String ipAddress) throws SQLException {
        String dataType = this.plugin.getConfig().getString("Database.type");
        if (dataType.equalsIgnoreCase("SQLite")) {
            this.sqlite.query("INSERT INTO 'commands'(playername, content, xlocation, ylocation, zlocation, worldname, date, ipaddress) VALUES('" + playerName + "', '" + command + "', '" + x + "', '" + y + "', '" + z + "', '" + worldName + "', '" + date + "', '" + ipAddress + "');");
        } else if (dataType.equalsIgnoreCase("MySQL")) {
            this.mysql.query("INSERT INTO commands (playername, content, xlocation, ylocation, zlocation, worldname, date, ipaddress) VALUES('" + playerName + "', '" + command + "', '" + x + "', '" + y + "', '" + z + "', '" + worldName + "', '" + date + "', '" + ipAddress + "');");
        }
    }

    public void writeLoginContent(String playerName, String loginlogout, int x, int y, int z, String worldName, String date, String ipAddress) throws SQLException {
        String dataType = this.plugin.getConfig().getString("Database.type");
        if (dataType.equalsIgnoreCase("SQLite")) {
            this.sqlite.query("INSERT INTO 'logins'(playername, loginlogout, xlocation, ylocation, zlocation, worldname, date, ipaddress) VALUES('" + playerName + "', '" + loginlogout + "', '" + x + "', '" + y + "', '" + z + "', '" + worldName + "', '" + date + "', '" + ipAddress + "');");
        } else if (dataType.equalsIgnoreCase("MySQL")) {
            this.mysql.query("INSERT INTO logins (playername, loginlogout, xlocation, ylocation, zlocation, worldname, date, ipaddress) VALUES('" + playerName + "', '" + loginlogout + "', '" + x + "', '" + y + "', '" + z + "', '" + worldName + "', '" + date + "', '" + ipAddress + "');");
        }
    }

    public int countWordFromPlayer(String playerName, String word) throws SQLException {
        int count = 0;
        String dataType = this.plugin.getConfig().getString("Database.type");
        ResultSet result = null;
        if (dataType.equalsIgnoreCase("SQLite")) {
            result = this.sqlite.query("SELECT content FROM chat WHERE playername='" + playerName + "';");
        } else if (dataType.equalsIgnoreCase("MySQL")) {
            result = this.mysql.query("SELECT content FROM chat WHERE playername='" + playerName + "';");
        }
        while (result.next()) {
            String searched;
            String content = result.getString("content").toLowerCase();
            if (!content.contains(searched = word.toLowerCase())) continue;
            int times = StringUtils.countMatches((String)content, (String)searched);
            count += times;
        }
        return count;
    }

    public int countWord(String word) throws SQLException {
        String dataType = this.plugin.getConfig().getString("Database.type");
        int count = 0;
        ResultSet result = null;
        if (dataType.equalsIgnoreCase("SQLite")) {
            result = this.sqlite.query("SELECT content FROM chat;");
        } else if (dataType.equalsIgnoreCase("MySQL")) {
            result = this.mysql.query("SELECT content FROM chat;");
        }
        while (result.next()) {
            String searched;
            String content = result.getString("content").toLowerCase();
            if (!content.contains(searched = word.toLowerCase())) continue;
            int times = StringUtils.countMatches((String)content, (String)searched);
            count += times;
        }
        return count;
    }

    public int totalPlayerChatCount(String playerName) throws SQLException {
        String dataType = this.plugin.getConfig().getString("Database.type");
        int count = 0;
        ResultSet result = null;
        if (dataType.equalsIgnoreCase("SQLite")) {
            result = this.sqlite.query("SELECT content FROM chat WHERE playername='" + playerName + "';");
        } else if (dataType.equalsIgnoreCase("MySQL")) {
            result = this.mysql.query("SELECT content FROM chat WHERE playername='" + playerName + "';");
        }
        while (result.next()) {
            String[] content = result.getString("content").toLowerCase().split(" ");
            for (int i = 0; i < content.length; ++i) {
                if (content[i].equals(" ")) continue;
                ++count;
            }
        }
        return count;
    }
}

