/*
 * Decompiled with CFR 0.152.
 */
package me.alrik94.plugins.cclogger;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.alrik94.plugins.cclogger.CCLogger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LoginLogger
implements Listener {
    private CCLogger plugin;

    public LoginLogger(CCLogger plugins) {
        this.plugin = plugins;
        plugins.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugins);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) throws IOException, SQLException {
        Player player = event.getPlayer();
        String name = player.getName();
        Location location = player.getLocation();
        int x = (int)location.getX();
        int y = (int)location.getY();
        int z = (int)location.getZ();
        World world = location.getWorld();
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        String worldName = world.getName();
        String date = this.getDate();
        String login = "1";
        this.checkPlayer(name);
        this.processInformationJoin(player, name, login, x, y, z, worldName, date, ipAddress);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) throws IOException, SQLException {
        Player player = event.getPlayer();
        String name = player.getName();
        Location location = player.getLocation();
        int x = (int)location.getX();
        int y = (int)location.getY();
        int z = (int)location.getZ();
        World world = location.getWorld();
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        String worldName = world.getName();
        String date = this.getDate();
        String login = "0";
        this.checkPlayer(name);
        this.processInformationQuit(player, name, login, x, y, z, worldName, date, ipAddress);
    }

    public void processInformationJoin(Player player, String playerName, String login, int x, int y, int z, String worldName, String date, String ipAddress) throws SQLException {
        boolean data = this.plugin.getConfig().getBoolean("Database.useDatabase");
        boolean globalLogin = this.plugin.getConfig().getBoolean("Log.toggle.globalLogin");
        boolean playerLogin = this.plugin.getConfig().getBoolean("Log.toggle.playerLogin");
        File playersFolder = new File(this.plugin.getDataFolder(), "players");
        File chatFile = new File(this.plugin.getDataFolder(), "chat.log");
        File playerFile = new File(playersFolder, playerName + ".log");
        String[] log = new String[]{"[" + date + "] " + playerName + " logged in."};
        if (!this.checkExemptionList(player)) {
            if (globalLogin) {
                this.plugin.writer.writeFile(log, chatFile);
            }
            if (playerLogin) {
                this.plugin.writer.writeFile(log, playerFile);
            }
        }
        if (data) {
            this.plugin.database.writeLoginContent(playerName, login, x, y, z, worldName, date, ipAddress);
        }
    }

    public void processInformationQuit(Player player, String playerName, String login, int x, int y, int z, String worldName, String date, String ipAddress) throws SQLException {
        boolean data = this.plugin.getConfig().getBoolean("Database.useDatabase");
        boolean globalLogin = this.plugin.getConfig().getBoolean("Log.toggle.globalLogin");
        boolean playerLogin = this.plugin.getConfig().getBoolean("Log.toggle.playerLogin");
        File playersFolder = new File(this.plugin.getDataFolder(), "players");
        File chatFile = new File(this.plugin.getDataFolder(), "chat.log");
        File playerFile = new File(playersFolder, playerName + ".log");
        String[] log = new String[]{"[" + date + "] " + playerName + " logged out."};
        if (!this.checkExemptionList(player)) {
            if (globalLogin) {
                this.plugin.writer.writeFile(log, chatFile);
            }
            if (playerLogin) {
                this.plugin.writer.writeFile(log, playerFile);
            }
        }
        if (data) {
            this.plugin.database.writeLoginContent(playerName, login, x, y, z, worldName, date, ipAddress);
        }
    }

    public void checkPlayer(String name) throws IOException {
        File playersFolder = new File(this.plugin.getDataFolder(), "players");
        File file = new File(playersFolder, name + ".log");
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public boolean checkExemptionList(Player player) {
        return player.hasPermission("cclogger.exempt");
    }
}

