/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.fuin.utils4j.Taggable;
import org.fuin.utils4j.Utils4J;

public class ChangeTrackingUniqueList
implements List,
Taggable {
    private final List list;
    private final List added;
    private final List deleted;
    private boolean tagged;

    public ChangeTrackingUniqueList(List list) {
        Utils4J.checkNotNull("list", list);
        this.list = list;
        this.added = new ArrayList();
        this.deleted = new ArrayList();
        this.tagged = true;
    }

    public final boolean isChanged() {
        return this.added.size() > 0 || this.deleted.size() > 0;
    }

    public final List getDeleted() {
        return Collections.unmodifiableList(this.deleted);
    }

    public final List getAdded() {
        return Collections.unmodifiableList(this.added);
    }

    public final void revert() {
        if (this.tagged) {
            Iterator addedIt = this.added.iterator();
            while (addedIt.hasNext()) {
                Object entry = addedIt.next();
                this.list.remove(entry);
                addedIt.remove();
            }
            Iterator removedIt = this.deleted.iterator();
            while (removedIt.hasNext()) {
                Object entry = removedIt.next();
                this.list.add(entry);
                removedIt.remove();
            }
        }
    }

    private void addIntern(Object o) {
        if (this.tagged) {
            int idx = this.deleted.indexOf(o);
            if (idx == -1) {
                this.added.add(o);
            } else {
                this.deleted.remove(idx);
            }
        }
    }

    public final boolean add(Object o) {
        if (this.list.contains(o)) {
            throw new IllegalArgumentException("The argument is already in the list: " + o);
        }
        boolean b = this.list.add(o);
        if (b) {
            this.addIntern(o);
        }
        return b;
    }

    public final void add(int index, Object o) {
        if (this.list.contains(o)) {
            throw new IllegalArgumentException("The argument is already in the list: " + o);
        }
        this.list.add(index, o);
        this.addIntern(o);
    }

    public final boolean addAll(Collection c) {
        int count = 0;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            ++count;
        }
        return count > 0;
    }

    public final boolean addAll(int index, Collection c) {
        int count = 0;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(index + count, it.next());
            ++count;
        }
        return count > 0;
    }

    public final void clear() {
        for (int i = 0; i < this.list.size(); ++i) {
            Object o = this.list.get(i);
            if (!this.tagged || this.added.contains(o)) continue;
            this.deleted.add(o);
        }
        if (this.tagged) {
            this.added.clear();
        }
        this.list.clear();
    }

    public final boolean contains(Object o) {
        return this.list.contains(o);
    }

    public final boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    public final Object get(int index) {
        return this.list.get(index);
    }

    public final int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final Iterator iterator() {
        return this.list.iterator();
    }

    public final int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public final ListIterator listIterator() {
        return this.list.listIterator();
    }

    public final ListIterator listIterator(int index) {
        return this.list.listIterator(index);
    }

    private void removeIntern(Object o) {
        if (this.tagged) {
            int idx = this.added.indexOf(o);
            if (idx == -1) {
                this.deleted.add(o);
            } else {
                this.added.remove(idx);
            }
        }
    }

    public final boolean remove(Object o) {
        boolean b = this.list.remove(o);
        if (b) {
            this.removeIntern(o);
        }
        return b;
    }

    public final Object remove(int index) {
        Object o = this.list.remove(index);
        if (o != null) {
            this.removeIntern(o);
        }
        return o;
    }

    public final boolean removeAll(Collection c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    public final boolean retainAll(Collection c) {
        boolean changed = false;
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Object o = this.list.get(i);
            if (c.contains(o)) continue;
            this.remove(i);
            changed = true;
        }
        return changed;
    }

    public final Object set(int index, Object o) {
        Object removed = this.list.set(index, o);
        this.addIntern(o);
        this.removeIntern(removed);
        return removed;
    }

    public final int size() {
        return this.list.size();
    }

    public final List subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public final Object[] toArray() {
        return this.list.toArray();
    }

    public final Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    public final String toString() {
        return this.list.toString();
    }

    public final boolean hasChangedSinceTagging() {
        return this.isChanged();
    }

    public final boolean isTagged() {
        return this.tagged;
    }

    public final void revertToTag() {
        this.revert();
    }

    public final void tag() {
        if (!this.tagged) {
            this.tagged = true;
        }
    }

    public final void untag() {
        if (this.tagged) {
            this.tagged = false;
            this.added.clear();
            this.deleted.clear();
        }
    }
}

