/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.fuin.utils4j.Cancelable;
import org.fuin.utils4j.IllegalNullArgumentException;
import org.fuin.utils4j.InvokeMethodFailedException;
import org.fuin.utils4j.LockingFailedException;

public final class Utils4J {
    private static final String USER_HOME_KEY = "user.home";
    private static final String TEMP_DIR_KEY = "java.io.tmpdir";
    private static final long EPOCH_DIFF = 11644473600000L;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Utils4J() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static String getPackagePath(Class clasz) {
        Utils4J.checkNotNull("clasz", clasz);
        return clasz.getPackage().getName().replace('.', '/');
    }

    public static URL getResource(Class clasz, String name) {
        Utils4J.checkNotNull("clasz", clasz);
        Utils4J.checkNotNull("name", name);
        String nameAndPath = "/" + Utils4J.getPackagePath(clasz) + "/" + name;
        return clasz.getResource(nameAndPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Class clasz, String filename) {
        Utils4J.checkNotNull("clasz", clasz);
        Utils4J.checkNotNull("filename", filename);
        String path = Utils4J.getPackagePath(clasz);
        String resPath = "/" + path + "/" + filename;
        try {
            Properties props = new Properties();
            InputStream inStream = clasz.getResourceAsStream(resPath);
            if (inStream == null) {
                throw new IllegalArgumentException("Resource '" + resPath + "' was not found!");
            }
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkValidFile(file);
        try {
            Properties props = new Properties();
            FileInputStream inStream = new FileInputStream(file);
            try {
                props.load(inStream);
            }
            finally {
                ((InputStream)inStream).close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void checkValidFile(File file) {
        Utils4J.checkNotNull("file", file);
        if (!file.exists()) {
            throw new IllegalArgumentException("The file '" + file + "' does not exist!");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The name '" + file + "' is not a file!");
        }
    }

    public static void checkValidDir(File dir) {
        Utils4J.checkNotNull("dir", dir);
        if (!dir.exists()) {
            throw new IllegalArgumentException("The directory '" + dir + "' does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The name '" + dir + "' is not a directory!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(File file, Properties props, String comment) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkNotNull("props", props);
        if (!file.getParentFile().exists()) {
            throw new IllegalArgumentException("The parent directory '" + file.getParentFile() + "' does not exist [file='" + file + "']!");
        }
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            try {
                props.store(outStream, comment);
            }
            finally {
                ((OutputStream)outStream).close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object createInstance(String className) {
        Utils4J.checkNotNull("className", className);
        try {
            Class<?> clasz = Class.forName(className);
            return clasz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown class!", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instanciating class!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing class!", e);
        }
    }

    public static void addToClasspath(String url) {
        Utils4J.checkNotNull("url", url);
        try {
            Utils4J.addToClasspath(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsURL(URL[] urls, URL url) {
        Utils4J.checkNotNull("urls", urls);
        Utils4J.checkNotNull("url", url);
        for (int i = 0; i < urls.length; ++i) {
            String urlStr;
            URL element = urls[i];
            String elementStr = element.toExternalForm();
            if (!elementStr.equals(urlStr = url.toExternalForm())) continue;
            return true;
        }
        return false;
    }

    public static String createHash(File file) {
        return Utils4J.createHashMD5(file);
    }

    public static String createHashMD5(File file) {
        return Utils4J.createHash(file, "MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createHash(File file, String algorithm) {
        String string;
        Utils4J.checkNotNull("file", file);
        Utils4J.checkNotNull("algorithm", algorithm);
        FileInputStream in = new FileInputStream(file);
        try {
            string = Utils4J.createHash(in, algorithm);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        in.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createHash(InputStream inputStream, String algorithm) {
        Utils4J.checkNotNull("inputStream", inputStream);
        Utils4J.checkNotNull("algorithm", algorithm);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            BufferedInputStream in = new BufferedInputStream(inputStream);
            try {
                byte[] buf = new byte[1024];
                int count = 0;
                while ((count = in.read(buf)) > -1) {
                    messageDigest.update(buf, 0, count);
                }
            }
            finally {
                in.close();
            }
            return Utils4J.encodeHex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Cipher createCipher(String algorithm, int mode, char[] password, byte[] salt, int count) throws GeneralSecurityException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey key = keyFactory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance(algorithm);
        PBEParameterSpec params = new PBEParameterSpec(salt, count);
        cipher.init(mode, (Key)key, params);
        return cipher;
    }

    public static byte[] encryptPasswordBased(String algorithm, byte[] data, char[] password, byte[] salt, int count) {
        Utils4J.checkNotNull("algorithm", algorithm);
        Utils4J.checkNotNull("data", data);
        Utils4J.checkNotNull("password", password);
        Utils4J.checkNotNull("salt", salt);
        try {
            Cipher cipher = Utils4J.createCipher(algorithm, 1, password, salt, count);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error encrypting the password!", ex);
        }
    }

    public static byte[] decryptPasswordBased(String algorithm, byte[] encryptedData, char[] password, byte[] salt, int count) {
        Utils4J.checkNotNull("algorithm", algorithm);
        Utils4J.checkNotNull("encryptedData", encryptedData);
        Utils4J.checkNotNull("password", password);
        Utils4J.checkNotNull("salt", salt);
        try {
            Cipher cipher = Utils4J.createCipher(algorithm, 2, password, salt, count);
            return cipher.doFinal(encryptedData);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error decrypting the password!", ex);
        }
    }

    public static URL createUrl(URL baseUrl, String path, String filename) {
        Utils4J.checkNotNull("baseUrl", baseUrl);
        Utils4J.checkNotNull("filename", filename);
        try {
            String baseUrlStr = baseUrl.toString();
            if (!baseUrlStr.endsWith("/")) {
                baseUrlStr = baseUrlStr + "/";
            }
            String pathStr = path == null || path.length() == 0 ? "" : (path.endsWith("/") ? path : path + "/");
            return new URL(baseUrlStr + pathStr + filename);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getRelativePath(File baseDir, File dir) {
        Utils4J.checkNotNull("baseDir", baseDir);
        Utils4J.checkNotNull("dir", dir);
        try {
            String base = baseDir.getCanonicalPath();
            String path = dir.getCanonicalPath();
            if (!path.startsWith(base)) {
                throw new IllegalArgumentException("The path '" + path + "' is not inside the base directory '" + base + "'!");
            }
            if (base.equals(path)) {
                return "";
            }
            return path.substring(base.length() + 1);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties loadProperties(URL baseUrl, String filename) {
        return Utils4J.loadProperties(Utils4J.createUrl(baseUrl, "", filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(URL fileURL) {
        Utils4J.checkNotNull("fileURL", fileURL);
        try {
            Properties props = new Properties();
            InputStream inStream = fileURL.openStream();
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties loadProperties(String baseUrl, String filename) {
        Utils4J.checkNotNull("baseUrl", baseUrl);
        Utils4J.checkNotNull("filename", filename);
        try {
            URL url = new URL(baseUrl);
            return Utils4J.loadProperties(url, filename);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("The argument 'srcUrl' is not a valid URL [" + baseUrl + "]!", ex);
        }
    }

    public static void addToClasspath(URL url) {
        Utils4J.checkNotNull("url", url);
        ClassLoader classLoader = Utils4J.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalArgumentException("Cannot add '" + url + "' to classloader because it's not an URL classloader");
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        if (!Utils4J.containsURL(urlClassLoader.getURLs(), url)) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)urlClassLoader, url);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalNullArgumentException(name);
        }
    }

    public static void checkNotEmpty(String name, String value) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("The argument '" + name + "' cannot be empty!!");
        }
    }

    private static String getMethodSignature(String returnType, String methodName, Class[] argTypes) {
        StringBuffer sb = new StringBuffer();
        if (returnType != null) {
            sb.append(returnType);
            sb.append(" ");
        }
        sb.append(methodName);
        sb.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(argTypes[i].getName());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static Object invoke(Object obj, String methodName, Class[] argTypes, Object[] args) throws InvokeMethodFailedException {
        Object[] argsIntern;
        Class[] argTypesIntern;
        Utils4J.checkNotNull("obj", obj);
        Utils4J.checkNotNull("methodName", methodName);
        if (argTypes == null) {
            argTypesIntern = new Class[]{};
            if (args != null) {
                throw new IllegalArgumentException("The argument 'argTypes' is null but 'args' containes values!");
            }
            argsIntern = new Object[]{};
        } else {
            argTypesIntern = argTypes;
            if (args == null) {
                throw new IllegalArgumentException("The argument 'argTypes' contains classes but 'args' is null!");
            }
            argsIntern = args;
        }
        Utils4J.checkSameLength(argTypesIntern, argsIntern);
        String returnType = null;
        try {
            Method method = obj.getClass().getMethod(methodName, argTypesIntern);
            returnType = method.getReturnType() == null ? "void" : method.getReturnType().getName();
            return method.invoke(obj, argsIntern);
        }
        catch (SecurityException ex) {
            throw new InvokeMethodFailedException("Security problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new InvokeMethodFailedException("Method '" + Utils4J.getMethodSignature(returnType, methodName, argTypesIntern) + "' not found! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InvokeMethodFailedException("Argument problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvokeMethodFailedException("Access problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw new InvokeMethodFailedException("Got an exception when calling '" + Utils4J.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
    }

    private static void checkSameLength(Class[] argTypes, Object[] args) {
        if (argTypes.length != args.length) {
            throw new IllegalArgumentException("The argument 'argTypes' contains " + argTypes.length + " classes " + "but 'args' only contains " + args.length + " arguments!");
        }
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        Utils4J.unzip(zipFile, destDir, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir, UnzipInputStreamWrapper wrapper, Cancelable cancelable) throws IOException {
        Utils4J.checkNotNull("zipFile", zipFile);
        Utils4J.checkValidFile(zipFile);
        Utils4J.checkNotNull("destDir", destDir);
        Utils4J.checkValidDir(destDir);
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> enu = zip.entries();
            while (enu.hasMoreElements() && (cancelable == null || !cancelable.isCanceled())) {
                ZipEntry entry = enu.nextElement();
                File file = new File(entry.getName());
                if (file.isAbsolute()) {
                    throw new IllegalArgumentException("Only relative path entries are allowed! [" + entry.getName() + "]");
                }
                if (entry.isDirectory()) {
                    File dir = new File(destDir, entry.getName());
                    Utils4J.createIfNecessary(dir);
                    continue;
                }
                File outFile = new File(destDir, entry.getName());
                Utils4J.createIfNecessary(outFile.getParentFile());
                BufferedInputStream in = wrapper == null ? new BufferedInputStream(zip.getInputStream(entry)) : new BufferedInputStream(wrapper.wrapInputStream(zip.getInputStream(entry), entry, outFile));
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
                    try {
                        int len;
                        byte[] buf = new byte[4096];
                        while ((len = ((InputStream)in).read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private static void createIfNecessary(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Error creating directory '" + dir + "'!");
        }
    }

    public static File getUserHomeDir() {
        String str = System.getProperty(USER_HOME_KEY);
        if (str == null) {
            throw new IllegalStateException("System property 'user.home' not found!");
        }
        String userHome = str.trim();
        if (userHome.length() == 0) {
            throw new IllegalStateException("System property 'user.home' is empty!");
        }
        File dir = new File(userHome);
        try {
            Utils4J.checkValidDir(dir);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("System property 'user.home' is not valid! [" + ex.getMessage() + "]");
        }
        return dir;
    }

    public static File getTempDir() {
        String str = System.getProperty(TEMP_DIR_KEY);
        if (str == null) {
            throw new IllegalStateException("System property 'java.io.tmpdir' not found!");
        }
        String tempDirStr = str.trim();
        if (tempDirStr.length() == 0) {
            throw new IllegalStateException("System property 'java.io.tmpdir' is empty!");
        }
        File dir = new File(tempDirStr);
        try {
            Utils4J.checkValidDir(dir);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("System property 'java.io.tmpdir' is not valid! [" + ex.getMessage() + "]");
        }
        return dir;
    }

    public static String replaceVars(String str, Map vars) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        Utils4J.checkNotNull("vars", vars);
        StringBuffer sb = new StringBuffer();
        int end = -1;
        int from = 0;
        int start = -1;
        while ((start = str.indexOf("${", from)) > -1) {
            sb.append(str.substring(end + 1, start));
            end = str.indexOf(125, start + 1);
            if (end == -1) {
                sb.append(str.substring(start));
                from = str.length();
                continue;
            }
            String key = str.substring(start + 2, end);
            String value = (String)vars.get(key);
            if (value == null) {
                sb.append("${");
                sb.append(key);
                sb.append("}");
            } else {
                sb.append(value);
            }
            from = end + 1;
        }
        sb.append(str.substring(from));
        return sb.toString();
    }

    public static long dateToFileTime(Date date) {
        Utils4J.checkNotNull("date", date);
        long msSince19700101 = date.getTime();
        long msSince16010101 = msSince19700101 + 11644473600000L;
        return msSince16010101 * 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createWindowsDesktopUrlLink(String baseUrl, String url, File workingDir, Integer showCommand, Integer iconIndex, File iconFile, Integer hotKey, String linkFilenameWithoutExtension, boolean overwrite, Date modified) throws IOException {
        Utils4J.checkNotNull("baseUrl", baseUrl);
        Utils4J.checkNotEmpty("baseUrl", baseUrl);
        Utils4J.checkNotNull("url", url);
        Utils4J.checkNotEmpty("url", url);
        Utils4J.checkNotNull("linkFilenameWithoutExtension", linkFilenameWithoutExtension);
        Utils4J.checkNotEmpty("linkFilenameWithoutExtension", linkFilenameWithoutExtension);
        File userHomeDir = new File(System.getProperty(USER_HOME_KEY));
        File desktopDir = new File(userHomeDir, "Desktop");
        File linkFile = new File(desktopDir, linkFilenameWithoutExtension + ".url");
        if (linkFile.exists() && !overwrite) {
            return;
        }
        String content = Utils4J.createWindowsDesktopUrlLinkContent(baseUrl, url, workingDir, showCommand, iconIndex, iconFile, hotKey, modified);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(linkFile), "Cp1252"));
        try {
            writer.write(content);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public static String createWindowsDesktopUrlLinkContent(String baseUrl, String url, File workingDir, Integer showCommand, Integer iconIndex, File iconFile, Integer hotKey, Date modified) {
        Utils4J.checkNotNull("baseUrl", baseUrl);
        Utils4J.checkNotEmpty("baseUrl", baseUrl);
        Utils4J.checkNotNull("url", url);
        Utils4J.checkNotEmpty("url", url);
        StringBuffer sb = new StringBuffer();
        sb.append("[DEFAULT]\r\n");
        sb.append("BASEURL=" + baseUrl + "\r\n");
        sb.append("\r\n");
        sb.append("[InternetShortcut]\r\n");
        sb.append("URL=" + url + "\r\n");
        if (workingDir != null) {
            sb.append("WorkingDirectory=" + workingDir + "\r\n");
        }
        if (showCommand != null) {
            sb.append("ShowCommand=" + showCommand);
        }
        if (iconFile != null && iconFile.exists()) {
            if (iconIndex == null) {
                sb.append("IconIndex=0\r\n");
            } else {
                sb.append("IconIndex=" + iconIndex);
            }
            sb.append("IconFile=" + iconFile + "\r\n");
        }
        sb.append("Modified=" + Utils4J.dateToFileTime(new Date()) + "\r\n");
        if (hotKey != null) {
            sb.append("HotKey=" + hotKey + "\r\n");
        }
        return sb.toString();
    }

    public static String concatPathAndFilename(String path, String filename, String separator) {
        Utils4J.checkNotNull("filename", filename);
        Utils4J.checkNotNull("separator", separator);
        Utils4J.checkNotEmpty("separator", separator);
        if (path == null) {
            return filename;
        }
        String trimmedPath = path.trim();
        if (trimmedPath.length() == 0) {
            return filename;
        }
        String trimmedFilename = filename.trim();
        if (trimmedPath.endsWith(separator)) {
            return trimmedPath + trimmedFilename;
        }
        return trimmedPath + separator + trimmedFilename;
    }

    public static String encodeHex(byte[] data) {
        Utils4J.checkNotNull("data", data);
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return String.copyValueOf(out);
    }

    public static byte[] decodeHex(String data) {
        Utils4J.checkNotNull("data", data);
        int len = data.length();
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Utils4J.toDigit(data.charAt(j), j) << 4;
            f |= Utils4J.toDigit(data.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public static FileLock lockRandomAccessFile(RandomAccessFile file, int tryLockMax, long tryWaitMillis) throws LockingFailedException {
        Utils4J.checkNotNull("file", file);
        FileChannel channel = file.getChannel();
        int tryCount = 0;
        while (tryCount < tryLockMax) {
            ++tryCount;
            try {
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    return lock;
                }
            }
            catch (IOException ex) {
                throw new LockingFailedException("Unexpected I/O-Exception!", ex);
            }
            catch (OverlappingFileLockException ex) {
                Utils4J.ignore();
            }
            try {
                Thread.sleep(tryWaitMillis);
            }
            catch (InterruptedException ex) {
                throw new LockingFailedException("Unexpected interrupt!", ex);
            }
        }
        throw new LockingFailedException("Number of max tries (" + tryLockMax + ") exceeded!");
    }

    private static void ignore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File srcFile, String destPath, ZipOutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
        try {
            int len;
            out.putNextEntry(new ZipEntry(Utils4J.concatPathAndFilename(destPath, srcFile.getName(), File.separator)));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static File[] listFiles(File srcDir, FileFilter filter) {
        File[] files = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        return files;
    }

    private static void zipDir(File srcDir, FileFilter filter, String destPath, ZipOutputStream out) throws IOException {
        File[] files = Utils4J.listFiles(srcDir, filter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Utils4J.zipDir(files[i], filter, Utils4J.concatPathAndFilename(destPath, files[i].getName(), File.separator), out);
                continue;
            }
            Utils4J.zipFile(files[i], destPath, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File srcDir, FileFilter filter, String destPath, File destFile) throws IOException {
        Utils4J.checkNotNull("srcDir", srcDir);
        Utils4J.checkValidDir(srcDir);
        Utils4J.checkNotNull("destFile", destFile);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destFile)));
        try {
            Utils4J.zipDir(srcDir, filter, destPath, out);
        }
        finally {
            out.close();
        }
    }

    public static void zipDir(File srcDir, String destPath, File destFile) throws IOException {
        Utils4J.zipDir(srcDir, null, destPath, destFile);
    }

    public static interface UnzipInputStreamWrapper {
        public InputStream wrapInputStream(InputStream var1, ZipEntry var2, File var3);
    }
}

