/*
 * Decompiled with CFR 0.152.
 */
package assets.pchan3;

import assets.pchan3.CustomTexturedQuad;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CustomModelRenderer {
    private PositionTextureVertex[] corners;
    private CustomTexturedQuad[] faces;
    private int textureOffsetX;
    private int textureOffsetY;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    private int texWidth;
    private int texHeight;

    public CustomModelRenderer(int i, int j, int w, int h) {
        this.textureOffsetX = i;
        this.textureOffsetY = j;
        this.texWidth = w;
        this.texHeight = h;
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k) {
        this.addBox(f, f1, f2, i, j, k, 0.0f);
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k, float f3) {
        this.corners = new PositionTextureVertex[8];
        this.faces = new CustomTexturedQuad[6];
        float f4 = f + (float)i;
        float f5 = f1 + (float)j;
        float f6 = f2 + (float)k;
        PositionTextureVertex PositionTextureVertex2 = new PositionTextureVertex(f -= f3, f1 -= f3, f2 -= f3, 0.0f, 0.0f);
        PositionTextureVertex PositionTextureVertex1 = new PositionTextureVertex(f4 += f3, f1, f2, 0.0f, 8.0f);
        PositionTextureVertex PositionTextureVertex22 = new PositionTextureVertex(f4, f5 += f3, f2, 8.0f, 8.0f);
        PositionTextureVertex PositionTextureVertex3 = new PositionTextureVertex(f, f5, f2, 8.0f, 0.0f);
        PositionTextureVertex PositionTextureVertex4 = new PositionTextureVertex(f, f1, f6 += f3, 0.0f, 0.0f);
        PositionTextureVertex PositionTextureVertex5 = new PositionTextureVertex(f4, f1, f6, 0.0f, 8.0f);
        PositionTextureVertex PositionTextureVertex6 = new PositionTextureVertex(f4, f5, f6, 8.0f, 8.0f);
        PositionTextureVertex PositionTextureVertex7 = new PositionTextureVertex(f, f5, f6, 8.0f, 0.0f);
        this.corners[0] = PositionTextureVertex2;
        this.corners[1] = PositionTextureVertex1;
        this.corners[2] = PositionTextureVertex22;
        this.corners[3] = PositionTextureVertex3;
        this.corners[4] = PositionTextureVertex4;
        this.corners[5] = PositionTextureVertex5;
        this.corners[6] = PositionTextureVertex6;
        this.corners[7] = PositionTextureVertex7;
        this.faces[0] = new CustomTexturedQuad(new PositionTextureVertex[]{PositionTextureVertex5, PositionTextureVertex1, PositionTextureVertex22, PositionTextureVertex6}, this.textureOffsetX + k + i, this.textureOffsetY + k, this.textureOffsetX + k + i + k, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
        this.faces[1] = new CustomTexturedQuad(new PositionTextureVertex[]{PositionTextureVertex2, PositionTextureVertex4, PositionTextureVertex7, PositionTextureVertex3}, this.textureOffsetX + 0, this.textureOffsetY + k, this.textureOffsetX + k, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
        this.faces[2] = new CustomTexturedQuad(new PositionTextureVertex[]{PositionTextureVertex5, PositionTextureVertex4, PositionTextureVertex2, PositionTextureVertex1}, this.textureOffsetX + k, this.textureOffsetY + 0, this.textureOffsetX + k + i, this.textureOffsetY + k, this.texWidth, this.texHeight);
        this.faces[3] = new CustomTexturedQuad(new PositionTextureVertex[]{PositionTextureVertex22, PositionTextureVertex3, PositionTextureVertex7, PositionTextureVertex6}, this.textureOffsetX + k + i, this.textureOffsetY + 0, this.textureOffsetX + k + i + i, this.textureOffsetY + k, this.texWidth, this.texHeight);
        this.faces[4] = new CustomTexturedQuad(new PositionTextureVertex[]{PositionTextureVertex1, PositionTextureVertex2, PositionTextureVertex3, PositionTextureVertex22}, this.textureOffsetX + k, this.textureOffsetY + k, this.textureOffsetX + k + i, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
        this.faces[5] = new CustomTexturedQuad(new PositionTextureVertex[]{PositionTextureVertex4, PositionTextureVertex5, PositionTextureVertex6, PositionTextureVertex7}, this.textureOffsetX + k + i + k, this.textureOffsetY + k, this.textureOffsetX + k + i + k + i, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
    }

    public void setPosition(float f, float f1, float f2) {
        this.offsetX = f;
        this.offsetY = f1;
        this.offsetZ = f2;
    }

    public void render(float f) {
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        } else if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
            GL11.glCallList((int)this.displayList);
            GL11.glTranslatef((float)(-this.offsetX * f), (float)(-this.offsetY * f), (float)(-this.offsetZ * f));
        } else {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void postRender(float f) {
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
        }
    }

    private void compileDisplayList(float f) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < this.faces.length; ++i) {
            this.faces[i].render(tessellator, f);
        }
        GL11.glEndList();
        this.compiled = true;
    }
}

