/*
 * Decompiled with CFR 0.152.
 */
package assets.pchan3;

import assets.pchan3.CommonProxy;
import assets.pchan3.ItemAnchor;
import assets.pchan3.PacketHandler;
import assets.pchan3.pirate.EntityPirate;
import assets.pchan3.steamboat.EntitySteamBoat;
import assets.pchan3.steamboat.ItemSteamBoat;
import assets.pchan3.steamship.EntityAirship;
import assets.pchan3.steamship.EntityAnchor;
import assets.pchan3.steamship.ItemAirship;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Logger;

@Mod(modid="pchan3", name="PChan3 mods", version="0.7")
public class PChan3Mods {
    @Mod.Instance(value="pchan3")
    public static PChan3Mods instance;
    @SidedProxy(clientSide="assets.pchan3.ClientProxy", serverSide="assets.pchan3.CommonProxy")
    public static CommonProxy proxy;
    private static boolean ENABLE_AIRSHIP;
    private static boolean ENABLE_STEAMBOAT;
    private static boolean ENABLE_PIRATE;
    public static boolean SHOW_BOILER;
    public static boolean usePlayerArrow;
    public static boolean usePlayerCoal;
    public static Item airShip;
    public static Item engine;
    public static Item balloon;
    public static Item steamBoat;
    public static Item anchor;
    public static int GUI_ID;
    private static String[] SPAWNABLE_BIOMES;
    private static int[] spawnChance;
    private static int[] packSize;
    public static double airUpSpeed;
    public static double airDownSpeed;
    public static double airSpeed;
    private Configuration config;
    private Logger logger;
    public static FMLEventChannel channel;

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        if (ENABLE_PIRATE) {
            SPAWNABLE_BIOMES = this.config.get("general", "Pirate_spawn_in_Biomes", SPAWNABLE_BIOMES).getStringList();
            spawnChance = this.config.get("general", "Pirate_Spawn_Chance_per_biome", spawnChance).getIntList();
            packSize = this.config.get("general", "Pirate_Max_Pack_Size_per_biome", packSize).getIntList();
            if (SPAWNABLE_BIOMES != null && SPAWNABLE_BIOMES.length != 0) {
                EntityRegistry.registerModEntity(EntityPirate.class, (String)"Pirate", (int)3, (Object)this, (int)80, (int)1, (boolean)true);
                BiomeGenBase[] biomes = this.getAvailableBiomes();
                for (int i = 0; i < biomes.length && i < spawnChance.length && i < packSize.length; ++i) {
                    List spawns = null;
                    if (biomes[i] != null) {
                        spawns = biomes[i].func_76747_a(EnumCreatureType.monster);
                    }
                    if (spawns == null) continue;
                    spawns.add(new BiomeGenBase.SpawnListEntry(EntityPirate.class, spawnChance[i], 1, packSize[i]));
                    this.logger.trace("Pirate added to biome " + biomes[i].field_76791_y);
                }
            }
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        SHOW_BOILER = this.config.get("general", "show_boiler", true).getBoolean(true);
        ENABLE_AIRSHIP = this.config.get("general", "Enable_Airship", true).getBoolean(true);
        ENABLE_STEAMBOAT = this.config.get("general", "Enable_Steamboat", true).getBoolean(true);
        ENABLE_PIRATE = this.config.get("general", "Enable_Pirate", true).getBoolean(true);
        airUpSpeed = this.config.get("cheats", "AirshipUpSpeed", 2.0).getDouble(2.0) / 100.0;
        airDownSpeed = this.config.get("cheats", "AirshipDownSpeed", 3.0).getDouble(3.0) / 100.0;
        airSpeed = this.config.get("cheats", "AirshipMainSpeed", 5.0).getDouble(5.0) / 100.0;
        usePlayerArrow = this.config.get("cheats", "Use arrows from player inventory", usePlayerArrow).getBoolean(true);
        usePlayerCoal = this.config.get("cheats", "Use coal from player inventory", usePlayerCoal).getBoolean(true);
        if (ENABLE_AIRSHIP) {
            engine = new Item().func_77655_b("pchan3:Engine").func_77637_a(CreativeTabs.field_78029_e).func_111206_d("pchan3:Engine");
            GameRegistry.registerItem((Item)engine, (String)"Engine");
            GameRegistry.addRecipe((ItemStack)new ItemStack(engine), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('X'), Blocks.field_150331_J});
            balloon = new Item().func_77655_b("pchan3:Balloon").func_77637_a(CreativeTabs.field_78029_e).func_111206_d("pchan3:Balloon");
            GameRegistry.registerItem((Item)balloon, (String)"Balloon");
            GameRegistry.addRecipe((ItemStack)new ItemStack(balloon), (Object[])new Object[]{"###", "###", "L L", Character.valueOf('#'), Items.field_151116_aA, Character.valueOf('L'), Items.field_151007_F});
            airShip = new ItemAirship().func_77655_b("pchan3:Airship").func_111206_d("pchan3:Airship");
            GameRegistry.registerItem((Item)airShip, (String)"Airship");
            EntityRegistry.registerModEntity(EntityAirship.class, (String)"Airship", (int)1, (Object)this, (int)40, (int)1, (boolean)true);
            GameRegistry.addRecipe((ItemStack)new ItemStack(airShip), (Object[])new Object[]{"XBX", "EFE", "XDX", Character.valueOf('X'), Items.field_151007_F, Character.valueOf('B'), balloon, Character.valueOf('E'), engine, Character.valueOf('D'), Items.field_151124_az, Character.valueOf('F'), Blocks.field_150460_al});
            anchor = new ItemAnchor().func_77655_b("pchan3:anchor").func_111206_d("lead");
            GameRegistry.registerItem((Item)anchor, (String)"Anchor");
            GameRegistry.addRecipe((ItemStack)new ItemStack(anchor), (Object[])new Object[]{" L ", " L ", "III", Character.valueOf('L'), Items.field_151007_F, Character.valueOf('I'), Items.field_151042_j});
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
            EntityRegistry.registerModEntity(EntityAnchor.class, (String)"Anchor", (int)0, (Object)this, (int)160, (int)80, (boolean)false);
            channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(PacketHandler.CHANNEL);
            channel.register((Object)new PacketHandler());
        }
        if (ENABLE_STEAMBOAT) {
            steamBoat = new ItemSteamBoat().func_77655_b("pchan3:Steamboat").func_111206_d("pchan3:Steamboat");
            GameRegistry.registerItem((Item)steamBoat, (String)"Steam Boat");
            EntityRegistry.registerModEntity(EntitySteamBoat.class, (String)"SteamBoat", (int)2, (Object)this, (int)40, (int)1, (boolean)false);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(steamBoat), new Object[]{"#X#", "###", Character.valueOf('#'), "plankWood", Character.valueOf('X'), Items.field_151042_j}));
        }
    }

    private BiomeGenBase[] getAvailableBiomes() {
        ArrayList<BiomeGenBase> result = new ArrayList<BiomeGenBase>();
        Iterator<BiomeGenBase> itr = Arrays.asList(BiomeGenBase.func_150565_n()).iterator();
        BiomeGenBase biome = null;
        block0: while (itr.hasNext()) {
            biome = itr.next();
            if (biome == null) continue;
            for (int id = 0; id < SPAWNABLE_BIOMES.length; ++id) {
                if (SPAWNABLE_BIOMES[id] == null || SPAWNABLE_BIOMES[id].equals("") || !biome.field_76791_y.equalsIgnoreCase(SPAWNABLE_BIOMES[id].trim())) continue;
                result.add(biome);
                continue block0;
            }
        }
        result.trimToSize();
        return result.size() != 0 && !result.isEmpty() ? result.toArray(new BiomeGenBase[result.size()]) : null;
    }

    static {
        ENABLE_AIRSHIP = true;
        ENABLE_STEAMBOAT = true;
        ENABLE_PIRATE = true;
        SHOW_BOILER = true;
        usePlayerArrow = true;
        usePlayerCoal = true;
        GUI_ID = 0;
        SPAWNABLE_BIOMES = new String[]{"Ocean", "Plains"};
        spawnChance = new int[]{2, 1};
        packSize = new int[]{1, 2};
    }
}

