/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.extendedWorkbench;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import naruto1310.extendedWorkbench.mod_ExtendedWorkbench;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EWTransformer
implements IClassTransformer {
    public byte[] transform(String name, String newName, byte[] bytes) {
        if (newName.contentEquals("net.minecraft.item.ItemInWorldManager")) {
            return this.transformItemInWorldManager(bytes);
        }
        if (newName.contentEquals("net.minecraft.client.renderer.EntityRenderer")) {
            return this.transformEntityRenderer(bytes);
        }
        if (newName.contentEquals("net.minecraft.block.Block")) {
            return this.transformBlock(bytes);
        }
        return bytes;
    }

    private byte[] transformEntityRenderer(byte[] bytes) {
        FMLLog.fine((String)"[ExtendedWorkbench] Starting to transform EntityRenderer.", (Object[])new Object[0]);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode m : classNode.methods) {
            AbstractInsnNode insn;
            int i;
            if (m.access != 1 || !m.desc.contentEquals("(F)V")) continue;
            for (i = 0; i < Math.min(m.instructions.size(), 10); ++i) {
                insn = m.instructions.get(i);
                if (insn instanceof LdcInsnNode) continue block0;
            }
            for (i = 0; i < m.instructions.size(); ++i) {
                insn = m.instructions.get(i);
                if (!(insn instanceof VarInsnNode) || insn.getOpcode() != 57 || ((VarInsnNode)insn).var != 2) continue;
                insn = m.instructions.get(i + 1);
                m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(24, 2));
                m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "naruto1310/extendedWorkbench/mod_ExtendedWorkbench", "extendReach", "(D)D"));
                m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(57, 2));
                break block0;
            }
        }
        FMLLog.fine((String)"[ExtendedWorkbench] Finished transforming EntityRenderer successfully.", (Object[])new Object[0]);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformItemInWorldManager(byte[] bytes) {
        FMLLog.fine((String)"[ExtendedWorkbench] Starting to transform ItemInWorldManager.", (Object[])new Object[0]);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode m : classNode.methods) {
            if (m.access != 1 || !m.desc.contentEquals("()D")) continue;
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode insn = m.instructions.get(i);
                if (insn.getOpcode() != 175) continue;
                m.instructions.insertBefore(insn, (AbstractInsnNode)new LdcInsnNode((Object)new Double(mod_ExtendedWorkbench.extendedValues.increaseToolReach)));
                m.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(107));
                continue block0;
            }
        }
        FMLLog.fine((String)"[ExtendedWorkbench] Finished transforming ItemInWorldManager successfully.", (Object[])new Object[0]);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformBlock(byte[] bytes) {
        FMLLog.fine((String)"[ExtendedWorkbench] Starting to transform Block.", (Object[])new Object[0]);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (m.access != 9 || !m.desc.contentEquals("()V")) continue;
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode insn = m.instructions.get(i);
                this.replaceBlock(insn, "Workbench");
                this.replaceBlock(insn, "Farmland");
            }
        }
        FMLLog.fine((String)"[ExtendedWorkbench] Finished transforming Block successfully.", (Object[])new Object[0]);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void replaceBlock(AbstractInsnNode insn, String block) {
        String source = "net/minecraft/block/Block" + block;
        String sourceObf = FMLDeobfuscatingRemapper.INSTANCE.unmap(source);
        String toReplace = "naruto1310/extendedWorkbench/BlockExtended" + block;
        if (insn instanceof TypeInsnNode && insn.getOpcode() == 187 && (((TypeInsnNode)insn).desc.contentEquals(source) || ((TypeInsnNode)insn).desc.contentEquals(sourceObf))) {
            ((TypeInsnNode)insn).desc = toReplace;
        }
        if (insn instanceof MethodInsnNode && insn.getOpcode() == 183 && (((MethodInsnNode)insn).owner.contentEquals(source) || ((MethodInsnNode)insn).owner.contentEquals(sourceObf))) {
            ((MethodInsnNode)insn).owner = toReplace;
        }
    }
}

