/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mdtechnology.automessage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Scanner;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.mdtechnology.automessage.SendMessage;

public class AutoMessage
extends JavaPlugin {
    private final HashMap<Player, Boolean> debugees = new HashMap();
    ArrayList<String> messages = new ArrayList();
    int defaultTime = 10000;
    String prefix = "";
    boolean random = false;
    Logger log = Logger.getLogger("Minecraft");
    String NL = System.getProperty("line.separator");
    String fname = "plugins" + File.separator + "automessages.properties";

    public String parseChat(String message) {
        String msg = message.replaceAll("\\$", "\u00a7");
        return msg;
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        try {
            this.loadData();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.random = true;
        if (true) {
            Collections.shuffle(this.messages);
        }
        SendMessage r = new SendMessage(this);
        new Thread(r).start();
        this.log.info("[" + pdfFile.getName() + "] version [" + pdfFile.getVersion() + "] loaded");
    }

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.log.info("[" + pdfFile.getName() + "] version [" + pdfFile.getVersion() + "] disabled");
    }

    public boolean isDebugging(Player player) {
        if (this.debugees.containsKey(player)) {
            return this.debugees.get(player);
        }
        return false;
    }

    public void setDebugging(Player player, boolean value) {
        this.debugees.put(player, value);
    }

    public void loadData() throws FileNotFoundException {
        Scanner scanner = new Scanner((InputStream)new FileInputStream(this.fname), "UTF-8");
        try {
            while (scanner.hasNextLine()) {
                String[] split = scanner.nextLine().split("=");
                if (split[0].equalsIgnoreCase("msg")) {
                    this.messages.add(split[1]);
                    continue;
                }
                if (split[0].equalsIgnoreCase("time")) {
                    this.defaultTime = Integer.parseInt(split[1]) * 1000;
                    continue;
                }
                if (split[0].equalsIgnoreCase("prefix")) {
                    this.prefix = String.valueOf(split[1]) + " ";
                    continue;
                }
                if (!split[0].equalsIgnoreCase("random")) continue;
                this.random = Boolean.parseBoolean(split[1]);
            }
        }
        finally {
            scanner.close();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName().toLowerCase();
        if (commandName.equals("reloadmsg")) {
            if (sender instanceof Player && sender.isOp()) {
                this.messages.clear();
                this.prefix = "";
                try {
                    this.loadData();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                this.random = true;
                if (true) {
                    Collections.shuffle(this.messages);
                }
                sender.sendMessage(String.valueOf(this.parseChat(this.prefix)) + "Messages Reloaded");
                return true;
            }
            if (!(sender instanceof Player)) {
                this.messages.clear();
                this.prefix = "";
                try {
                    this.loadData();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                this.random = true;
                if (true) {
                    Collections.shuffle(this.messages);
                }
                sender.sendMessage(String.valueOf(this.parseChat(this.prefix)) + "Messages Reloaded");
                return true;
            }
        }
        return true;
    }
}

