/*
 * Decompiled with CFR 0.152.
 */
package newdungeons;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraft.world.biome.BiomeGenTaiga;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import newdungeons.Dun1Node;
import newdungeons.DunChest;
import newdungeons.DunLootItem;
import newdungeons.DunLootPotion;
import newdungeons.ModBlockTorch;
import newdungeons.ModBlockTripWire;
import newdungeons.ModBlockTripWireSource;
import newdungeons.ModPressurePlate;

@Mod(modid="newdungeons", name="New Dungeons", version="1.7.2")
public final class NewDungeons
extends CommandBase
implements IWorldGenerator {
    public static Block pressurePlatetest;
    public static Block modDimTorch;
    public static Block modTripWire;
    public static Block modTripWireSource;
    static ArrayList<DunLootItem> loot;
    static ArrayList<DunLootItem> potLoot;
    static ArrayList<DunLootItem> disLoot;
    public static int maxSize;
    public static int minSize;
    public static int minRoomSize;
    public static int rareity;
    public static int minSquareBlocks;
    public static String additionalItems;
    public static String biomesID;
    public static int height;
    public static boolean ID_COMPATIBILITY;
    public static final boolean DEBUG = false;
    public static HashSet<Integer> biomes;
    public static String dimensionsID;
    public static HashSet<Integer> dimensions;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (dimensions.contains(world.field_73011_w.field_76574_g)) {
            NewDungeons.generateSurface(world, random, chunkX << 4, chunkZ << 4);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (minRoomSize < 2) {
            minRoomSize = 2;
        }
        if (minSize < minRoomSize) {
            minSize = minRoomSize;
        }
        if (maxSize < minSize + 1) {
            maxSize = minSize + 1;
        }
        if (rareity < 1) {
            rareity = 1;
        }
        ++minRoomSize;
        NewDungeons.addLoot();
        NewDungeons.generateBiomeList();
        NewDungeons.generateDimensionList();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)2);
    }

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        maxSize = config.get("Generation", "Max size", maxSize).getInt();
        minSize = config.get("Generation", "Min size", minSize).getInt();
        minRoomSize = config.get("Generation", "Room min size", minRoomSize).getInt();
        rareity = config.get("Generation", "Dungeon rarity", rareity, "higher=rarer").getInt();
        minSquareBlocks = config.get("Generation", "Min size in square blocks", minSquareBlocks).getInt();
        biomesID = config.get("Generation", "Biomes allowed", biomesID).getString();
        dimensionsID = config.get("Generation", "Dimensions allowed", dimensionsID).getString();
        additionalItems = config.get("Generation", "Add chest items", additionalItems, "Arguments: itemName rarity value maxStack minStack minDanger enchProb maxEnchant damageVal").getString();
        ID_COMPATIBILITY = !config.get("Generation", "Use custom blocks", !ID_COMPATIBILITY).getBoolean(false);
        config.save();
        if (!ID_COMPATIBILITY) {
            pressurePlatetest = new ModPressurePlate("stone", Material.field_151576_e).func_149711_c(0.5f).func_149672_a(Block.field_149780_i).func_149663_c("pressurePlatePlayer").func_149675_a(true);
            GameRegistry.registerBlock((Block)pressurePlatetest, (String)"PressurePlatePlayer");
            modDimTorch = new ModBlockTorch().func_149711_c(0.0f).func_149715_a(0.5f).func_149672_a(Block.field_149766_f).func_149663_c("dimTorch").func_149658_d("torch_on").func_149675_a(true);
            GameRegistry.registerBlock((Block)modDimTorch, (String)"DimTorch");
            modTripWire = new ModBlockTripWire().func_149663_c("tripWirePlayer").func_149658_d("trip_wire").func_149675_a(true);
            modTripWireSource = new ModBlockTripWireSource().func_149663_c("tripWireSourcePlayer").func_149658_d("trip_wire_source").func_149675_a(true);
            GameRegistry.registerBlock((Block)modTripWire, (String)"TripWirePlayer");
            GameRegistry.registerBlock((Block)modTripWireSource, (String)"WireHookPlayer");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150478_aa, 6), (Object[])new Object[]{Items.field_151044_h, modDimTorch});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150478_aa, 6), (Object[])new Object[]{Items.field_151145_ak, modDimTorch});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150478_aa, 8), (Object[])new Object[]{Items.field_151044_h, Items.field_151055_y, modDimTorch});
        }
    }

    public static void genDun1(World var0, Random var1, int var2, int var3, BiomeGenBase biome) {
        if (var1.nextInt(rareity) == 0) {
            int var11;
            int var9;
            int var7;
            int var6 = var1.nextInt(45) + 10;
            for (var7 = 0; var7 < 10 && ((var6 = var0.func_72825_h(var2, var3) - (var1.nextInt(30) + 20)) <= 10 || var6 >= 55); ++var7) {
            }
            var7 = 1;
            int var8 = 1;
            for (var9 = 0; var9 < 100 && (var7 * var8 < minSquareBlocks || var7 < 10 || var8 < 10); ++var9) {
                int var10 = var1.nextInt(maxSize - minSize) + minSize + 1;
                var11 = var1.nextInt(maxSize - minSize) + minSize + 1;
                var7 = var1.nextInt(var10 - minSize) + minSize;
                var8 = var1.nextInt(var11 - minSize) + minSize;
            }
            var11 = var7 * var8 / (var1.nextInt(50) + 50);
            if (var9 < 100) {
                NewDungeons.makeDun1(var0, var1, var7, var8, height, var2, var6, var3, var11, biome);
            }
        }
    }

    public static void generateSurface(World var1, Random var2, int var3, int var4) {
        BiomeGenBase biome = var1.func_72959_q().func_76935_a(var3, var4);
        if (var1.func_72912_H().func_76089_r() && biomes.contains(biome.field_76756_M)) {
            NewDungeons.genDun1(var1, var2, var3, var4, biome);
            NewDungeons.genDun5(var1, var2, var3, var4);
        }
    }

    public static void genVine(World var0, Random var1, int var2, int var3, int var4, BiomeGenBase var5) {
        int var6 = 15;
        if (var5 instanceof BiomeGenDesert) {
            var6 = 50;
        }
        if (var5 instanceof BiomeGenSwamp) {
            var6 = 2;
        }
        if (var5 instanceof BiomeGenOcean) {
            var6 = 5;
        }
        if (var5 instanceof BiomeGenForest) {
            var6 = 10;
        }
        if (var5 instanceof BiomeGenJungle) {
            var6 = 2;
        }
        if (var1.nextInt(var6) == 0 && var0.func_147437_c(var2 - 1, var3, var4)) {
            NewDungeons.setVines(var0, var2 - 1, var3, var4, 8);
        }
        if (var1.nextInt(var6) == 0 && var0.func_147437_c(var2 + 1, var3, var4)) {
            NewDungeons.setVines(var0, var2 + 1, var3, var4, 2);
        }
        if (var1.nextInt(var6) == 0 && var0.func_147437_c(var2, var3, var4 - 1)) {
            NewDungeons.setVines(var0, var2, var3, var4 - 1, 1);
        }
        if (var1.nextInt(var6) == 0 && var0.func_147437_c(var2, var3, var4 + 1)) {
            NewDungeons.setVines(var0, var2, var3, var4 + 1, 4);
        }
        if (var1.nextInt(var6) == 0 && var0.func_147437_c(var2, var3 - 1, var4)) {
            NewDungeons.setVines(var0, var2, var3 - 1, var4 + 1);
        }
    }

    public static boolean isEmpty(World var0, int var1, int var2, int var3) {
        Block var4 = var0.func_147439_a(var1, var2, var3);
        return var4 == Blocks.field_150350_a || var4 == Blocks.field_150395_bd || var4 == Blocks.field_150321_G || var4 == modDimTorch;
    }

    private static void addLoot() {
        if (!additionalItems.equals("")) {
            String var1 = null;
            int var2 = 1;
            int var3 = 1;
            int var4 = 1;
            int var5 = 30;
            int var6 = 0;
            int var7 = 1;
            double var8 = 1.0;
            double var10 = 1.0;
            for (String item : additionalItems.split("_")) {
                String[] var14 = item.split("-");
                try {
                    switch (var14.length) {
                        case 1: 
                        case 2: {
                            System.err.println("cannot add item" + var14[0] + "not enough arguments!");
                            break;
                        }
                        case 3: {
                            var1 = var14[0];
                            var8 = Double.parseDouble(var14[1]);
                            var10 = Double.parseDouble(var14[2]);
                            break;
                        }
                        case 4: {
                            var1 = var14[0];
                            var8 = Double.parseDouble(var14[1]);
                            var10 = Double.parseDouble(var14[2]);
                            var2 = Integer.parseInt(var14[3]);
                            break;
                        }
                        case 5: {
                            var1 = var14[0];
                            var8 = Double.parseDouble(var14[1]);
                            var10 = Double.parseDouble(var14[2]);
                            var2 = Integer.parseInt(var14[3]);
                            var3 = Integer.parseInt(var14[4]);
                            break;
                        }
                        case 6: {
                            var1 = var14[0];
                            var8 = Double.parseDouble(var14[1]);
                            var10 = Double.parseDouble(var14[2]);
                            var2 = Integer.parseInt(var14[3]);
                            var3 = Integer.parseInt(var14[4]);
                            var4 = Integer.parseInt(var14[5]);
                            break;
                        }
                        case 7: {
                            var1 = var14[0];
                            var8 = Double.parseDouble(var14[1]);
                            var10 = Double.parseDouble(var14[2]);
                            var2 = Integer.parseInt(var14[3]);
                            var3 = Integer.parseInt(var14[4]);
                            var4 = Integer.parseInt(var14[5]);
                            var6 = Integer.parseInt(var14[6]);
                            break;
                        }
                        case 8: {
                            var1 = var14[0];
                            var8 = Double.parseDouble(var14[1]);
                            var10 = Double.parseDouble(var14[2]);
                            var2 = Integer.parseInt(var14[3]);
                            var3 = Integer.parseInt(var14[4]);
                            var4 = Integer.parseInt(var14[5]);
                            var6 = Integer.parseInt(var14[6]);
                            var5 = Integer.parseInt(var14[7]);
                            break;
                        }
                        default: {
                            var1 = var14[0];
                            var8 = Double.parseDouble(var14[1]);
                            var10 = Double.parseDouble(var14[2]);
                            var2 = Integer.parseInt(var14[3]);
                            var3 = Integer.parseInt(var14[4]);
                            var4 = Integer.parseInt(var14[5]);
                            var6 = Integer.parseInt(var14[6]);
                            var5 = Integer.parseInt(var14[7]);
                            var7 = Integer.parseInt(var14[8]);
                        }
                    }
                    if (var1 == null) continue;
                    Block var15 = (Block)GameData.blockRegistry.get(var1);
                    if (var15 != null) {
                        loot.add(new DunLootItem(var15, var2, var3, var8, var10, var4, var5, var6, var7, var7));
                        continue;
                    }
                    Item var20 = (Item)GameData.itemRegistry.get(var1);
                    if (var20 == null) continue;
                    loot.add(new DunLootItem(var20, var2, var3, var8, var10, var4, var5, var6, var7, var7));
                }
                catch (Exception var18) {
                    System.err.println("New Dungeons error: " + var18.toString());
                }
            }
        }
        loot.add(new DunLootItem(Items.field_151045_i, 6, 1, 20.0, 15.0, 300));
        loot.add(new DunLootItem(Blocks.field_150478_aa, 15, 1, 3.0, 3.0, 30));
        loot.add(new DunLootItem(Blocks.field_150346_d, 64, 15, 13.0, 1.0, -1));
        loot.add(new DunLootItem(Items.field_151034_e, 3, 1, 5.0, 5.0, 50));
        loot.add(new DunLootItem(Items.field_151103_aS, 5, 1, 7.0, 2.0, 0));
        loot.add(new DunLootItem(Items.field_151032_g, 16, 1, 10.0, 7.0, 50));
        loot.add(new DunLootItem((Item)Items.field_151031_f, 1, 1, 20.0, 15.0, 100, 20, 20));
        loot.add(new DunLootItem(Items.field_151159_an, 2, 1, 25.0, 3.0, 30));
        loot.add(new DunLootItem(Blocks.field_150344_f, 5, 1, 4.0, 10.0, 40, 0, 0, 0, 3));
        loot.add(new DunLootItem(Blocks.field_150364_r, 5, 1, 16.0, 15.0, 60, 0, 0, 0, 3));
        loot.add(new DunLootItem(Items.field_151116_aA, 5, 1, 10.0, 8.0, 20));
        loot.add(new DunLootItem((Item)Items.field_151026_S, 1, 1, 20.0, 15.0, 50));
        loot.add(new DunLootItem((Item)Items.field_151024_Q, 1, 1, 20.0, 15.0, 50));
        loot.add(new DunLootItem((Item)Items.field_151021_T, 1, 1, 20.0, 15.0, 50));
        loot.add(new DunLootItem((Item)Items.field_151027_R, 1, 1, 20.0, 15.0, 50));
        loot.add(new DunLootItem((Item)Items.field_151165_aa, 1, 1, 35.0, 30.0, 250, 15, 15));
        loot.add(new DunLootItem((Item)Items.field_151028_Y, 1, 1, 35.0, 30.0, 250, 15, 15));
        loot.add(new DunLootItem((Item)Items.field_151167_ab, 1, 1, 35.0, 30.0, 250, 15, 15));
        loot.add(new DunLootItem((Item)Items.field_151030_Z, 1, 1, 35.0, 30.0, 250, 15, 15));
        loot.add(new DunLootItem(Items.field_151025_P, 5, 1, 7.0, 5.0, 50));
        loot.add(new DunLootItem(Items.field_151133_ar, 1, 1, 10.0, 2.0, 20));
        loot.add(new DunLootItem(Items.field_151042_j, 10, 1, 20.0, 7.0, 150));
        loot.add(new DunLootItem(Blocks.field_150366_p, 10, 1, 10.0, 5.0, 100));
        loot.add(new DunLootItem(Items.field_151105_aU, 1, 1, 40.0, 20.0, 60));
        loot.add(new DunLootItem(Items.field_151082_bd, 1, 1, 5.0, 4.0, 5));
        loot.add(new DunLootItem(Items.field_151083_be, 1, 1, 6.0, 8.0, 5));
        loot.add(new DunLootItem(Blocks.field_150440_ba, 3, 1, 17.0, 10.0, 30));
        loot.add(new DunLootItem(Items.field_151081_bc, 5, 1, 8.0, 7.0, 30));
        loot.add(new DunLootItem(Blocks.field_150423_aK, 3, 1, 13.0, 10.0, 30));
        loot.add(new DunLootItem(Items.field_151080_bb, 5, 1, 8.0, 7.0, 30));
        loot.add(new DunLootItem(Blocks.field_150347_e, 64, 15, 14.0, 2.0, 0));
        loot.add(new DunLootItem((Item)Items.field_151149_ai, 1, 1, 80.0, 25.0, 350, 17, 6));
        loot.add(new DunLootItem((Item)Items.field_151169_ag, 1, 1, 80.0, 25.0, 350, 17, 6));
        loot.add(new DunLootItem((Item)Items.field_151151_aj, 1, 1, 80.0, 25.0, 350, 17, 6));
        loot.add(new DunLootItem((Item)Items.field_151171_ah, 1, 1, 80.0, 25.0, 350, 17, 6));
        loot.add(new DunLootItem(Items.field_151039_o, 1, 1, 20.0, 2.0, 70));
        loot.add(new DunLootItem(Items.field_151050_s, 1, 1, 20.0, 5.0, 70));
        loot.add(new DunLootItem(Items.field_151035_b, 1, 1, 50.0, 15.0, 100, 30, 20));
        loot.add(new DunLootItem(Items.field_151046_w, 1, 1, 70.0, 60.0, 400, 50, 25));
        loot.add(new DunLootItem(Items.field_151041_m, 1, 1, 20.0, 3.0, 70));
        loot.add(new DunLootItem(Items.field_151052_q, 1, 1, 20.0, 6.0, 70));
        loot.add(new DunLootItem(Items.field_151040_l, 1, 1, 50.0, 17.0, 100, 30, 20));
        loot.add(new DunLootItem(Items.field_151048_u, 1, 1, 70.0, 61.0, 400, 50, 25));
        loot.add(new DunLootItem(Items.field_151153_ao, 1, 1, 1000.0, 100.0, 200));
        loot.add(new DunLootItem(Items.field_151079_bi, 6, 1, 46.0, 80.0, 200));
        loot.add(new DunLootItem(Items.field_151061_bv, 3, 1, 57.0, 130.0, 300));
        loot.add(new DunLootItem(Items.field_151137_ax, 64, 32, 60.0, 3.0, 15));
        loot.add(new DunLootItem(Blocks.field_150335_W, 3, 1, 30.0, 36.0, 300));
        loot.add(new DunLootItem(Items.field_151141_av, 1, 1, 10.0, 60.0, 30));
        loot.add(new DunLootItem(Items.field_151078_bh, 4, 1, 2.0, 10.0, 0));
        loot.add(new DunLootItem(Items.field_151044_h, 7, 1, 15.0, 18.0, 20));
        loot.add(new DunLootItem(Items.field_151055_y, 7, 1, 3.0, 2.0, 0));
        loot.add(new DunLootItem(Items.field_151033_d, 1, 1, 20.0, 100.0, 200));
        loot.add(new DunLootItem(Items.field_151145_ak, 7, 1, 15.0, 5.0, 13));
        loot.add(new DunLootItem(Blocks.field_150343_Z, 3, 1, 34.0, 40.0, 200));
        loot.add(new DunLootItem(Items.field_151166_bC, 3, 1, 40.0, 50.0, 200));
        loot.add(new DunLootItem(Items.field_151096_cd, 1, 1, 1000.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151093_ce, 1, 1, 1002.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151094_cf, 1, 1, 1004.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151091_cg, 1, 1, 1006.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151092_ch, 1, 1, 1008.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151089_ci, 1, 1, 1010.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151090_cj, 1, 1, 1012.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151087_ck, 1, 1, 1014.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151088_cl, 1, 1, 1016.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151085_cm, 1, 1, 1018.0, 50.0, 0));
        loot.add(new DunLootItem(Items.field_151086_cn, 1, 1, 1020.0, 50.0, 0));
        loot.add(new DunLootItem((Item)Items.field_151068_bn, 1, 1, 27.0, 36.0, 100, 0, 99999999));
        potLoot.add(new DunLootItem(Items.field_151114_aO, 4, 1, 1.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151137_ax, 4, 1, 1.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151075_bm, 4, 1, 1.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151102_aT, 4, 1, 1.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151016_H, 4, 1, 1.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151070_bp, 4, 1, 1.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151071_bq, 4, 1, 5.0, 4.0, 0));
        potLoot.add(new DunLootItem(Items.field_151074_bl, 4, 1, 1.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151127_ba, 4, 1, 1.0, 1.0, 0, 0, 0, 0, 1));
        potLoot.add(new DunLootItem(Items.field_151073_bk, 4, 1, 7.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151064_bs, 4, 1, 3.0, 1.0, 0));
        potLoot.add(new DunLootItem(Items.field_151069_bo, 10, 1, 1.0, 1.0, 0));
        disLoot.add(new DunLootItem(Items.field_151032_g, 5, 1, 1.0, 1.0, 10));
        disLoot.add(new DunLootItem(Items.field_151126_ay, 5, 1, 10.0, 15.0, 10));
        disLoot.add(new DunLootPotion((Item)Items.field_151068_bn, 6, 2, 1.0, 0.0, 0, 16420));
        disLoot.add(new DunLootPotion((Item)Items.field_151068_bn, 4, 2, 1.0, 0.0, 0, 16396));
        disLoot.add(new DunLootPotion((Item)Items.field_151068_bn, 5, 2, 1.0, 0.0, 0, 16428));
        disLoot.add(new DunLootPotion((Item)Items.field_151068_bn, 3, 2, 1.0, 0.0, 0, 16456));
        disLoot.add(new DunLootPotion((Item)Items.field_151068_bn, 3, 2, 1.0, 0.0, 0, 16458));
    }

    private static void genDun5(World var1, Random var2, int var3, int var4) {
        for (int var5 = 0; var5 < 10; ++var5) {
            int var8;
            if (var2.nextInt(2) != 0) continue;
            int var6 = var2.nextInt(16) + 1 + var3;
            int var7 = var2.nextInt(16) + 1 + var4;
            do {
                var8 = var2.nextInt(126) + 2;
                try {
                    var1.func_72825_h(var6, var7);
                }
                catch (Exception var12) {
                    return;
                }
            } while (var1.func_72825_h(var6, var7) == var8 || var1.func_147439_a(var6, var8 - 1, var7) == Blocks.field_150355_j);
            if (!var1.func_147437_c(var6, var8, var7) || var1.func_147437_c(var6, var8 - 1, var7)) continue;
            var1.func_147449_b(var6, var8, var7, (Block)Blocks.field_150486_ae);
            ArrayList<DunChest> var9 = new ArrayList<DunChest>();
            var9.add(new DunChest(var6, var8, var7));
            int var10 = 60 - var8;
            int var11 = var10 * 15;
            NewDungeons.putLoot(var1, var2, var9, var10 *= 13, var11);
        }
    }

    private static void generateBiomeList() {
        for (String txt : biomesID.split(",")) {
            if (txt.equalsIgnoreCase("ALL")) {
                for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
                    biomes.add(i);
                }
                continue;
            }
            if (txt.startsWith("-")) {
                txt = txt.substring(1).trim();
                try {
                    biomes.remove(Integer.parseInt(txt));
                    continue;
                }
                catch (NumberFormatException e) {
                    for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.valueOf((String)txt.toUpperCase()))) {
                        biomes.remove(biome.field_76756_M);
                    }
                    continue;
                }
            }
            try {
                biomes.add(Integer.parseInt(txt));
            }
            catch (NumberFormatException e) {
                for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.valueOf((String)txt.toUpperCase()))) {
                    biomes.add(biome.field_76756_M);
                }
            }
        }
    }

    private static void generateDimensionList() {
        for (String txt : dimensionsID.split(",")) {
            try {
                dimensions.add(Integer.parseInt(txt.trim()));
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
        }
    }

    private static void genStone(World var0, Random var1, BiomeGenBase biome, int var2, int var3, int var4) {
        NewDungeons.genStone(var0, var1, biome, var2, var3, var4, false);
    }

    private static void genStone(World var0, Random var1, BiomeGenBase biome, int var2, int var3, int var4, boolean var5) {
        Block var8 = Blocks.field_150417_aV;
        int var9 = 0;
        boolean var10 = false;
        if (var1.nextInt(10) == 0 && var5) {
            var0.func_147468_f(var2, var3, var4);
            NewDungeons.genStone(var0, var1, biome, var2, var3 + 1, var4);
        } else {
            while (!var10) {
                int var6 = var1.nextInt(7);
                int var7 = var1.nextInt(100);
                if (var6 == 0 && var7 < 50) {
                    var8 = Blocks.field_150417_aV;
                    var10 = true;
                }
                if (var6 == 1 && var7 < 25) {
                    var8 = Blocks.field_150417_aV;
                    var9 = 1;
                    var10 = true;
                }
                if (var6 == 2 && var7 < 25) {
                    var8 = Blocks.field_150417_aV;
                    var9 = 2;
                    var10 = true;
                }
                if (var6 == 3 && var7 < 10) {
                    var8 = Blocks.field_150341_Y;
                    var10 = true;
                }
                if (var6 == 4 && var7 < 6) {
                    var8 = Blocks.field_150347_e;
                    var10 = true;
                }
                if (var6 == 5 && var7 < 3) {
                    var8 = Blocks.field_150348_b;
                    var10 = true;
                }
                if (var6 != 6 || var7 >= 7) continue;
                var8 = Blocks.field_150417_aV;
                var9 = 3;
                var10 = true;
            }
            var0.func_147465_d(var2, var3, var4, var8, var9, 2);
        }
        NewDungeons.genVine(var0, var1, var2, var3, var4, biome);
    }

    private static boolean makeDun1(World var0, Random var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, BiomeGenBase biome) {
        boolean var50;
        boolean var46;
        int var58;
        int var49;
        int var48;
        boolean var51;
        int var28;
        int var27;
        int var41;
        int var40;
        int var26;
        int var25;
        int var24;
        int var23;
        int var22;
        int var21;
        boolean var20;
        int var18;
        int var17;
        int var16;
        int var15;
        int var14;
        int var10 = 0;
        int var11 = 0;
        int var12 = 0;
        int var13 = 0;
        for (var14 = 0; var14 < var2 + 1; ++var14) {
            for (var15 = 0; var15 < var3 + 1; ++var15) {
                for (var16 = 1; var16 < var4 - 1; ++var16) {
                    if (var0.func_147439_a(var5 + var14, var6 + var16, var7 + var15) == Blocks.field_150486_ae) continue;
                    var0.func_147468_f(var5 + var14, var6 + var16, var7 + var15);
                }
            }
        }
        for (var14 = 0; var14 < var2 + 1; ++var14) {
            for (var15 = 0; var15 < var3 + 1; ++var15) {
                NewDungeons.genStone(var0, var1, biome, var5 + var14, var6, var7 + var15);
                NewDungeons.genStone(var0, var1, biome, var5 + var14, var6 + var4 - 1, var7 + var15, true);
                if (var14 != 0 && var14 != var2 && var15 != 0 && var15 != var3) continue;
                for (var16 = 1; var16 < var4 - 1; ++var16) {
                    NewDungeons.genStone(var0, var1, biome, var5 + var14, var6 + var16, var7 + var15);
                }
            }
        }
        ArrayList<Dun1Node> var37 = new ArrayList<Dun1Node>();
        for (var15 = 0; var15 < var8 + var1.nextInt(var8 * 5) + var1.nextInt(var8) * -1; ++var15) {
            var16 = var1.nextInt(var2 - 2) + 1;
            var17 = var1.nextInt(var3 - 2) + 1;
            var18 = var1.nextInt(10 - minRoomSize + 1) + minRoomSize;
            var18 = var1.nextInt(var18 - minRoomSize + 1) + minRoomSize;
            boolean var19 = true;
            var20 = true;
            for (var21 = 0; var21 < var18; ++var21) {
                if (var0.func_147439_a(var5 + var16 + var21, var6 + 1, var7 + var17).func_149688_o() != Material.field_151576_e && var0.func_147439_a(var5 + var16 - var21, var6 + 1, var7 + var17).func_149688_o() != Material.field_151576_e) {
                    continue;
                }
                var20 = false;
                break;
            }
            for (var21 = 0; var21 < var18; ++var21) {
                if (var0.func_147439_a(var5 + var16, var6 + 1, var7 + var17 + var21).func_149688_o() != Material.field_151576_e && var0.func_147439_a(var5 + var16, var6 + 1, var7 + var17 - var21).func_149688_o() != Material.field_151576_e) continue;
                var19 = false;
                break;
            }
            if (var19 || var20) {
                for (var21 = 1; var21 < var4 - 1; ++var21) {
                    NewDungeons.genStone(var0, var1, biome, var5 + var16, var6 + var21, var7 + var17);
                }
            }
            var21 = 1;
            var22 = 1;
            var23 = 1;
            var24 = 1;
            if (var19) {
                for (var25 = 1; var25 < var2 && var0.func_147439_a(var5 + var16 + var25, var6 + 1, var7 + var17).func_149688_o() != Material.field_151576_e; ++var25) {
                    ++var21;
                    for (var26 = 1; var26 < var4 - 1; ++var26) {
                        NewDungeons.genStone(var0, var1, biome, var5 + var16 + var25, var6 + var26, var7 + var17);
                    }
                }
                for (var25 = 1; var25 < var2 && var0.func_147439_a(var5 + var16 - var25, var6 + 1, var7 + var17).func_149688_o() != Material.field_151576_e; ++var25) {
                    ++var22;
                    for (var26 = 1; var26 < var4 - 1; ++var26) {
                        NewDungeons.genStone(var0, var1, biome, var5 + var16 - var25, var6 + var26, var7 + var17);
                    }
                }
            }
            if (var20) {
                for (var25 = 1; var25 < var3 && var0.func_147439_a(var5 + var16, var6 + 1, var7 + var17 + var25).func_149688_o() != Material.field_151576_e; ++var25) {
                    ++var23;
                    for (var26 = 1; var26 < var4 - 1; ++var26) {
                        NewDungeons.genStone(var0, var1, biome, var5 + var16, var6 + var26, var7 + var17 + var25);
                    }
                }
                for (var25 = 1; var25 < var3 && var0.func_147439_a(var5 + var16, var6 + 1, var7 + var17 - var25).func_149688_o() != Material.field_151576_e; ++var25) {
                    ++var24;
                    for (var26 = 1; var26 < var4 - 1; ++var26) {
                        NewDungeons.genStone(var0, var1, biome, var5 + var16, var6 + var26, var7 + var17 - var25);
                    }
                }
            }
            if (var21 <= 1 && var22 <= 1 && var23 <= 1 && var24 <= 1) continue;
            var37.add(new Dun1Node(var21, var22, var23, var24, var5 + var16, var6 + 1, var7 + var17));
        }
        var15 = var1.nextInt(var1.nextInt(2) + 1) + 1;
        for (var16 = 0; var16 < var37.size() - 1; ++var16) {
            int var33;
            boolean var32;
            boolean var31;
            boolean var30;
            boolean var29;
            var17 = ((Dun1Node)var37.get((int)var16)).wp;
            var18 = ((Dun1Node)var37.get((int)var16)).wn;
            var40 = ((Dun1Node)var37.get((int)var16)).lp;
            var41 = ((Dun1Node)var37.get((int)var16)).ln;
            var21 = ((Dun1Node)var37.get((int)var16)).x;
            var22 = ((Dun1Node)var37.get((int)var16)).z;
            var23 = ((Dun1Node)var37.get((int)var16)).y;
            for (var24 = var1.nextInt(var15) + 1; var24 > 0; --var24) {
                var25 = var1.nextInt(var17);
                var1.nextInt(var18);
                var1.nextInt(var40);
                var1.nextInt(var41);
                if (var17 <= 2) continue;
                var29 = var0.func_147439_a(var21 + var25 + 1, var23, var22).func_149688_o() == Material.field_151576_e;
                var30 = var0.func_147439_a(var21 + var25 - 1, var23, var22).func_149688_o() == Material.field_151576_e;
                var31 = var0.func_147439_a(var21 + var25, var23, var22 + 1).func_149688_o() == Material.field_151576_e;
                var32 = var0.func_147439_a(var21 + var25, var23, var22 - 1).func_149688_o() == Material.field_151576_e;
                var33 = 0;
                if (var29) {
                    ++var33;
                }
                if (var30) {
                    ++var33;
                }
                if (var31) {
                    ++var33;
                }
                if (var32) {
                    ++var33;
                }
                if (!((var29 && var30) ^ (var31 && var32)) || var33 != 2) continue;
                var0.func_147468_f(var21 + var25, var23, var22);
                var0.func_147468_f(var21 + var25, var23 + 1, var22);
            }
            for (var24 = var1.nextInt(var15) + 1; var24 > 0; --var24) {
                var1.nextInt(var17);
                var26 = var1.nextInt(var18);
                var1.nextInt(var40);
                var1.nextInt(var41);
                if (var18 <= 2) continue;
                var29 = var0.func_147439_a(var21 - var26 + 1, var23, var22).func_149688_o() == Material.field_151576_e;
                var30 = var0.func_147439_a(var21 - var26 - 1, var23, var22).func_149688_o() == Material.field_151576_e;
                var31 = var0.func_147439_a(var21 - var26, var23, var22 + 1).func_149688_o() == Material.field_151576_e;
                var32 = var0.func_147439_a(var21 - var26, var23, var22 - 1).func_149688_o() == Material.field_151576_e;
                var33 = 0;
                if (var29) {
                    ++var33;
                }
                if (var30) {
                    ++var33;
                }
                if (var31) {
                    ++var33;
                }
                if (var32) {
                    ++var33;
                }
                if (!((var29 && var30) ^ (var31 && var32)) || var33 != 2) continue;
                var0.func_147468_f(var21 - var26, var23, var22);
                var0.func_147468_f(var21 - var26, var23 + 1, var22);
            }
            for (var24 = var1.nextInt(var15) + 1; var24 > 0; --var24) {
                var1.nextInt(var17);
                var1.nextInt(var18);
                var27 = var1.nextInt(var40);
                var1.nextInt(var41);
                if (var40 <= 2) continue;
                var29 = var0.func_147439_a(var21 + 1, var23, var22 + var27).func_149688_o() == Material.field_151576_e;
                var30 = var0.func_147439_a(var21 - 1, var23, var22 + var27).func_149688_o() == Material.field_151576_e;
                var31 = var0.func_147439_a(var21, var23, var22 + 1 + var27).func_149688_o() == Material.field_151576_e;
                var32 = var0.func_147439_a(var21, var23, var22 - 1 + var27).func_149688_o() == Material.field_151576_e;
                var33 = 0;
                if (var29) {
                    ++var33;
                }
                if (var30) {
                    ++var33;
                }
                if (var31) {
                    ++var33;
                }
                if (var32) {
                    ++var33;
                }
                if (!((var29 && var30) ^ (var31 && var32)) || var33 != 2) continue;
                var0.func_147468_f(var21, var23, var22 + var27);
                var0.func_147468_f(var21, var23 + 1, var22 + var27);
            }
            for (var24 = var1.nextInt(var15) + 1; var24 > 0; --var24) {
                var1.nextInt(var17);
                var1.nextInt(var18);
                var1.nextInt(var40);
                var28 = var1.nextInt(var41);
                if (var41 <= 2) continue;
                var29 = var0.func_147439_a(var21 + 1, var23, var22 - var28).func_149688_o() == Material.field_151576_e;
                var30 = var0.func_147439_a(var21 - 1, var23, var22 - var28).func_149688_o() == Material.field_151576_e;
                var31 = var0.func_147439_a(var21, var23, var22 + 1 - var28).func_149688_o() == Material.field_151576_e;
                var32 = var0.func_147439_a(var21, var23, var22 - 1 - var28).func_149688_o() == Material.field_151576_e;
                var33 = 0;
                if (var29) {
                    ++var33;
                }
                if (var30) {
                    ++var33;
                }
                if (var31) {
                    ++var33;
                }
                if (var32) {
                    ++var33;
                }
                if (!((var29 && var30) ^ (var31 && var32)) || var33 != 2) continue;
                var0.func_147468_f(var21, var23, var22 - var28);
                var0.func_147468_f(var21, var23 + 1, var22 - var28);
            }
        }
        for (var17 = 0; var17 < 100; ++var17) {
            var18 = var1.nextInt(var2);
            var40 = var1.nextInt(var3);
            var20 = false;
            for (var21 = -1; var21 < 2; ++var21) {
                for (var22 = -1; var22 < 2; ++var22) {
                    if (var0.func_147437_c(var5 + var18 + var21, var6 + 1, var7 + var40 + var22)) continue;
                    var20 = true;
                    break;
                }
                if (var20) break;
            }
            if (var20) continue;
            var12 = var21 = var0.func_72825_h(var5 + var18, var7 + var40);
            if (var21 < 60) break;
            int var43 = 5;
            var23 = -1;
            var24 = -1;
            var25 = 0;
            var51 = true;
            var27 = 1;
            for (var28 = var6 + 4; var28 < var21; ++var28) {
                for (var48 = -1; var48 < 2; ++var48) {
                    for (var49 = -1; var49 < 2; ++var49) {
                        var0.func_147468_f(var5 + var18 + var48, var28, var7 + var40 + var49);
                    }
                }
            }
            boolean var52 = false;
            if (var1.nextInt(3) == 0) {
                var52 = true;
            }
            if (!var52 && var1.nextInt(2) == 0) {
                var0.func_147449_b(var5 + var18, var6, var7 + var40, Blocks.field_150355_j);
                if (var1.nextInt(5) != 0) {
                    var0.func_147468_f(var5 + var18, var6 - 1, var7 + var40);
                }
            }
            for (var48 = 0; var48 < var21 * 4; ++var48) {
                var0.func_147465_d(var5 + var18 + var23, var6 + 1 + var25, var7 + var40 + var24, (Block)Blocks.field_150333_U, var43, 2);
                if (var52) {
                    NewDungeons.genStone(var0, var1, biome, var5 + var18, var6 + 1 + var25, var7 + var40);
                }
                if (var51) {
                    if (Math.abs(var23 += var27) == 1) {
                        var51 = false;
                    }
                } else if (Math.abs(var24 += var27) == 1) {
                    var51 = true;
                    var27 *= -1;
                }
                if (var43 == 5) {
                    var43 = 13;
                } else {
                    var43 = 5;
                    ++var25;
                }
                if (var6 + var25 > var21 - 2) break;
            }
            var10 = var18;
            var11 = var40;
            var48 = var1.nextInt(9) - 4;
            var58 = var0.func_72825_h(var5 + var18 + var48, var7 + var40 + (var49 = var1.nextInt(9) - 4));
            if (var58 <= 0) break;
            var0.func_147449_b(var5 + var18 + var48, var58, var7 + var40 + var49, Blocks.field_150474_ac);
            TileEntityMobSpawner var57 = (TileEntityMobSpawner)var0.func_147438_o(var5 + var18 + var48, var58, var7 + var40 + var49);
            if (var57 != null) {
                var57.func_145881_a().func_98272_a(NewDungeons.pickMobSpawner(var1));
                break;
            }
            System.err.println("Failed to fetch mob spawner entity at (" + (var5 + var18 + var48) + ", " + var58 + ", " + (var7 + var40 + var49) + ")");
            break;
        }
        ArrayList<DunChest> var38 = new ArrayList<DunChest>();
        for (var40 = 0; var40 < var8 * 2; ++var40) {
            if (var38.size() < 0) {
                var40 = 999999999;
            }
            var41 = var1.nextInt(var2 - 2) + 1;
            var21 = var1.nextInt(var3 - 2) + 1;
            boolean var44 = false;
            if (var0.func_147437_c(var5 + var41, var6 + 1, var7 + var21)) {
                for (var23 = -1; var23 <= 1; ++var23) {
                    for (var24 = -1; var24 <= 1; ++var24) {
                        if (var0.func_147439_a(var5 + var41 + var23, var6 + 1, var7 + var21 + var24).func_149688_o() != Material.field_151576_e || !(Math.abs(var23) == 1 ^ Math.abs(var24) == 1)) continue;
                        var44 = true;
                        break;
                    }
                    if (var44) break;
                }
            }
            boolean var42 = var0.func_147439_a(var5 + var41 + 1, var6 + 1, var7 + var21).func_149688_o() == Material.field_151576_e;
            var46 = var0.func_147439_a(var5 + var41 - 1, var6 + 1, var7 + var21).func_149688_o() == Material.field_151576_e;
            var50 = var0.func_147439_a(var5 + var41, var6 + 1, var7 + var21 + 1).func_149688_o() == Material.field_151576_e;
            var51 = var0.func_147439_a(var5 + var41, var6 + 1, var7 + var21 - 1).func_149688_o() == Material.field_151576_e;
            if ((var42 && var46) ^ (var50 && var51)) {
                var44 = false;
            }
            if (!var44) continue;
            var0.func_147449_b(var5 + var41, var6 + 1, var7 + var21, (Block)Blocks.field_150486_ae);
            var38.add(new DunChest(var5 + var41, var6 + 1, var7 + var21));
        }
        var40 = 0;
        while ((double)var40 < (double)var8 / 1.1) {
            var41 = var1.nextInt(var2 - 2) + 1;
            var21 = var1.nextInt(var3 - 2) + 1;
            boolean var44 = false;
            if (var0.func_147437_c(var5 + var41, var6 + 1, var7 + var21)) {
                for (var23 = -1; var23 <= 1; ++var23) {
                    for (var24 = -1; var24 <= 1; ++var24) {
                        if (var0.func_147439_a(var5 + var41 + var23, var6 + 2, var7 + var21 + var24).func_149688_o() != Material.field_151576_e || !(Math.abs(var23) == 1 ^ Math.abs(var24) == 1)) continue;
                        var44 = true;
                        break;
                    }
                    if (var44) break;
                }
            }
            if (var44) {
                --var13;
                var0.func_147449_b(var5 + var41, var6 + 2, var7 + var21, !ID_COMPATIBILITY ? modDimTorch : Blocks.field_150429_aA);
            }
            ++var40;
        }
        for (var40 = 0; var40 < var8 * 6; ++var40) {
            var41 = var1.nextInt(var2 - 2) + 1;
            if (var0.func_147439_a(var5 + var41, var6 + 2, var7 + (var21 = var1.nextInt(var3 - 2) + 1)).func_149688_o() != Material.field_151576_e) continue;
            var0.func_147449_b(var5 + var41, var6 + 2, var7 + var21, Blocks.field_150411_aY);
        }
        var40 = 0;
        while ((double)var40 < (double)var8 * 0.2) {
            var41 = var1.nextInt(var2 - 2) + 1;
            var21 = var1.nextInt(var3 - 2) + 1;
            boolean var44 = true;
            for (var23 = -2; var23 < 3; ++var23) {
                for (var24 = -2; var24 < 3; ++var24) {
                    if (var0.func_147437_c(var5 + var41 + var23, var6 + 1, var7 + var21 + var24)) continue;
                    var44 = false;
                    break;
                }
                if (!var44) break;
            }
            if (var44) {
                for (var23 = -1; var23 < 2; ++var23) {
                    for (var24 = -1; var24 < 2; ++var24) {
                        var0.func_147449_b(var5 + var41 + var23, var6, var7 + var21 + var24, (Block)Blocks.field_150349_c);
                    }
                }
                ArrayList<Object> var45 = new ArrayList<Object>();
                var24 = var1.nextInt(5) + 3;
                for (var25 = 0; var25 < var24; ++var25) {
                    var26 = var1.nextInt(6);
                    if (var26 < 3) {
                        var45.add(Blocks.field_150382_bo);
                        continue;
                    }
                    if (var26 < 5) {
                        var45.add(Blocks.field_150383_bp);
                        continue;
                    }
                    if (var26 != 5) continue;
                    var45.add(Blocks.field_150486_ae);
                }
                ArrayList<DunChest> var53 = new ArrayList<DunChest>();
                for (var26 = 0; var26 < var45.size(); ++var26) {
                    Block block = (Block)var45.get(var26);
                    var28 = var1.nextInt(3) - 1;
                    if (!var0.func_147437_c(var5 + var41 + var28, var6 + 1, var7 + var21 + (var48 = var1.nextInt(3) - 1))) continue;
                    var0.func_147449_b(var5 + var41 + var28, var6 + 1, var7 + var21 + var48, block);
                    if (block == Blocks.field_150486_ae) {
                        var53.add(new DunChest(var5 + var41 + var28, var6 + 1, var7 + var21 + var48));
                    }
                    if (block != Blocks.field_150383_bp) continue;
                    var0.func_72921_c(var5 + var41 + var28, var6 + 1, var7 + var21 + var48, var1.nextInt(3) + 1, 3);
                }
                for (var26 = 0; var26 < var53.size(); ++var26) {
                    var27 = var1.nextInt(10) + 5;
                    for (var28 = 0; var28 < var27; ++var28) {
                        var48 = var1.nextInt(potLoot.size());
                        var49 = ((DunChest)var53.get((int)var26)).x;
                        var58 = ((DunChest)var53.get((int)var26)).y;
                        int var55 = ((DunChest)var53.get((int)var26)).z;
                        TileEntityChest var63 = null;
                        if (var0.func_147439_a(var49, var58, var55) == Blocks.field_150486_ae) {
                            var63 = (TileEntityChest)var0.func_147438_o(var49, var58, var55);
                        }
                        if (var63 == null) break;
                        for (int var34 = 0; var34 < 1; ++var34) {
                            ItemStack var35 = potLoot.get(var48).getItemStack(var1);
                            if (var35 == null) continue;
                            var63.func_70299_a(var1.nextInt(var63.func_70302_i_()), var35);
                        }
                    }
                    var28 = ((DunChest)var53.get((int)var26)).x;
                    var48 = ((DunChest)var53.get((int)var26)).y;
                    var49 = ((DunChest)var53.get((int)var26)).z;
                    TileEntityChest var56 = null;
                    if (var0.func_147439_a(var28, var48, var49) == Blocks.field_150486_ae) {
                        var56 = (TileEntityChest)var0.func_147438_o(var28, var48, var49);
                    }
                    if (var56 == null) continue;
                    var56.func_70299_a(var1.nextInt(var56.func_70302_i_()), new ItemStack(Items.field_151069_bo, var1.nextInt(7) + 2));
                }
                break;
            }
            ++var40;
        }
        for (var40 = 0; var40 < var8 / 5; ++var40) {
            var41 = var1.nextInt(var2 - 2) + 1;
            var21 = var1.nextInt(var3 - 2) + 1;
            boolean var44 = true;
            var23 = var1.nextInt(2);
            var24 = 0;
            for (var25 = -1; var25 < 3; ++var25) {
                for (var26 = 1; var26 < 4; ++var26) {
                    if (var23 == 1) {
                        if (!NewDungeons.isEmpty(var0, var5 + var41 + var25, var6 + var26, var7 + var21)) {
                            var44 = false;
                        }
                    } else if (!NewDungeons.isEmpty(var0, var5 + var41, var6 + var26, var7 + var21 + var25)) {
                        var44 = false;
                    }
                    if (!var44) break;
                }
                if (!var44) break;
            }
            if (!var44) continue;
            for (var25 = -1; var25 < 3; ++var25) {
                for (var26 = 0; var26 < 5; ++var26) {
                    if (var25 != -1 && var25 != 2 && var26 != 0 && var26 != 4 || var1.nextInt(6) == 1) continue;
                    ++var24;
                    if (var23 == 1) {
                        var0.func_147449_b(var5 + var41 + var25, var6 + var26, var7 + var21, Blocks.field_150343_Z);
                        continue;
                    }
                    var0.func_147449_b(var5 + var41, var6 + var26, var7 + var21 + var25, Blocks.field_150343_Z);
                }
            }
            if (var24 != 14) break;
            for (var25 = 0; var25 < 2; ++var25) {
                for (var26 = 1; var26 < 4; ++var26) {
                    if (var23 == 1) {
                        var0.func_147449_b(var5 + var41 + var25, var6 + var26, var7 + var21, (Block)Blocks.field_150427_aO);
                        continue;
                    }
                    var0.func_147449_b(var5 + var41, var6 + var26, var7 + var21 + var25, (Block)Blocks.field_150427_aO);
                }
            }
            break;
        }
        for (var40 = 0; var40 < var8; ++var40) {
            var41 = var1.nextInt(var2 - 2) + 1;
            var21 = var1.nextInt(var3 - 2) + 1;
            boolean var44 = true;
            for (var23 = -3; var23 < 4; ++var23) {
                for (var24 = -3; var24 < 4; ++var24) {
                    if (var0.func_147437_c(var5 + var41 + var23, var6 + 1, var7 + var21 + var24)) continue;
                    var44 = false;
                    break;
                }
                if (!var44) break;
            }
            if (!var44) continue;
            for (var23 = -2; var23 < 3; ++var23) {
                for (var24 = -2; var24 < 3; ++var24) {
                    var0.func_147449_b(var5 + var41 + var23, var6, var7 + var21 + var24, Blocks.field_150344_f);
                    if (Math.abs(var23) != 2 && Math.abs(var24) != 2 || !var1.nextBoolean()) continue;
                    var25 = var1.nextInt(3);
                    for (var26 = 0; var26 < var25; ++var26) {
                        var0.func_147449_b(var5 + var41 + var23, var6 + 1 + var26, var7 + var21 + var24, Blocks.field_150342_X);
                        NewDungeons.genVine(var0, var1, var5 + var41 + var23, var6 + 1 + var26, var7 + var21 + var24, biome);
                    }
                }
            }
            var0.func_147449_b(var5 + var41, var6 + 1, var7 + var21, Blocks.field_150381_bn);
            break;
        }
        var40 = 0;
        while ((double)var40 < (double)var8 * 1.5) {
            var41 = var1.nextInt(var2 - 2) + 1;
            var21 = var1.nextInt(var3 - 2) + 1;
            boolean var44 = true;
            for (var23 = -2; var23 < 3; ++var23) {
                for (var24 = -2; var24 < 3; ++var24) {
                    if (var0.func_147439_a(var5 + var41 + var23, var6 + 1, var7 + var21 + var24).func_149688_o() != Material.field_151576_e) continue;
                    var44 = false;
                    break;
                }
                if (!var44) break;
            }
            if (var44) {
                for (var23 = 1; var23 < var4 - 1; ++var23) {
                    NewDungeons.genStone(var0, var1, biome, var5 + var41, var6 + var23, var7 + var21);
                }
                for (var23 = -1; var23 < 2; ++var23) {
                    for (var24 = -1; var24 < 2; ++var24) {
                        if (!(var23 == 0 ^ var24 == 0) || var1.nextInt(4) != 0) continue;
                        var0.func_147449_b(var5 + var41 + var23, var6 + 2, var7 + var21 + var24, modDimTorch);
                    }
                }
            }
            ++var40;
        }
        for (var40 = 0; var40 < var8; ++var40) {
            var41 = var1.nextInt(var2 - 2) + 1;
            var21 = var1.nextInt(var3 - 2) + 1;
            boolean var44 = true;
            for (var23 = -1; var23 <= 1; ++var23) {
                for (var24 = -1; var24 <= 1; ++var24) {
                    if (var0.func_147439_a(var5 + var41 + var23, var6 + 1, var7 + var21 + var24).func_149688_o() != Material.field_151576_e) continue;
                    var44 = false;
                    break;
                }
                if (!var44) break;
            }
            if (!var44) continue;
            var13 += 10;
            if (var6 + 1 <= 0) continue;
            var0.func_147449_b(var5 + var41, var6 + 1, var7 + var21, Blocks.field_150474_ac);
            TileEntityMobSpawner var59 = (TileEntityMobSpawner)var0.func_147438_o(var5 + var41, var6 + 1, var7 + var21);
            if (var59 != null) {
                String var60 = NewDungeons.pickMobSpawner(var1);
                var59.func_145881_a().func_98272_a(var60);
                if (!var60.equals("Creeper")) continue;
                var13 += 10;
                continue;
            }
            System.err.println("Failed to fetch mob spawner entity at (" + (var5 + var41) + ", " + (var6 + 1) + ", " + (var7 + var21) + ")");
        }
        int var47 = 2;
        if (biome instanceof BiomeGenDesert) {
            var47 = 8;
        }
        if (biome instanceof BiomeGenSwamp) {
            var47 = 1;
        }
        if (biome instanceof BiomeGenOcean) {
            var47 = 4;
        }
        if (biome instanceof BiomeGenTaiga) {
            var47 = 6;
        }
        if (biome instanceof BiomeGenJungle) {
            var47 = 0;
        }
        var41 = var8 / 2;
        for (var21 = 0; var21 < var41 * var47; ++var21) {
            var22 = var1.nextInt(var2 - 2) + 1;
            var23 = var1.nextInt(var3 - 2) + 1;
            var24 = var1.nextInt(var4 - 2) + var6 + 1;
            var25 = 0;
            for (var26 = -1; var26 <= 2; ++var26) {
                for (var27 = -1; var27 <= 2; ++var27) {
                    for (var28 = -1; var28 <= 2; ++var28) {
                        if (var0.func_147439_a(var5 + var22 + var26, var24 + var28, var7 + var23 + var27).func_149688_o() != Material.field_151576_e) continue;
                        ++var25;
                    }
                }
            }
            if (var25 <= 1 || !var0.func_147437_c(var5 + var22, var24, var7 + var23)) continue;
            var13 += 2;
            var0.func_147449_b(var5 + var22, var24, var7 + var23, Blocks.field_150321_G);
        }
        for (var21 = 0; var21 < var8; ++var21) {
            var22 = var1.nextInt(var2 - 2) + 1;
            var23 = var1.nextInt(var3 - 2) + 1;
            var46 = true;
            for (var25 = -7; var25 <= 8; ++var25) {
                for (var26 = -5; var26 <= 6; ++var26) {
                    if (var0.func_147439_a(var5 + var22 + var25, var6 + 1, var7 + var23 + var26) != Blocks.field_150474_ac) continue;
                    var46 = false;
                    break;
                }
                if (!var46) break;
            }
            if (var0.func_147439_a(var5 + var22, var6 + 2, var7 + var23).func_149688_o() == Material.field_151576_e) {
                var46 = false;
            }
            if (!var46) continue;
            var13 += 4;
            if (!ID_COMPATIBILITY) {
                var0.func_147449_b(var5 + var22, var6 + 1, var7 + var23, pressurePlatetest);
            } else {
                var0.func_147465_d(var5 + var22, var6 + 1, var7 + var23, Blocks.field_150456_au, -1, 2);
            }
            if (var1.nextInt(3) != 1) {
                var0.func_147449_b(var5 + var22, var6, var7 + var23, Blocks.field_150351_n);
            }
            var0.func_147449_b(var5 + var22, var6 - 1, var7 + var23, Blocks.field_150335_W);
            var0.func_147449_b(var5 + var22, var6 - 2, var7 + var23, Blocks.field_150348_b);
            var50 = true;
            for (var26 = -1; var26 < 2; ++var26) {
                for (var27 = -1; var27 < 2; ++var27) {
                    if (!var0.func_147437_c(var5 + var22 + var26, var6 - 3, var7 + var23 + var27)) continue;
                    var50 = false;
                }
            }
            for (var26 = -2; var26 < 3; ++var26) {
                for (var27 = -2; var27 < 3; ++var27) {
                    if (var26 != -2 && var26 != 2 && var27 != -2 && var27 != 2 || !var0.func_147437_c(var5 + var22 + var26, var6 - 2, var7 + var23 + var27)) continue;
                    var50 = false;
                }
            }
            if (var1.nextInt(5) != 1 || !var50) continue;
            for (var26 = -1; var26 < 2; ++var26) {
                for (var27 = -1; var27 < 2; ++var27) {
                    var0.func_147449_b(var5 + var22 + var26, var6 - 3, var7 + var23 + var27, Blocks.field_150353_l);
                }
            }
        }
        for (var21 = 0; var21 < 20; ++var21) {
            TileEntityDispenser var62;
            var22 = var1.nextInt(var2);
            var23 = var1.nextInt(var3);
            if (var1.nextBoolean() && var0.func_147437_c(var5 + var22, var6 + 1, var7 + var23)) {
                var46 = false;
                var50 = false;
                var26 = 0;
                var27 = 0;
                for (var28 = 0; var28 < 200; ++var28) {
                    if (var0.func_147437_c(var5 + var22, var6 + 1, var7 + var23 + var28)) continue;
                    if (var0.func_147439_a(var5 + var22, var6 + 1, var7 + var23 + var28).func_149688_o() != Material.field_151576_e) break;
                    var46 = true;
                    var26 = var28 - 1;
                    break;
                }
                if (var46) {
                    for (var28 = 0; var28 < 200; ++var28) {
                        if (var0.func_147437_c(var5 + var22, var6 + 1, var7 + var23 - var28)) continue;
                        if (var0.func_147439_a(var5 + var22, var6 + 1, var7 + var23 - var28).func_149688_o() != Material.field_151576_e) break;
                        var50 = true;
                        var27 = var28 - 1;
                        break;
                    }
                }
                if (!var50 || var26 + var27 <= 3) continue;
                var0.func_147465_d(var5 + var22, var6 + 1, var7 + var23 + var26, (Block)(!ID_COMPATIBILITY ? modTripWireSource : Blocks.field_150479_bC), 2, 2);
                var0.func_147465_d(var5 + var22, var6 + 1, var7 + var23 - var27, (Block)(!ID_COMPATIBILITY ? modTripWireSource : Blocks.field_150479_bC), 0, 2);
                for (var28 = -var27 + 1; var28 < var26; ++var28) {
                    var0.func_147465_d(var5 + var22, var6 + 1, var7 + var23 + var28, !ID_COMPATIBILITY ? modTripWire : Blocks.field_150473_bD, 4, 2);
                }
                if (var1.nextBoolean()) {
                    var0.func_147449_b(var5 + var22, var6 + 2, var7 + var23 - var27 - 1, Blocks.field_150367_z);
                    var0.func_72921_c(var5 + var22, var6 + 2, var7 + var23 - var27 - 1, 3, 3);
                    var62 = null;
                    if (var0.func_147439_a(var5 + var22, var6 + 2, var7 + var23 - var27 - 1) == Blocks.field_150367_z) {
                        var62 = (TileEntityDispenser)var0.func_147438_o(var5 + var22, var6 + 2, var7 + var23 - var27 - 1);
                    }
                    if (var62 == null) break;
                    var48 = var1.nextInt(5) + 1;
                    for (var49 = 0; var49 < var48; ++var49) {
                        var58 = var1.nextInt(disLoot.size());
                        if (var1.nextInt((int)NewDungeons.disLoot.get((int)var58).rareity) == 0) {
                            var62.func_70299_a(var1.nextInt(var62.func_70302_i_()), disLoot.get(var58).getItemStack(var1));
                            continue;
                        }
                        --var49;
                    }
                    continue;
                }
                var0.func_147449_b(var5 + var22, var6 + 2, var7 + var23 + var26 + 1, Blocks.field_150367_z);
                var0.func_72921_c(var5 + var22, var6 + 2, var7 + var23 + var26 + 1, 2, 3);
                var62 = null;
                if (var0.func_147439_a(var5 + var22, var6 + 2, var7 + var23 + var26 + 1) == Blocks.field_150367_z) {
                    var62 = (TileEntityDispenser)var0.func_147438_o(var5 + var22, var6 + 2, var7 + var23 + var26 + 1);
                }
                if (var62 == null) break;
                var48 = var1.nextInt(5) + 1;
                for (var49 = 0; var49 < var48; ++var49) {
                    var58 = var1.nextInt(disLoot.size());
                    if (var1.nextInt((int)NewDungeons.disLoot.get((int)var58).rareity) == 0) {
                        var62.func_70299_a(var1.nextInt(var62.func_70302_i_()), disLoot.get(var58).getItemStack(var1));
                        continue;
                    }
                    --var49;
                }
                continue;
            }
            if (!var0.func_147437_c(var5 + var22, var6 + 1, var7 + var23)) continue;
            var46 = false;
            var50 = false;
            var26 = 0;
            var27 = 0;
            for (var28 = 0; var28 < 200; ++var28) {
                if (var0.func_147437_c(var5 + var22 + var28, var6 + 1, var7 + var23)) continue;
                if (var0.func_147439_a(var5 + var22 + var28, var6 + 1, var7 + var23).func_149688_o() != Material.field_151576_e) break;
                var46 = true;
                var26 = var28 - 1;
                break;
            }
            if (var46) {
                for (var28 = 0; var28 < 200; ++var28) {
                    if (var0.func_147437_c(var5 + var22 - var28, var6 + 1, var7 + var23)) continue;
                    if (var0.func_147439_a(var5 + var22 - var28, var6 + 1, var7 + var23).func_149688_o() != Material.field_151576_e) break;
                    var50 = true;
                    var27 = var28 - 1;
                    break;
                }
            }
            if (!var50 || var26 + var27 <= 3) continue;
            var0.func_147465_d(var5 + var22 + var26, var6 + 1, var7 + var23, (Block)(!ID_COMPATIBILITY ? modTripWireSource : Blocks.field_150479_bC), 1, 2);
            var0.func_147465_d(var5 + var22 - var27, var6 + 1, var7 + var23, (Block)(!ID_COMPATIBILITY ? modTripWireSource : Blocks.field_150479_bC), 3, 2);
            for (var28 = -var27 + 1; var28 < var26; ++var28) {
                var0.func_147465_d(var5 + var22 + var28, var6 + 1, var7 + var23, !ID_COMPATIBILITY ? modTripWire : Blocks.field_150473_bD, 4, 2);
            }
            if (var1.nextBoolean()) {
                var0.func_147449_b(var5 + var22 - var27 - 1, var6 + 2, var7 + var23, Blocks.field_150367_z);
                var0.func_72921_c(var5 + var22 - var27 - 1, var6 + 2, var7 + var23, 5, 3);
                var62 = null;
                if (var0.func_147439_a(var5 + var22 - var27 - 1, var6 + 2, var7 + var23) == Blocks.field_150367_z) {
                    var62 = (TileEntityDispenser)var0.func_147438_o(var5 + var22 - var27 - 1, var6 + 2, var7 + var23);
                }
                if (var62 == null) break;
                var48 = var1.nextInt(5) + 1;
                for (var49 = 0; var49 < var48; ++var49) {
                    var58 = var1.nextInt(disLoot.size());
                    if (var1.nextInt((int)NewDungeons.disLoot.get((int)var58).rareity) == 0) {
                        var62.func_70299_a(var1.nextInt(var62.func_70302_i_()), disLoot.get(var58).getItemStack(var1));
                        continue;
                    }
                    --var49;
                }
                continue;
            }
            var0.func_147449_b(var5 + var22 + var26 + 1, var6 + 2, var7 + var23, Blocks.field_150367_z);
            var0.func_72921_c(var5 + var22 + var26 + 1, var6 + 2, var7 + var23, 4, 3);
            var62 = null;
            if (var0.func_147439_a(var5 + var22 + var26 + 1, var6 + 2, var7 + var23) == Blocks.field_150367_z) {
                var62 = (TileEntityDispenser)var0.func_147438_o(var5 + var22 + var26 + 1, var6 + 2, var7 + var23);
            }
            if (var62 == null) break;
            var48 = var1.nextInt(5) + 1;
            for (var49 = 0; var49 < var48; ++var49) {
                var58 = var1.nextInt(disLoot.size());
                if (var1.nextInt((int)NewDungeons.disLoot.get((int)var58).rareity) == 0) {
                    var62.func_70299_a(var1.nextInt(var62.func_70302_i_()), disLoot.get(var58).getItemStack(var1));
                    continue;
                }
                --var49;
            }
        }
        double var54 = var13;
        double var61 = var54 / 300.0 * 7.0;
        var25 = (int)(var61 + 2.0);
        if (var12 >= 60) {
            for (var26 = -5; var26 < 6; ++var26) {
                block94: for (var27 = -5; var27 < 6; ++var27) {
                    if (var26 != -5 && var26 != 5 && var27 != -5 && var27 != 5) continue;
                    for (var28 = var1.nextInt(var25) * -1; var28 < 100; ++var28) {
                        if (var0.func_147439_a(var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27).func_149688_o() != Material.field_151579_a && var0.func_147439_a(var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27).func_149688_o() != Material.field_151586_h && var0.func_147439_a(var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27).func_149688_o() != Material.field_151584_j && var0.func_147439_a(var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27).func_149688_o() != Material.field_151575_d && var0.func_147439_a(var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27) != Blocks.field_150329_H && var0.func_147439_a(var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27).func_149688_o() != Material.field_151596_z) {
                            if (var28 < 0) {
                                var0.func_147468_f(var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27);
                            }
                        } else {
                            NewDungeons.genStone(var0, var1, biome, var5 + var10 + var26, var12 + 1 - var28, var7 + var11 + var27);
                        }
                        if (var12 + 1 - var28 < var6 + var4) continue block94;
                    }
                }
            }
        }
        var26 = var13 * 2 * (var38.size() / 2);
        NewDungeons.putLoot(var0, var1, var38, var13, var26);
        return true;
    }

    private static String pickMobSpawner(Random var0) {
        for (int var1 = 0; var1 < 5; ++var1) {
            int var2 = var0.nextInt(6);
            if (var2 == 0) {
                return "Skeleton";
            }
            if (var2 == 1) {
                return "Zombie";
            }
            if (var2 == 2) {
                return "Zombie";
            }
            if (var2 == 3) {
                return "Spider";
            }
            if (var2 != 5 || var0.nextInt(25) != 1) continue;
            return "Creeper";
        }
        return "";
    }

    private static void putLoot(World var0, Random var1, ArrayList<DunChest> var2, int var3, int var4) {
        int var19;
        int var5 = 0;
        boolean var7 = false;
        block0: for (int var8 = 0; var8 < 1000 && var4 > 10; ++var8) {
            for (int var9 = 0; var9 < 1000 && var4 > 10 && var2.size() > 0; ++var9) {
                if (var7) {
                    ++var5;
                }
                var7 = false;
                if (var5 >= var2.size()) {
                    var5 = 0;
                }
                int var10 = var1.nextInt(loot.size());
                DunLootItem var11 = loot.get(var10);
                int var12 = 1;
                if (var11.maxStack - var11.minStack > 1) {
                    var12 = var1.nextInt(var11.maxStack - var11.minStack) + var11.minStack;
                }
                for (var19 = 0; var19 < 100; ++var19) {
                    var10 = var1.nextInt(loot.size());
                    var11 = loot.get(var10);
                    var12 = 1;
                    if (var11.maxStack - var11.minStack > 1) {
                        var12 = var1.nextInt(var11.maxStack - var11.minStack) + var11.minStack;
                    }
                    if (var1.nextInt((int)NewDungeons.loot.get((int)var10).rareity) == 0) break;
                }
                if (var19 == 100 || !((double)var4 > NewDungeons.loot.get((int)var10).value * (double)var12) || NewDungeons.loot.get((int)var10).minDanger > var3 || var2.size() <= 0) continue;
                var4 = (int)((double)var4 - NewDungeons.loot.get((int)var10).value * (double)var12);
                var7 = true;
                int var13 = var2.get((int)var5).x;
                int var14 = var2.get((int)var5).y;
                int var15 = var2.get((int)var5).z;
                var2.get((int)var5).looted = true;
                TileEntityChest var16 = null;
                if (var0.func_147439_a(var13, var14, var15) == Blocks.field_150486_ae) {
                    var16 = (TileEntityChest)var0.func_147438_o(var13, var14, var15);
                }
                if (var16 == null) continue block0;
                for (int var17 = 0; var17 < 1; ++var17) {
                    ItemStack var18 = loot.get(var10).getItemStack(var1);
                    if (NewDungeons.loot.get((int)var10).enchatProb > 0 && var1.nextInt(NewDungeons.loot.get((int)var10).enchatProb) == 0) {
                        EnchantmentHelper.func_77504_a((Random)var1, (ItemStack)var18, (int)NewDungeons.loot.get((int)var10).maxEnchatLev);
                    }
                    if (var18 == null) continue;
                    var16.func_70299_a(var1.nextInt(var16.func_70302_i_()), var18);
                }
            }
        }
        for (var19 = 0; var19 < var2.size(); ++var19) {
            if (var2.get((int)var19).looted) continue;
            var0.func_147468_f(var2.get((int)var19).x, var2.get((int)var19).y, var2.get((int)var19).z);
        }
    }

    private static void setVines(World var0, int x, int y, int z) {
        var0.func_147449_b(x, y, z, Blocks.field_150395_bd);
        for (int var5 = new Random().nextInt(5) + 1; var5 > 0; --var5) {
            if (!var0.func_147437_c(x, --y, z)) {
                return;
            }
            var0.func_147449_b(x, y, z, Blocks.field_150395_bd);
        }
    }

    private static void setVines(World var0, int x, int y, int z, int meta) {
        var0.func_147465_d(x, y, z, Blocks.field_150395_bd, meta, 2);
        for (int var6 = new Random().nextInt(5) + 1; var6 > 0; --var6) {
            if (!var0.func_147437_c(x, --y, z)) {
                return;
            }
            var0.func_147465_d(x, y, z, Blocks.field_150395_bd, meta, 2);
        }
    }

    public String func_71517_b() {
        return "makeDungeon";
    }

    public String func_71518_a(ICommandSender var1) {
        return "makedungeon.usage";
    }

    public void func_71515_b(ICommandSender var1, String[] var2) {
        if (var1 instanceof EntityPlayer) {
            this.serverChat((EntityPlayer)var1, var2);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)this);
    }

    public void serverChat(EntityPlayer var1, String[] var3) {
        if (var3 != null && var3.length >= 3) {
            int divZ;
            int divY;
            int divX;
            try {
                divX = Integer.parseInt(var3[0]);
                divY = Integer.parseInt(var3[1]);
                divZ = Integer.parseInt(var3[2]);
            }
            catch (Exception e) {
                return;
            }
            int sizeX = 5;
            int sizeZ = 5;
            if (var3.length == 5) {
                try {
                    sizeX = Math.abs(Integer.parseInt(var3[3]));
                    sizeZ = Math.abs(Integer.parseInt(var3[4]));
                    if (sizeX < 5) {
                        sizeX = 5;
                    }
                    if (sizeZ < 5) {
                        sizeZ = 5;
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
            double var8 = var1.func_82114_b().field_71574_a + divX;
            double var9 = var1.func_82114_b().field_71572_b + divY;
            double var10 = var1.func_82114_b().field_71573_c + divZ;
            Random var4 = new Random();
            int var14 = sizeX * sizeZ / (var4.nextInt(50) + 50);
            if (var14 < 4) {
                var14 = 4;
            }
            if (NewDungeons.makeDun1(var1.field_70170_p, var4, sizeX, sizeZ, 5, (int)var8, (int)var9, (int)var10, var14, var1.field_70170_p.func_72959_q().func_76935_a((int)var8, (int)var10))) {
                var1.func_146105_b((IChatComponent)new ChatComponentTranslation("dungeon.done", new Object[0]));
            }
        }
    }

    static {
        loot = new ArrayList();
        potLoot = new ArrayList();
        disLoot = new ArrayList();
        maxSize = 110;
        minSize = 10;
        minRoomSize = 2;
        rareity = 500;
        minSquareBlocks = 500;
        additionalItems = "";
        biomesID = "ALL,-WATER";
        height = 5;
        ID_COMPATIBILITY = false;
        biomes = new HashSet();
        dimensionsID = "0";
        dimensions = new HashSet();
    }
}

