/*
 * Decompiled with CFR 0.152.
 */
package org.gudenau.minecraft.cooler.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.gudenau.minecraft.cooler.Cooler;
import org.gudenau.minecraft.cooler.block.tileentity.TileCooler;

public class BlockCooler
extends Block {
    public BlockCooler() {
        super(Material.field_151580_n);
        this.func_149663_c("gud_cooler_cooler");
        this.func_149647_a(CreativeTabs.field_78039_h);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iir) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List items) {
        ItemStack stack = new ItemStack((Block)this, 1, 0xFFFFFF);
        stack.field_77990_d = new NBTTagCompound();
        items.add(stack.func_77946_l());
        stack.func_77964_b(0x1FFFFFF);
        stack.field_77990_d.func_74757_a("clear", true);
        items.add(stack.func_77946_l());
    }

    public int func_149645_b() {
        return Cooler.proxy.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return ((Block)Block.field_149771_c.func_82594_a("snow")).func_149691_a(side, meta);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack stack = new ItemStack((Block)this, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileCooler) {
            TileCooler cooler = (TileCooler)tile;
            cooler.writeToItem(tag);
            stack.func_77964_b((cooler.clear ? 0x1000000 : 0) + (cooler.red & 0xFF) + ((cooler.green & 0xFF) << 8) + ((cooler.blue & 0xFF) << 16));
        }
        stack.field_77990_d = tag;
        return stack;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!world.func_72977_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)8.0).field_71075_bZ.field_75098_d && tile != null && tile instanceof TileCooler) {
            ItemStack stack = new ItemStack((Block)this, 1, 0);
            NBTTagCompound tag = new NBTTagCompound();
            TileCooler cooler = (TileCooler)tile;
            cooler.writeToItem(tag);
            tag.func_82580_o("handle");
            stack.field_77990_d = tag;
            stack.func_77964_b((cooler.clear ? 0x1000000 : 0) + (cooler.red & 0xFF) + ((cooler.green & 0xFF) << 8) + ((cooler.blue & 0xFF) << 16));
            if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
                entityitem.field_145804_b = 5;
                EntityPlayer nearestPlayer = world.func_72890_a((Entity)entityitem, 5.0);
                if (nearestPlayer != null) {
                    double xDiff = nearestPlayer.field_70165_t - entityitem.field_70165_t;
                    double zDiff = nearestPlayer.field_70161_v - entityitem.field_70161_v;
                    entityitem.field_70159_w = xDiff / 10.0;
                    entityitem.field_70179_y = zDiff / 10.0;
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_147475_p(x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != null && player.func_70694_bm().func_77973_b() instanceof ItemDye && (tile = world.func_147438_o(x, y, z)) instanceof TileCooler) {
            TileCooler cooler = (TileCooler)tile;
            cooler.red = ItemDye.field_150922_c[player.func_70694_bm().func_77960_j()] >> 16 & 0xFF;
            cooler.green = ItemDye.field_150922_c[player.func_70694_bm().func_77960_j()] >> 8 & 0xFF;
            cooler.blue = ItemDye.field_150922_c[player.func_70694_bm().func_77960_j()] & 0xFF;
            return true;
        }
        player.openGui((Object)Cooler.instance, 0, world, x, y, z);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileCooler();
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) & 3;
        switch (meta) {
            case 0: 
            case 2: {
                this.func_149676_a(0.28125f, 0.0f, 0.0625f, 0.71875f, 0.6875f, 0.9375f);
                break;
            }
            default: {
                this.func_149676_a(0.0625f, 0.0f, 0.28125f, 0.9375f, 0.6875f, 0.71875f);
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0625f, 0.0f, 0.28125f, 0.9375f, 0.6875f, 0.71875f);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block l = world.func_147439_a(x, y, z - 1);
            Block i1 = world.func_147439_a(x, y, z + 1);
            Block j1 = world.func_147439_a(x - 1, y, z);
            Block k1 = world.func_147439_a(x + 1, y, z);
            int facing = 2;
            world.func_72921_c(x, y, z, facing, 2);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            facing = 3;
        } else if (facing == 1) {
            facing = 2;
        } else if (facing == 2) {
            facing = 1;
        } else if (facing == 3) {
            facing = 0;
        }
        world.func_72921_c(x, y, z, facing, 2);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149696_a(World world, int x, int y, int z, int id, int event) {
        super.func_149696_a(world, x, y, z, id, event);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null ? tileentity.func_145842_c(id, event) : false;
    }
}

