/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica;

import com.github.lunatrius.schematica.BlockInfo;
import com.github.lunatrius.schematica.ChatEventHandler;
import com.github.lunatrius.schematica.FileFilterConfiguration;
import com.github.lunatrius.schematica.SchematicPrinter;
import com.github.lunatrius.schematica.Settings;
import com.github.lunatrius.schematica.client.Events;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunk;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicGlobal;
import com.github.lunatrius.schematica.config.Config;
import com.github.lunatrius.schematica.lib.Reference;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Schematica")
public class Schematica {
    private static final FileFilterConfiguration FILE_FILTER_CONFIGURATION = new FileFilterConfiguration();
    private static final String DIR_ASSETS = "lunatrius/schematica/assets/";
    private final Settings settings = Settings.instance();
    private final Profiler profiler;
    private final SchematicPrinter printer;
    private int ticks;
    @Mod.Instance(value="Schematica")
    public static Schematica instance;
    private Field sortedWorldRenderers;
    private File configurationFolder;

    public Schematica() {
        this.profiler = this.settings.minecraft.field_71424_I;
        this.printer = new SchematicPrinter();
        this.ticks = -1;
        this.sortedWorldRenderers = null;
        this.configurationFolder = null;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File suggestedConfigurationFile = event.getSuggestedConfigurationFile();
        Reference.config = new Config(suggestedConfigurationFile);
        Reference.config.save();
        this.configurationFolder = suggestedConfigurationFile.getParentFile();
        Settings.logger = event.getModLog();
        if (!Settings.schematicDirectory.exists() && !Settings.schematicDirectory.mkdirs()) {
            Settings.logger.info("Could not create schematic directory!");
        }
        if (!Settings.textureDirectory.exists() && !Settings.textureDirectory.mkdirs()) {
            Settings.logger.info("Could not create texture directory!");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new RendererSchematicGlobal());
            MinecraftForge.EVENT_BUS.register((Object)new ChatEventHandler());
            for (KeyBinding keyBinding : this.settings.keyBindings) {
                ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
            }
            FMLCommonHandler.instance().bus().register((Object)new Events());
            this.sortedWorldRenderers = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"n", "field_72768_k", "sortedWorldRenderers"});
        }
        catch (Exception e) {
            Settings.logger.fatal("Could not initialize the mod!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigurationFile(URL configurationFile, String configurationFilename) {
        if (configurationFile == null) {
            Settings.logger.info("Skipping " + configurationFilename + "...");
            return;
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        Settings.logger.info("Reading " + configurationFilename + "...");
        try {
            inputStream = configurationFile.openStream();
            properties.load(inputStream);
        }
        catch (IOException e) {
            Settings.logger.error("Could not load properties file.", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Settings.logger.error("Could not close properties file.", (Throwable)e);
            }
        }
        String filename = configurationFilename.toLowerCase();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (filename.startsWith("alias")) {
                if (BlockInfo.addMappingAlias(key, value)) continue;
                Settings.logger.warn("Failed alias: " + key + " => " + value);
                continue;
            }
            if (filename.startsWith("flip")) {
                if (BlockInfo.addMappingFlip(key, value)) continue;
                Settings.logger.warn("Failed flip: " + key + " => " + value);
                continue;
            }
            if (!filename.startsWith("rotation") || BlockInfo.addMappingRotation(key, value)) continue;
            Settings.logger.warn("Failed rotation: " + key + " => " + value);
        }
    }

    public void keyboardEvent(KeyBinding keyBinding) {
        this.settings.keyboardEvent(keyBinding);
    }

    public boolean onTick() {
        this.profiler.func_76320_a("schematica");
        if (this.settings.minecraft.field_71439_g != null && this.settings.isRenderingSchematic && this.settings.schematic != null) {
            this.profiler.func_76320_a("printer");
            if (this.settings.isPrinterEnabled && this.settings.isPrinting && this.ticks-- < 0) {
                this.ticks = this.settings.placeDelay;
                this.printer.print();
            }
            this.profiler.func_76318_c("checkDirty");
            this.checkDirty();
            this.profiler.func_76318_c("canUpdate");
            RendererSchematicChunk.setCanUpdate(true);
            this.profiler.func_76319_b();
        } else if (this.settings.minecraft.field_71439_g == null) {
            this.settings.reset();
        }
        this.profiler.func_76319_b();
        return true;
    }

    private void checkDirty() {
        if (this.sortedWorldRenderers != null) {
            try {
                WorldRenderer[] renderers = (WorldRenderer[])this.sortedWorldRenderers.get(this.settings.minecraft.field_71438_f);
                if (renderers != null) {
                    int count = 0;
                    for (WorldRenderer worldRenderer : renderers) {
                        if (!worldRenderer.field_78939_q || count++ >= 125) continue;
                        AxisAlignedBB worldRendererBoundingBox = worldRenderer.field_78938_r.func_72325_c((double)(-this.settings.offset.x), (double)(-this.settings.offset.y), (double)(-this.settings.offset.z));
                        for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                            if (renderer.getDirty() || !renderer.getBoundingBox().func_72326_a(worldRendererBoundingBox)) continue;
                            renderer.setDirty();
                        }
                    }
                }
            }
            catch (Exception e) {
                Settings.logger.error("Dirty check failed!", (Throwable)e);
            }
        }
    }
}

