/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.geoip;

import com.maxmind.geoip.Country;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import uk.org.whoami.geoip.util.ConsoleLogger;
import uk.org.whoami.geoip.util.Settings;

public class GeoIPLookup {
    public static final int COUNTRYDATABASE = 100;
    public static final int CITYDATABASE = 200;
    public static final int IPV6DATABASE = 300;
    private LookupService geo = null;
    private LookupService geov6 = null;
    private Settings settings;
    private int type = -1;

    GeoIPLookup(Settings settings) throws IOException {
        this.settings = settings;
    }

    public Country getCountry(InetAddress inet) {
        if (inet instanceof Inet4Address) {
            if (this.geo != null) {
                return this.geo.getCountry(inet);
            }
            ConsoleLogger.info("Uninitialised LookupService");
            return new Country("--", "N/A");
        }
        if (inet instanceof Inet6Address) {
            if (this.geov6 != null) {
                return this.geov6.getCountryV6(inet);
            }
            ConsoleLogger.info("Uninitialised IPv6 LookupService");
            return new Country("--", "N/A");
        }
        ConsoleLogger.info("I see you are using IPv5");
        return new Country("--", "N/A");
    }

    public Location getLocation(InetAddress inet) {
        if (inet instanceof Inet4Address) {
            if (this.geo != null) {
                return this.geo.getLocation(inet);
            }
            ConsoleLogger.info("Uninitialised LookupService");
        } else if (inet instanceof Inet6Address) {
            ConsoleLogger.info("IPv6 is not supported for getLocation");
        }
        return null;
    }

    public LookupService getLookupService() {
        return this.geo;
    }

    public LookupService getLookupServiccev6() {
        return this.geov6;
    }

    void initCountry() throws IOException {
        if (this.type == -1) {
            this.geo = new LookupService(this.settings.getCountryDatabasePath(), 1);
            this.type = 100;
        }
    }

    void initCity() throws IOException {
        if (this.type == 100 || this.type == -1) {
            if (this.type != -1) {
                this.geo.close();
            }
            this.geo = new LookupService(this.settings.getCityDatabasePath(), 1);
            this.type = 200;
        }
    }

    void initIPv6() throws IOException {
        if (this.geov6 == null) {
            this.geov6 = new LookupService(this.settings.getIPv6DatabasePath(), 1);
        }
    }

    void reload() throws IOException {
        if (this.geo != null) {
            this.geo.close();
            this.geo = this.type == 100 ? new LookupService(this.settings.getCountryDatabasePath(), 1) : new LookupService(this.settings.getCityDatabasePath(), 1);
        }
        if (this.geov6 != null) {
            this.geov6.close();
            this.geov6 = new LookupService(this.settings.getIPv6DatabasePath(), 1);
        }
    }

    void close() {
        if (this.geo != null) {
            this.geo.close();
            this.geo = null;
        }
        if (this.geov6 != null) {
            this.geov6.close();
            this.geov6 = null;
        }
    }
}

