/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.geoip;

import java.io.IOException;
import java.net.MalformedURLException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.org.whoami.geoip.GeoIPLookup;
import uk.org.whoami.geoip.UpdateTask;
import uk.org.whoami.geoip.util.ConsoleLogger;
import uk.org.whoami.geoip.util.Settings;
import uk.org.whoami.geoip.util.Updater;

public class GeoIPTools
extends JavaPlugin {
    private Settings settings;
    private GeoIPLookup geo = null;

    public void onLoad() {
        this.settings = new Settings(this.getConfiguration());
        ConsoleLogger.info("Starting database updates");
        try {
            Updater.update(this.settings);
        }
        catch (MalformedURLException ex) {
            ConsoleLogger.info(ex.getMessage());
        }
        ConsoleLogger.info(this.getDescription().getName() + " " + this.getDescription().getVersion() + " loaded");
    }

    public void onEnable() {
    }

    public void onDisable() {
        if (this.geo != null) {
            this.geo.close();
            this.geo = null;
        }
        ConsoleLogger.info(this.getDescription().getName() + " " + this.getDescription().getVersion() + " disabled");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (label.equalsIgnoreCase("geoupdate")) {
            if (sender.hasPermission("GeoIPTools.geoupdate")) {
                this.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this, (Runnable)new UpdateTask(sender, this.settings, this.geo), 0L);
            }
            return true;
        }
        return false;
    }

    public GeoIPLookup getGeoIPLookup(int bitmask) {
        block8: {
            try {
                if (this.geo == null) {
                    this.geo = new GeoIPLookup(this.settings);
                }
                if (bitmask == 100) {
                    this.geo.initCountry();
                    break block8;
                }
                if (bitmask == 200) {
                    this.geo.initCity();
                    break block8;
                }
                if (bitmask == 300) {
                    this.geo.initIPv6();
                    break block8;
                }
                if (bitmask == 364) {
                    this.geo.initCountry();
                    this.geo.initIPv6();
                    break block8;
                }
                if (bitmask == 492) {
                    this.geo.initCity();
                    this.geo.initIPv6();
                    break block8;
                }
                ConsoleLogger.info("Unsupported bitmask");
                return null;
            }
            catch (IOException e) {
                ConsoleLogger.info("Can't load database");
                ConsoleLogger.info(e.getMessage());
                return null;
            }
        }
        return this.geo;
    }
}

