/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.geoip.util;

import org.bukkit.util.config.Configuration;

public class Settings {
    final String CITYDATABASEPATH = "./plugins/GeoIPTools/GeoLiteCity.dat";
    final String COUNTRYDATABASEPATH = "./plugins/GeoIPTools/GeoIP.dat";
    final String IPV6DATABASEBATH = "./plugins/GeoIPTools/GeoIPv6.dat";
    private Configuration conf;

    public Settings(Configuration conf) {
        this.conf = conf;
        conf.load();
        this.write();
    }

    public final void write() {
        this.getIPv6DatabaseURL();
        this.getCityDatabaseURL();
        this.getCountryDatabaseURL();
        this.getLastUpdated();
        this.isUpdaterDisabled();
        this.conf.save();
    }

    public boolean isUpdaterDisabled() {
        String key = "Update:disabled";
        if (this.conf.getString(key) == null) {
            this.conf.setProperty(key, (Object)false);
        }
        return this.conf.getBoolean(key, false);
    }

    public void setLastUpdated(long lastUpdated) {
        String key = "Update:lastUpdated";
        this.conf.setProperty(key, (Object)String.valueOf(lastUpdated));
    }

    public long getLastUpdated() {
        String key = "Update:lastUpdated";
        if (this.conf.getString(key) == null) {
            this.conf.setProperty(key, (Object)"0");
        }
        return Long.parseLong(this.conf.getString(key));
    }

    public String getIPv6DatabaseURL() {
        String key = "URL.IPv6Database";
        if (this.conf.getString(key) == null) {
            this.conf.setProperty(key, (Object)"http://geolite.maxmind.com/download/geoip/database/GeoIPv6.dat.gz");
        }
        return this.conf.getString(key);
    }

    public String getCityDatabaseURL() {
        String key = "URL.CityDatabase";
        if (this.conf.getString(key) == null) {
            this.conf.setProperty(key, (Object)"http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz");
        }
        return this.conf.getString(key);
    }

    public String getCountryDatabaseURL() {
        String key = "URL.CountryDatabase";
        if (this.conf.getString(key) == null) {
            this.conf.setProperty(key, (Object)"http://geolite.maxmind.com/download/geoip/database/GeoLiteCountry/GeoIP.dat.gz");
        }
        return this.conf.getString(key);
    }

    public String getIPv6DatabasePath() {
        String key = "Path.IPv6Database";
        if (this.conf.getString(key) == null) {
            return this.IPV6DATABASEBATH;
        }
        return this.conf.getString(key);
    }

    public String getCityDatabasePath() {
        String key = "Path.cityDatabase";
        if (this.conf.getString(key) == null) {
            return this.CITYDATABASEPATH;
        }
        return this.conf.getString(key);
    }

    public String getCountryDatabasePath() {
        String key = "Path.countryDatabase";
        if (this.conf.getString(key) == null) {
            return this.COUNTRYDATABASEPATH;
        }
        return this.conf.getString(key);
    }
}

