/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.geoip.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import uk.org.whoami.geoip.util.ConsoleLogger;
import uk.org.whoami.geoip.util.Settings;

public class Updater {
    public static void update(Settings settings) throws MalformedURLException {
        URL url;
        File file;
        if (settings.getCityDatabasePath().equals(settings.CITYDATABASEPATH)) {
            file = new File(settings.CITYDATABASEPATH);
            if (file.exists() && settings.isUpdaterDisabled()) {
                return;
            }
            url = new URL(settings.getCityDatabaseURL());
            Updater.updateFile(url, file, settings.getLastUpdated());
            ConsoleLogger.info(settings.CITYDATABASEPATH + " updated");
        }
        if (settings.getCountryDatabasePath().equals(settings.COUNTRYDATABASEPATH)) {
            file = new File(settings.COUNTRYDATABASEPATH);
            if (file.exists() && settings.isUpdaterDisabled()) {
                return;
            }
            url = new URL(settings.getCountryDatabaseURL());
            Updater.updateFile(url, file, settings.getLastUpdated());
            ConsoleLogger.info(settings.COUNTRYDATABASEPATH + " updated");
        }
        if (settings.getIPv6DatabasePath().equals(settings.IPV6DATABASEBATH)) {
            file = new File(settings.IPV6DATABASEBATH);
            if (file.exists() && settings.isUpdaterDisabled()) {
                return;
            }
            url = new URL(settings.getIPv6DatabaseURL());
            Updater.updateFile(url, file, settings.getLastUpdated());
            ConsoleLogger.info(settings.IPV6DATABASEBATH + " updated");
        }
        settings.setLastUpdated(new Date().getTime());
        settings.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFile(URL url, File file, long lastUpdated) {
        HttpURLConnection con = null;
        FilterOutputStream out = null;
        GZIPInputStream in = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(10000);
            con.setConnectTimeout(10000);
            con.setIfModifiedSince(lastUpdated);
            con.connect();
            if (con.getResponseCode() == 200) {
                int len;
                byte[] buffer = new byte[4096];
                out = new BufferedOutputStream(new FileOutputStream(file));
                in = new GZIPInputStream(con.getInputStream());
                while ((len = in.read(buffer, 0, buffer.length)) > -1) {
                    ((BufferedOutputStream)out).write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            ConsoleLogger.info(e.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
            }
            catch (NullPointerException e) {}
            try {
                in.close();
            }
            catch (IOException e) {
            }
            catch (NullPointerException e) {}
            try {
                con.disconnect();
            }
            catch (NullPointerException e) {}
        }
    }
}

