/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import jaredbgreat.dldungeons.Difficulty;
import jaredbgreat.dldungeons.GenerationHandler;
import jaredbgreat.dldungeons.themes.Theme;
import jaredbgreat.dldungeons.themes.ThemeReader;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private static File mainConfig;
    private static File themesDir;
    private static final int DEFAULT_SCALE = 6;
    private static final int DEFAULT_MINXZ = 16;
    private static final int DEFAULT_DIF = 3;
    private static final int[] DEFAULT_DIMS;
    private static final boolean DEFAULT_NODEND = true;
    public static Difficulty difficulty;

    public static void init(File file) {
        mainConfig = file;
        Configuration config = new Configuration(file);
        config.load();
        int freqScale = config.get("General", "FrequencyScale", 6).getInt();
        if (freqScale > 30 || freqScale < 4) {
            freqScale = 6;
        }
        GenerationHandler.setFrequency(freqScale);
        System.out.println("[DLDUNGEONS] Frequency Scaling Factor Set To: " + freqScale);
        int minXZ = config.get("General", "MinChunkXY", 16).getInt();
        if (minXZ < 0) {
            freqScale = 16;
        }
        GenerationHandler.setMinXZ(minXZ);
        System.out.println("[DLDUNGEONS] Minimum X Factor Set To: " + minXZ);
        int diff = config.get("General", "Difficulty", 3).getInt();
        if (diff < 0 || diff > 5) {
            freqScale = 3;
        }
        ConfigHandler.parseDiff(diff);
        System.out.println("[DLDUNGEONS] Difficulty set to: " + ConfigHandler.difficulty.label);
        int[] dims = config.get("General", "Allowed Dimensions", DEFAULT_DIMS).getIntList();
        GenerationHandler.setDimensions(dims);
        System.out.print("[DLDUNGEONS] Dungeons will spawn in these dimensions: ");
        for (int i = 0; i < dims.length; ++i) {
            System.out.print(dims[i] + ", ");
        }
        System.out.println();
        boolean noEnd = config.get("General", "NotInEnd", true).getBoolean(true);
        GenerationHandler.setEnd(noEnd);
        System.out.println("[DLDUNGEONS] NoEnd set to: " + noEnd);
        Theme.addDefaultTheme();
        ConfigHandler.openThemesDir();
        config.save();
    }

    private static void openThemesDir() {
        String themesDirName = mainConfig.getParentFile() + File.separator + "DLDungeonThemes" + File.separator;
        themesDir = new File(themesDirName);
        if (!themesDir.exists()) {
            themesDir.mkdir();
        }
        if (!themesDir.exists()) {
            System.out.println("[DLDUNGEONS] Warning: Could not create " + themesDirName + ".");
        } else if (!themesDir.isDirectory()) {
            System.out.println("[DLDUNGEONS] Warning: " + themesDirName + " is not a directory (folder); no themes loaded.");
        } else {
            ThemeReader.setThemesDir(themesDir);
        }
    }

    private static void parseDiff(int diff) {
        switch (diff) {
            case 0: {
                difficulty = Difficulty.NONE;
                break;
            }
            case 1: {
                difficulty = Difficulty.BABY;
                break;
            }
            case 2: {
                difficulty = Difficulty.NOOB;
                break;
            }
            case 4: {
                difficulty = Difficulty.HARD;
                break;
            }
            case 5: {
                difficulty = Difficulty.NUTS;
                break;
            }
            default: {
                difficulty = Difficulty.NORM;
            }
        }
    }

    static {
        DEFAULT_DIMS = new int[]{0, -1};
    }
}

