/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import jaredbgreat.dldungeons.builder.Builder;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class GenerationHandler
implements IWorldGenerator {
    private static int factor = 6;
    private static int minXZ;
    private static Random mrand;
    private static boolean noEnd;
    private static HashSet<Integer> dimensions;

    public GenerationHandler() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)100);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_72807_a(chunkX * 16, chunkZ * 16) == BiomeGenBase.field_76779_k && noEnd) {
            return;
        }
        if (!dimensions.contains(world.field_73011_w.field_76574_g)) {
            return;
        }
        if (Math.abs(chunkX - world.func_72861_E().field_71574_a / 16) < minXZ || Math.abs(chunkZ - world.func_72861_E().field_71573_c / 16) < minXZ) {
            return;
        }
        int xseed = (int)(world.func_72905_C() % Integer.MIN_VALUE);
        int zseed = (int)(world.func_72905_C() / Integer.MIN_VALUE);
        mrand = new Random((long)xseed + 2027L * (long)(chunkX / factor) + 1987L * (long)(chunkZ / factor));
        int xrand = mrand.nextInt();
        int zrand = mrand.nextInt();
        int xuse = (chunkX + xseed + xrand) % factor;
        int zuse = (chunkZ + zseed + zrand) % factor;
        if (xuse == 0 && zuse == 0) {
            try {
                Builder.placeDungeon(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
            catch (Throwable e) {
                System.err.println("[DLDUNGEONS] Danger!  Failed to finalize a dungeon after building!");
                e.printStackTrace();
            }
        }
    }

    public static void setFrequency(int freqScale) {
        factor = freqScale % 2 == 0 ? 2 : 3;
        System.out.println("freqScale = " + freqScale);
        System.out.println("factor = " + (factor <<= freqScale / 2));
    }

    public static void setMinXZ(int value) {
        minXZ = value;
    }

    public static void setEnd(boolean value) {
        noEnd = value;
    }

    public static void setDimensions(int[] value) {
        dimensions = new HashSet();
        dimensions.clear();
        for (int i = 0; i < value.length; ++i) {
            dimensions.add(value[i]);
        }
    }
}

