/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.builder.Builder;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class BasicChest {
    public int mx;
    public int my;
    public int mz;
    public int level;
    protected static final BlockChest chest = (BlockChest)Block.func_149684_b((String)"chest");

    public BasicChest(int x, int y, int z, int level) {
        this.mx = x;
        this.my = y;
        this.mz = z;
        this.level = level;
    }

    public void place(World world, int x, int y, int z, Random random) {
        this.level += random.nextInt(2);
        Builder.placeBlock(world, x, y, z, (Block)chest, 0, 2);
        TileEntityChest contents = (TileEntityChest)world.func_147438_o(x, y, z);
        this.vanillaChest(contents, random);
        int which = random.nextInt(2);
        switch (which) {
            case 0: {
                this.fillChest(contents, LootCategory.gear, random);
                break;
            }
            case 1: {
                this.fillChest(contents, LootCategory.heal, random);
            }
        }
    }

    private void vanillaChest(TileEntityChest chest, Random random) {
        ChestGenHooks chinf;
        int which = random.nextInt(6);
        switch (which) {
            case 0: {
                chinf = ChestGenHooks.getInfo((String)"bonusChest");
                break;
            }
            case 1: {
                chinf = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
                break;
            }
            case 2: {
                chinf = ChestGenHooks.getInfo((String)"pyramidJungleChest");
                break;
            }
            case 3: {
                chinf = ChestGenHooks.getInfo((String)"mineshaftCorridor");
                break;
            }
            case 4: {
                chinf = ChestGenHooks.getInfo((String)"villageBlacksmith");
                break;
            }
            default: {
                chinf = ChestGenHooks.getInfo((String)"dungeonChest");
            }
        }
        WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chinf.getItems(random), (IInventory)chest, (int)chinf.getCount(random));
    }

    protected void fillChest(TileEntityChest chest, LootCategory kind, Random random) {
        int num = random.nextInt(2 + this.level / 2) + 3;
        for (int i = 0; i < num; ++i) {
            ItemStack treasure = kind.levels[this.level].getLoot(random).getStack(random);
            if (treasure == null) continue;
            chest.func_70299_a(random.nextInt(27), treasure);
        }
    }
}

