/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner;

import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.planner.Node;
import jaredbgreat.dldungeons.rooms.Room;
import java.util.ArrayList;
import java.util.Random;

public class Route {
    Node start;
    Node finish;
    Room current1;
    Room current2;
    Room temp;
    float realXDist;
    float realZDist;
    int bXDist;
    int bZDist;
    int dir1;
    int dir2;
    boolean xMatch;
    boolean zMatch;
    boolean finishTurn;
    boolean complete;
    boolean comp1;
    boolean comp2;
    public boolean roomNew;
    ArrayList<Room> side1;
    ArrayList<Room> side2;

    protected Route(Node start, Node finish) {
        this.start = start;
        this.finish = finish;
        this.current1 = start.hubRoom;
        this.current2 = finish.hubRoom;
        this.side1 = new ArrayList();
        this.side1.add(this.current1);
        this.side2 = new ArrayList();
        this.side2.add(this.current2);
        this.roomNew = false;
        this.finishTurn = false;
        this.complete = false;
        if (this.realXDist > 3.0f) {
            this.bXDist = this.current2.endX - this.current1.beginX;
            this.xMatch = false;
        } else if (this.realXDist < -3.0f) {
            this.bXDist = this.current2.beginX - this.current1.endX;
            this.xMatch = false;
        } else {
            this.bXDist = (int)this.realXDist;
            this.xMatch = true;
        }
        if (this.realZDist > 3.0f) {
            this.bZDist = this.current2.endZ - this.current1.beginZ;
            this.zMatch = false;
        } else if (this.realZDist < -3.0f) {
            this.bZDist = this.current2.beginZ - this.current1.endZ;
            this.zMatch = false;
        } else {
            this.bZDist = (int)this.realZDist;
            this.zMatch = true;
        }
    }

    protected void drawConnections(Dungeon dungeon) throws Throwable {
        while (!this.complete) {
            if (dungeon.rooms.size() >= dungeon.size.maxRooms) {
                return;
            }
            this.drawConnection(dungeon);
            if (!this.complete) continue;
            return;
        }
        this.finish = null;
        this.start = null;
        this.temp = null;
        this.current2 = null;
        this.current1 = null;
        this.side1.clear();
        this.side2.clear();
        this.side2 = null;
        this.side1 = null;
        super.finalize();
    }

    public void drawConnection(Dungeon dungeon) {
        this.getGrowthDir(dungeon.random);
        int xdim = dungeon.random.nextInt(dungeon.size.maxRoomSize - 5) + 6;
        int zdim = dungeon.random.nextInt(dungeon.size.maxRoomSize - 5) + 6;
        int ymod = xdim <= zdim ? (int)Math.sqrt(xdim) : (int)Math.sqrt(zdim);
        int roomHeight = dungeon.random.nextInt(dungeon.verticle.value / 2 + ymod + 1) + 2;
        if (this.finishTurn) {
            this.dir1 = (this.dir1 + 2) % 4;
            this.dir2 = (this.dir2 + 2) % 4;
            this.temp = this.current2.connector(dungeon, this.dir1, xdim, zdim, roomHeight, this);
            if (this.temp == null || this.side2.contains(this.temp)) {
                this.temp = this.current2.connector(dungeon, this.dir2, xdim, zdim, roomHeight, this);
            }
            if (this.temp == null || this.side2.contains(this.temp)) {
                this.comp2 = true;
            } else if (this.side1.contains(this.temp)) {
                this.complete = true;
            } else {
                this.side2.add(this.temp);
                this.current2 = this.temp;
            }
        } else {
            this.temp = this.current1.connector(dungeon, this.dir1, xdim, zdim, roomHeight, this);
            if (this.temp == null || this.side1.contains(this.temp)) {
                this.temp = this.current1.connector(dungeon, this.dir2, xdim, zdim, roomHeight, this);
            }
            if (this.temp == null || this.side1.contains(this.temp)) {
                this.comp1 = true;
            } else if (this.side2.contains(this.temp)) {
                this.complete = true;
            } else {
                this.side1.add(this.temp);
                this.current1 = this.temp;
            }
        }
        if (!this.complete) {
            boolean bl = this.complete = this.comp1 && this.comp2;
        }
        this.finishTurn = this.comp1 ? true : (this.comp2 ? false : !this.finishTurn);
    }

    private boolean xOverlap() {
        return this.current1.endX > this.current2.beginX && this.current2.endX > this.current1.beginX;
    }

    private boolean zOverlap() {
        return this.current1.endZ > this.current2.beginZ && this.current2.endZ > this.current1.beginZ;
    }

    private void getGrowthDir(Random random) {
        boolean posZ;
        boolean posX = this.current1.realZ < this.current2.realZ;
        boolean bl = posZ = this.current1.realZ < this.current2.realZ;
        if (this.xOverlap()) {
            if (posZ) {
                this.dir1 = 1;
                this.dir2 = random.nextInt(2) * 2;
            } else {
                this.dir1 = 3;
                this.dir2 = random.nextInt(2) * 2;
            }
        } else if (this.zOverlap()) {
            if (posX) {
                this.dir1 = 0;
                this.dir2 = 1 + random.nextInt(2) * 2;
            } else {
                this.dir1 = 2;
                this.dir2 = 1 + random.nextInt(2) * 2;
            }
        } else if (random.nextInt((int)(Math.abs(this.realXDist) + Math.abs(this.realZDist) + 1.0f)) > (int)Math.abs(this.realXDist)) {
            if (posX) {
                this.dir1 = 0;
                this.dir2 = posZ ? 1 : 3;
            } else {
                this.dir1 = 2;
                this.dir2 = posZ ? 1 : 3;
            }
        } else if (posZ) {
            this.dir1 = 1;
            this.dir2 = posX ? 0 : 2;
        } else {
            this.dir1 = 3;
            this.dir2 = posX ? 0 : 2;
        }
    }
}

