/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.themes;

import jaredbgreat.dldungeons.themes.BlockList;
import jaredbgreat.dldungeons.themes.Element;
import jaredbgreat.dldungeons.themes.SizeElement;
import jaredbgreat.dldungeons.themes.Theme;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraftforge.common.BiomeDictionary;

public class ThemeReader {
    private static File themesDir;
    private static ArrayList<File> files;

    public static void setThemesDir(File dir) {
        themesDir = dir;
    }

    private static int findFiles() {
        int num = 0;
        files = new ArrayList();
        String[] fileNames = themesDir.list();
        if (fileNames.length < 1) {
            return 0;
        }
        for (String name : fileNames) {
            if (name.length() < 5 || name.equals("template.cfg") || !name.substring(name.length() - 4).equals(".cfg")) continue;
            files.add(new File(name));
            ++num;
        }
        return num;
    }

    public static void readThemes() {
        int num = ThemeReader.findFiles();
        System.out.println("[DLDUNGEONS] Found " + num + " themes.");
        if (num < 1) {
            Theme.addDefaultTheme();
        } else {
            for (File file : files) {
                ThemeReader.readTheme(file);
            }
        }
    }

    private static void readTheme(File file) {
        BufferedReader instream = null;
        try {
            instream = new BufferedReader(new FileReader(themesDir.toString() + File.separator + file.toString()));
            System.out.println("[DLDUNGEONS] Loading theme file " + file.toString());
            ThemeReader.parseTheme(instream, file.toString());
            if (instream != null) {
                instream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void parseTheme(BufferedReader instream, String name) throws IOException {
        Theme theme = new Theme();
        theme.name = name;
        StringTokenizer tokens = null;
        String line = null;
        while ((line = instream.readLine()) != null) {
            if (line.length() < 2 || line.charAt(0) == '#' || !(tokens = new StringTokenizer(line, " ,;:\t\n\r\f=")).hasMoreTokens()) continue;
            String token = tokens.nextToken().toLowerCase();
            if (token.toLowerCase().equals("miny")) {
                theme.minY = ThemeReader.intParser(theme.minY, tokens);
                continue;
            }
            if (token.equals("maxy")) {
                theme.maxY = ThemeReader.intParser(theme.maxY, tokens);
                continue;
            }
            if (token.equals("buildfoundation")) {
                theme.buildFoundation = ThemeReader.booleanParser(theme.buildFoundation, tokens);
                continue;
            }
            if (token.equals("sizes")) {
                theme.sizes = ThemeReader.sizeParser(theme.sizes, tokens);
                continue;
            }
            if (token.equals("outside")) {
                theme.outside = ThemeReader.elementParser(theme.outside, tokens);
                continue;
            }
            if (token.equals("liquids")) {
                theme.liquids = ThemeReader.elementParser(theme.liquids, tokens);
                continue;
            }
            if (token.equals("subrooms")) {
                theme.subrooms = ThemeReader.elementParser(theme.subrooms, tokens);
                continue;
            }
            if (token.equals("islands")) {
                theme.islands = ThemeReader.elementParser(theme.islands, tokens);
                continue;
            }
            if (token.equals("pillars")) {
                theme.pillars = ThemeReader.elementParser(theme.pillars, tokens);
                continue;
            }
            if (token.equals("symmetry")) {
                theme.symmetry = ThemeReader.elementParser(theme.symmetry, tokens);
                continue;
            }
            if (token.equals("variability")) {
                theme.variability = ThemeReader.elementParser(theme.variability, tokens);
                continue;
            }
            if (token.equals("degeneracy")) {
                theme.degeneracy = ThemeReader.elementParser(theme.degeneracy, tokens);
                continue;
            }
            if (token.equals("complexity")) {
                theme.complexity = ThemeReader.elementParser(theme.complexity, tokens);
                continue;
            }
            if (token.equals("verticle")) {
                theme.verticle = ThemeReader.elementParser(theme.verticle, tokens);
                continue;
            }
            if (token.equals("entrances")) {
                theme.entrances = ThemeReader.elementParser(theme.entrances, tokens);
                continue;
            }
            if (token.equals("walls")) {
                theme.walls = ThemeReader.blockParser(theme.walls, tokens);
                continue;
            }
            if (token.equals("floors")) {
                theme.floors = ThemeReader.blockParser(theme.floors, tokens);
                continue;
            }
            if (token.equals("ceilings")) {
                theme.ceilings = ThemeReader.blockParser(theme.ceilings, tokens);
                continue;
            }
            if (token.equals("fencing")) {
                theme.fencing = ThemeReader.blockParser(theme.fencing, tokens);
                continue;
            }
            if (token.equals("liquid")) {
                theme.liquid = ThemeReader.blockParser(theme.liquid, tokens);
                continue;
            }
            if (token.equals("pillarblock")) {
                theme.pillarBlock = ThemeReader.blockParser(theme.pillarBlock, tokens);
                continue;
            }
            if (token.equals("commonmobs")) {
                theme.commonMobs = ThemeReader.parseMobs(theme.commonMobs, tokens);
                continue;
            }
            if (token.equals("hardmobs")) {
                theme.hardMobs = ThemeReader.parseMobs(theme.hardMobs, tokens);
                continue;
            }
            if (token.equals("brutemobs")) {
                theme.bruteMobs = ThemeReader.parseMobs(theme.bruteMobs, tokens);
                continue;
            }
            if (token.equals("elitemobs")) {
                theme.eliteMobs = ThemeReader.parseMobs(theme.eliteMobs, tokens);
                continue;
            }
            if (!token.equals("biomes")) continue;
            theme.biomes = ThemeReader.biomeParser(tokens);
        }
        theme.fixMobs();
        theme.biomeRegister();
    }

    private static Element elementParser(Element el, StringTokenizer tokens) {
        boolean valid = false;
        int[] values = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < values.length && tokens.hasMoreTokens(); ++i) {
            String num = tokens.nextToken();
            values[i] = Integer.parseInt(num);
            if (values[i] < 0) {
                values[i] = 0;
            }
            if (values[i] <= 0) continue;
            valid = true;
        }
        if (valid) {
            return new Element(values[0], values[1], values[2], values[3], values[4], values[5]);
        }
        return el;
    }

    private static SizeElement sizeParser(SizeElement el, StringTokenizer tokens) {
        boolean valid = false;
        int[] values = new int[]{0, 0, 0, 0, 0};
        for (int i = 0; i < values.length && tokens.hasMoreTokens(); ++i) {
            String num = tokens.nextToken();
            values[i] = Integer.parseInt(num);
            if (values[i] < 0) {
                values[i] = 0;
            }
            if (values[i] <= 0) continue;
            valid = true;
        }
        if (valid) {
            return new SizeElement(values[0], values[1], values[2], values[3], values[4]);
        }
        return el;
    }

    private static int intParser(int el, StringTokenizer tokens) {
        String num;
        boolean valid = false;
        int value = 0;
        if (tokens.hasMoreTokens() && (value = Integer.parseInt(num = tokens.nextToken())) > 5 && value < 224) {
            valid = true;
        }
        if (valid) {
            return value;
        }
        return el;
    }

    private static boolean booleanParser(boolean el, StringTokenizer tokens) {
        boolean valid = false;
        if (!tokens.hasMoreTokens()) {
            return el;
        }
        boolean bool = Boolean.parseBoolean(tokens.nextToken());
        return bool;
    }

    private static BlockList blockParser(BlockList el, StringTokenizer tokens) {
        BlockList out = new BlockList();
        while (tokens.hasMoreTokens()) {
            out.add(Block.func_149684_b((String)tokens.nextToken()));
        }
        if (out.isEmpty()) {
            return el;
        }
        return out;
    }

    private static ArrayList<String> parseMobs(ArrayList<String> el, StringTokenizer tokens) {
        ArrayList<String> mobs = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            mobs.add(tokens.nextToken());
        }
        return mobs;
    }

    private static EnumSet<BiomeDictionary.Type> biomeParser(StringTokenizer tokens) {
        EnumSet<BiomeDictionary.Type> biomes = EnumSet.noneOf(BiomeDictionary.Type.class);
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (name.equals("FOREST")) {
                biomes.add(BiomeDictionary.Type.FOREST);
                continue;
            }
            if (name.equals("PLAINS")) {
                biomes.add(BiomeDictionary.Type.PLAINS);
                continue;
            }
            if (name.equals("MOUNTAINS")) {
                biomes.add(BiomeDictionary.Type.MOUNTAIN);
                continue;
            }
            if (name.equals("HILLS")) {
                biomes.add(BiomeDictionary.Type.HILLS);
                continue;
            }
            if (name.equals("SWAMP")) {
                biomes.add(BiomeDictionary.Type.SWAMP);
                continue;
            }
            if (name.equals("WATER")) {
                biomes.add(BiomeDictionary.Type.WATER);
                continue;
            }
            if (name.equals("DESERT")) {
                biomes.add(BiomeDictionary.Type.DESERT);
                continue;
            }
            if (name.equals("FROZEN")) {
                biomes.add(BiomeDictionary.Type.FROZEN);
                continue;
            }
            if (name.equals("JUNGLE")) {
                biomes.add(BiomeDictionary.Type.JUNGLE);
                continue;
            }
            if (name.equals("WASTELAND")) {
                biomes.add(BiomeDictionary.Type.WASTELAND);
                continue;
            }
            if (name.equals("BEACH")) {
                biomes.add(BiomeDictionary.Type.BEACH);
                continue;
            }
            if (name.equals("NETHER")) {
                biomes.add(BiomeDictionary.Type.NETHER);
                continue;
            }
            if (name.equals("END")) {
                biomes.add(BiomeDictionary.Type.END);
                continue;
            }
            if (name.equals("MUSHROOM")) {
                biomes.add(BiomeDictionary.Type.MUSHROOM);
                continue;
            }
            if (!name.equals("MAGICAL")) continue;
            biomes.add(BiomeDictionary.Type.MAGICAL);
        }
        return biomes;
    }
}

