/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner;

import jaredbgreat.dldungeons.pieces.Shapes;
import jaredbgreat.dldungeons.planner.Dungeon;

public enum Symmetry {
    NONE(0, 0, false, false, false),
    X(1, 1, true, false, false),
    Y(2, 1, false, true, false),
    XY(3, 2, true, true, false),
    TR1(4, 1, false, false, true),
    TR2(5, 1, false, false, true),
    R(6, 1, false, false, true),
    SW(7, 2, true, true, false);

    public final int ID;
    public final int level;
    public final boolean halfX;
    public final boolean halfZ;
    public final boolean doubler;
    public static final Shapes[] allshapes;
    public static final Shapes[] xsymmetics;
    public static final Shapes[] ysymmetics;
    public static final Shapes[] xysymmetrics;
    public static final Shapes[] transshapes;
    public static final Shapes[] rotateds;
    public static final Shapes[] allPart;
    public static final Shapes[] xsymmetricPart;
    public static final Shapes[] ysymmetricPart;
    public static final Shapes[] xysymmetricPart;
    public static final Shapes[] transPart;
    public static final Shapes[] rotatedPart;
    public static final Shapes[] allSolids;
    public static final Shapes[] xsymmetricSolid;
    public static final Shapes[] ysymmetricSolid;
    public static final Shapes[] xysymmetricSolid;
    public static final Shapes[] transSolid;
    public static final Shapes[] rotatedSolid;

    private Symmetry(int ID, int level, boolean halfX, boolean halfZ, boolean doubler) {
        this.ID = ID;
        this.level = level;
        this.halfX = halfX;
        this.halfZ = halfZ;
        this.doubler = doubler;
    }

    public static Symmetry getSymmetry(Dungeon dungeon) {
        int num = 0;
        if (dungeon.symmetry.use(dungeon.random)) {
            ++num;
        }
        if (dungeon.symmetry.use(dungeon.random)) {
            ++num;
        }
        if (num == 0) {
            return NONE;
        }
        int which = dungeon.random.nextInt(4 / num);
        if (num == 1) {
            switch (which) {
                case 0: {
                    return X;
                }
                case 1: {
                    return Y;
                }
                case 2: {
                    return TR1;
                }
                case 3: {
                    return R;
                }
            }
            return NONE;
        }
        switch (which) {
            case 0: {
                return XY;
            }
            case 1: {
                return SW;
            }
        }
        return NONE;
    }

    static {
        allshapes = new Shapes[]{Shapes.X, Shapes.L, Shapes.O, Shapes.T, Shapes.F, Shapes.E, Shapes.I, Shapes.C, Shapes.U, Shapes.S};
        xsymmetics = new Shapes[]{Shapes.X, Shapes.O, Shapes.E, Shapes.I, Shapes.C};
        ysymmetics = new Shapes[]{Shapes.X, Shapes.O, Shapes.T, Shapes.I, Shapes.C, Shapes.U};
        xysymmetrics = new Shapes[]{Shapes.X, Shapes.O, Shapes.I, Shapes.C};
        transshapes = new Shapes[]{Shapes.X, Shapes.L, Shapes.O, Shapes.C, Shapes.U};
        rotateds = new Shapes[]{Shapes.X, Shapes.O, Shapes.C, Shapes.S};
        allPart = new Shapes[]{Shapes.L, Shapes.O, Shapes.T, Shapes.F, Shapes.E, Shapes.I, Shapes.C, Shapes.U, Shapes.S};
        xsymmetricPart = new Shapes[]{Shapes.O, Shapes.E, Shapes.I, Shapes.C};
        ysymmetricPart = new Shapes[]{Shapes.O, Shapes.T, Shapes.I, Shapes.C, Shapes.U};
        xysymmetricPart = new Shapes[]{Shapes.O, Shapes.I, Shapes.C};
        transPart = new Shapes[]{Shapes.L, Shapes.O, Shapes.C, Shapes.U};
        rotatedPart = new Shapes[]{Shapes.X, Shapes.O, Shapes.C, Shapes.S};
        allSolids = new Shapes[]{Shapes.X, Shapes.L, Shapes.T, Shapes.F, Shapes.E, Shapes.I, Shapes.C, Shapes.U, Shapes.S};
        xsymmetricSolid = new Shapes[]{Shapes.X, Shapes.E, Shapes.I, Shapes.C};
        ysymmetricSolid = new Shapes[]{Shapes.X, Shapes.T, Shapes.I, Shapes.C, Shapes.U};
        xysymmetricSolid = new Shapes[]{Shapes.X, Shapes.I, Shapes.C};
        transSolid = new Shapes[]{Shapes.X, Shapes.L, Shapes.C, Shapes.U};
        rotatedSolid = new Shapes[]{Shapes.X, Shapes.C, Shapes.S};
    }
}

