/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner.mapping;

import jaredbgreat.dldungeons.builder.Builder;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.rooms.Room;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class MapMatrix {
    public World world;
    public int chunkX;
    public int chunkZ;
    public int origenX;
    public int origenZ;
    public byte[][] ceilY;
    public byte[][] floorY;
    public byte[][] nCeilY;
    public byte[][] nFloorY;
    public Block[][] ceiling;
    public Block[][] wall;
    public Block[][] floor;
    public int[][] room;
    public boolean[][] isWall;
    public boolean[][] hasLiquid;
    public boolean[][] isDoor;

    public MapMatrix(int width, World world, int chunkX, int chunkZ) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.origenX = chunkX * 16 - width / 2 + 8;
        this.origenZ = chunkZ * 16 - width / 2 + 8;
        this.ceilY = new byte[width][width];
        this.floorY = new byte[width][width];
        this.nCeilY = new byte[width][width];
        this.nFloorY = new byte[width][width];
        this.room = new int[width][width];
        this.ceiling = new Block[width][width];
        this.wall = new Block[width][width];
        this.floor = new Block[width][width];
        this.isWall = new boolean[width][width];
        this.hasLiquid = new boolean[width][width];
        this.isDoor = new boolean[width][width];
    }

    public void build(Dungeon dungeon) {
        Block glowstone = Block.func_149684_b((String)"glowstone");
        int shiftX = this.chunkX * 16 - this.room.length / 2 + 8;
        int shiftZ = this.chunkZ * 16 - this.room.length / 2 + 8;
        for (int i = 0; i < this.room.length; ++i) {
            for (int j = 0; j < this.room.length; ++j) {
                int k;
                if (this.room[i][j] == 0) continue;
                Room theRoom = dungeon.rooms.get(this.room[i][j]);
                if (this.nFloorY[i][j] < this.floorY[i][j]) {
                    for (k = this.nFloorY[i][j]; k < this.floorY[i][j]; ++k) {
                        if (!this.noLowDegenerate(theRoom, shiftX + i, k, shiftZ + j)) continue;
                        Builder.placeBlock(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                    }
                }
                if (this.nFloorY[i][j] > this.floorY[i][j]) {
                    for (k = this.floorY[i][j]; k < this.nFloorY[i][j]; ++k) {
                        if (!this.noLowDegenerate(theRoom, shiftX + i, k, shiftZ + j)) continue;
                        Builder.placeBlock(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                    }
                }
                if (this.noLowDegenerate(theRoom, shiftX + i, this.floorY[i][j] - 1, shiftZ + j)) {
                    Builder.placeBlock(this.world, shiftX + i, this.floorY[i][j] - 1, shiftZ + j, this.floor[i][j]);
                    if (dungeon.theme.buildFoundation) {
                        int below;
                        int n = below = this.nFloorY[i][j] < this.floorY[i][j] ? this.nFloorY[i][j] - 1 : this.floorY[i][j] - 2;
                        while (!Builder.isGroundBlock(this.world, shiftX + i, below, shiftZ + j)) {
                            Builder.placeBlock(this.world, shiftX + i, below, shiftZ + j, dungeon.floorBlock);
                            --below;
                        }
                    }
                }
                if (!theRoom.sky && this.noHighDegenerate(theRoom, shiftX + i, this.ceilY[i][j] + 1, shiftZ + j)) {
                    Builder.placeBlock(this.world, shiftX + i, this.ceilY[i][j] + 1, shiftZ + j, this.ceiling[i][j]);
                }
                for (k = this.floorY[i][j]; k <= this.ceilY[i][j]; ++k) {
                    if (!this.isWall[i][j]) {
                        Builder.deleteBlock(this.world, shiftX + i, k, shiftZ + j);
                        continue;
                    }
                    if (!this.noHighDegenerate(theRoom, shiftX + i, k, shiftZ + j)) continue;
                    Builder.placeBlock(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                }
                for (k = this.nCeilY[i][j]; k < this.ceilY[i][j]; ++k) {
                    if (!this.noHighDegenerate(theRoom, shiftX + i, k, shiftZ + j)) continue;
                    Builder.placeBlock(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                }
                if (this.isDoor[i][j]) {
                    Builder.deleteBlock(this.world, shiftX + i, this.floorY[i][j], shiftZ + j);
                    Builder.deleteBlock(this.world, shiftX + i, this.floorY[i][j] + 1, shiftZ + j);
                }
                if (!this.hasLiquid[i][j] || this.isWall[i][j] || this.world.func_147437_c(shiftX + i, this.floorY[i][j] - 1, shiftZ + j)) continue;
                Builder.placeBlock(this.world, shiftX + i, this.floorY[i][j], shiftZ + j, theRoom.liquidBlock);
            }
        }
        dungeon.addSpawners();
    }

    private boolean noHighDegenerate(Room theRoom, int x, int y, int z) {
        return !theRoom.degenerate || !this.world.func_147437_c(x, y, z);
    }

    private boolean noLowDegenerate(Room theRoom, int x, int y, int z) {
        return !theRoom.degenerateFloors || !this.world.func_147437_c(x, y, z);
    }
}

