/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.rooms;

import jaredbgreat.dldungeons.planner.Dungeon;
import net.minecraft.block.Block;

public abstract class AbstractRoom {
    public Block wallBlock1;
    public Block floorBlock;
    public Block cielingBlock;
    public Block fenceBlock;
    public Block pillarBlock;
    public Block liquidBlock;
    public boolean degenerate;
    public boolean degenerateFloors;
    public boolean sky;
    Block wallBlock;

    protected AbstractRoom() {
        this.wallBlock1 = null;
        this.floorBlock = null;
        this.cielingBlock = null;
        this.fenceBlock = null;
        this.pillarBlock = null;
        this.liquidBlock = null;
    }

    public AbstractRoom(Dungeon dungeon, AbstractRoom previous) {
        if (previous != null && !dungeon.variability.use(dungeon.random)) {
            this.wallBlock1 = previous.wallBlock1;
            this.floorBlock = previous.floorBlock;
            this.cielingBlock = previous.cielingBlock;
            this.fenceBlock = previous.fenceBlock;
            this.pillarBlock = previous.pillarBlock;
            this.liquidBlock = previous.liquidBlock;
        } else if (dungeon.variability.use(dungeon.random)) {
            if (dungeon.variability.use(dungeon.random)) {
                this.wallBlock1 = dungeon.theme.walls.choose(dungeon.random);
                this.floorBlock = dungeon.theme.floors.choose(dungeon.random);
                this.cielingBlock = dungeon.theme.ceilings.choose(dungeon.random);
                this.fenceBlock = dungeon.theme.fencing.choose(dungeon.random);
                this.pillarBlock = dungeon.theme.pillarBlock.choose(dungeon.random);
                this.liquidBlock = dungeon.theme.liquid.choose(dungeon.random);
            } else {
                this.wallBlock1 = !dungeon.variability.use(dungeon.random) ? dungeon.wallBlock1 : dungeon.theme.walls.choose(dungeon.random);
                this.floorBlock = !dungeon.variability.use(dungeon.random) ? dungeon.floorBlock : dungeon.theme.floors.choose(dungeon.random);
                this.cielingBlock = !dungeon.variability.use(dungeon.random) ? dungeon.cielingBlock : dungeon.theme.ceilings.choose(dungeon.random);
                this.fenceBlock = !dungeon.variability.use(dungeon.random) ? dungeon.fenceBlock : dungeon.theme.fencing.choose(dungeon.random);
                this.pillarBlock = !dungeon.variability.use(dungeon.random) ? dungeon.cornerBlock : dungeon.theme.pillarBlock.choose(dungeon.random);
                this.liquidBlock = !dungeon.variability.use(dungeon.random) ? dungeon.liquidBlock : dungeon.theme.liquid.choose(dungeon.random);
            }
        } else {
            this.wallBlock1 = dungeon.wallBlock1;
            this.floorBlock = dungeon.floorBlock;
            this.cielingBlock = dungeon.cielingBlock;
            this.fenceBlock = dungeon.fenceBlock;
            this.pillarBlock = dungeon.cornerBlock;
            this.liquidBlock = dungeon.liquidBlock;
        }
        if (dungeon.outside.value > 0) {
            this.sky = dungeon.outside.use(dungeon.random);
        }
        if (dungeon.degeneracy.value > 0) {
            this.degenerate = dungeon.degeneracy.use(dungeon.random);
            this.degenerateFloors = this.degenerate && dungeon.degeneracy.use(dungeon.random) && dungeon.random.nextBoolean();
        }
    }

    public Block getWallBlock() {
        return this.wallBlock1;
    }

    public Block getFloorBlock() {
        return this.floorBlock;
    }

    public Block getCielingBlock() {
        return this.cielingBlock;
    }

    public Block getFenceBlock() {
        return this.fenceBlock;
    }

    public Block getCornerBlock() {
        return this.pillarBlock;
    }

    public Block getLiquidBlock() {
        return this.liquidBlock;
    }
}

